# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricsResource(object):
    """
    Provides metrics on storage gateway resource capacity and utilization.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricsResource object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cpu:
            The value to assign to the cpu property of this MetricsResource.
        :type cpu: MetricsResourceCpu

        :param memory:
            The value to assign to the memory property of this MetricsResource.
        :type memory: MetricsResourceMem

        :param cache:
            The value to assign to the cache property of this MetricsResource.
        :type cache: MetricsResourceCache

        :param metadata:
            The value to assign to the metadata property of this MetricsResource.
        :type metadata: MetricsResourceMetadata

        :param log:
            The value to assign to the log property of this MetricsResource.
        :type log: MetricsResourceLog

        :param filesystems:
            The value to assign to the filesystems property of this MetricsResource.
        :type filesystems: MetricsResourceFilesystems

        :param cloudsyncs:
            The value to assign to the cloudsyncs property of this MetricsResource.
        :type cloudsyncs: MetricsResourceCloudsyncs

        """
        self.swagger_types = {
            'cpu': 'MetricsResourceCpu',
            'memory': 'MetricsResourceMem',
            'cache': 'MetricsResourceCache',
            'metadata': 'MetricsResourceMetadata',
            'log': 'MetricsResourceLog',
            'filesystems': 'MetricsResourceFilesystems',
            'cloudsyncs': 'MetricsResourceCloudsyncs'
        }

        self.attribute_map = {
            'cpu': 'cpu',
            'memory': 'memory',
            'cache': 'cache',
            'metadata': 'metadata',
            'log': 'log',
            'filesystems': 'filesystems',
            'cloudsyncs': 'cloudsyncs'
        }

        self._cpu = None
        self._memory = None
        self._cache = None
        self._metadata = None
        self._log = None
        self._filesystems = None
        self._cloudsyncs = None

    @property
    def cpu(self):
        """
        Gets the cpu of this MetricsResource.
        CPU resource information.


        :return: The cpu of this MetricsResource.
        :rtype: MetricsResourceCpu
        """
        return self._cpu

    @cpu.setter
    def cpu(self, cpu):
        """
        Sets the cpu of this MetricsResource.
        CPU resource information.


        :param cpu: The cpu of this MetricsResource.
        :type: MetricsResourceCpu
        """
        self._cpu = cpu

    @property
    def memory(self):
        """
        Gets the memory of this MetricsResource.
        Memory resource information.


        :return: The memory of this MetricsResource.
        :rtype: MetricsResourceMem
        """
        return self._memory

    @memory.setter
    def memory(self, memory):
        """
        Sets the memory of this MetricsResource.
        Memory resource information.


        :param memory: The memory of this MetricsResource.
        :type: MetricsResourceMem
        """
        self._memory = memory

    @property
    def cache(self):
        """
        Gets the cache of this MetricsResource.
        File system cache resource information.


        :return: The cache of this MetricsResource.
        :rtype: MetricsResourceCache
        """
        return self._cache

    @cache.setter
    def cache(self, cache):
        """
        Sets the cache of this MetricsResource.
        File system cache resource information.


        :param cache: The cache of this MetricsResource.
        :type: MetricsResourceCache
        """
        self._cache = cache

    @property
    def metadata(self):
        """
        Gets the metadata of this MetricsResource.
        Metadata storage resource information.


        :return: The metadata of this MetricsResource.
        :rtype: MetricsResourceMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this MetricsResource.
        Metadata storage resource information.


        :param metadata: The metadata of this MetricsResource.
        :type: MetricsResourceMetadata
        """
        self._metadata = metadata

    @property
    def log(self):
        """
        Gets the log of this MetricsResource.
        Log storage resource information.


        :return: The log of this MetricsResource.
        :rtype: MetricsResourceLog
        """
        return self._log

    @log.setter
    def log(self, log):
        """
        Sets the log of this MetricsResource.
        Log storage resource information.


        :param log: The log of this MetricsResource.
        :type: MetricsResourceLog
        """
        self._log = log

    @property
    def filesystems(self):
        """
        Gets the filesystems of this MetricsResource.
        File systems resource information.


        :return: The filesystems of this MetricsResource.
        :rtype: MetricsResourceFilesystems
        """
        return self._filesystems

    @filesystems.setter
    def filesystems(self, filesystems):
        """
        Sets the filesystems of this MetricsResource.
        File systems resource information.


        :param filesystems: The filesystems of this MetricsResource.
        :type: MetricsResourceFilesystems
        """
        self._filesystems = filesystems

    @property
    def cloudsyncs(self):
        """
        Gets the cloudsyncs of this MetricsResource.
        Cloud syncs resource information.


        :return: The cloudsyncs of this MetricsResource.
        :rtype: MetricsResourceCloudsyncs
        """
        return self._cloudsyncs

    @cloudsyncs.setter
    def cloudsyncs(self, cloudsyncs):
        """
        Sets the cloudsyncs of this MetricsResource.
        Cloud syncs resource information.


        :param cloudsyncs: The cloudsyncs of this MetricsResource.
        :type: MetricsResourceCloudsyncs
        """
        self._cloudsyncs = cloudsyncs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
