# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricsResourceFilesystems(object):
    """
    File systems resource information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricsResourceFilesystems object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param max_count:
            The value to assign to the max_count property of this MetricsResourceFilesystems.
        :type max_count: float

        """
        self.swagger_types = {
            'max_count': 'float'
        }

        self.attribute_map = {
            'max_count': 'maxCount'
        }

        self._max_count = None

    @property
    def max_count(self):
        """
        Gets the max_count of this MetricsResourceFilesystems.
        The maximum number of file systems that can be created per storage gateway.

        Example: `10`


        :return: The max_count of this MetricsResourceFilesystems.
        :rtype: float
        """
        return self._max_count

    @max_count.setter
    def max_count(self, max_count):
        """
        Sets the max_count of this MetricsResourceFilesystems.
        The maximum number of file systems that can be created per storage gateway.

        Example: `10`


        :param max_count: The max_count of this MetricsResourceFilesystems.
        :type: float
        """
        self._max_count = max_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
