# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricsResourceMetadata(object):
    """
    Metadata storage resource information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricsResourceMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param size_in_bytes:
            The value to assign to the size_in_bytes property of this MetricsResourceMetadata.
        :type size_in_bytes: float

        """
        self.swagger_types = {
            'size_in_bytes': 'float'
        }

        self.attribute_map = {
            'size_in_bytes': 'sizeInBytes'
        }

        self._size_in_bytes = None

    @property
    def size_in_bytes(self):
        """
        Gets the size_in_bytes of this MetricsResourceMetadata.
        The total configured metadata storage size in bytes.

        Example: `85899345920`


        :return: The size_in_bytes of this MetricsResourceMetadata.
        :rtype: float
        """
        return self._size_in_bytes

    @size_in_bytes.setter
    def size_in_bytes(self, size_in_bytes):
        """
        Sets the size_in_bytes of this MetricsResourceMetadata.
        The total configured metadata storage size in bytes.

        Example: `85899345920`


        :param size_in_bytes: The size_in_bytes of this MetricsResourceMetadata.
        :type: float
        """
        self._size_in_bytes = size_in_bytes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
