# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricsStats(object):
    """
    Storage Gateway statistics.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricsStats object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cpu:
            The value to assign to the cpu property of this MetricsStats.
        :type cpu: MetricsStatsCpu

        :param memory:
            The value to assign to the memory property of this MetricsStats.
        :type memory: MetricsStatsMem

        :param cache:
            The value to assign to the cache property of this MetricsStats.
        :type cache: MetricsStatsCache

        :param metadata:
            The value to assign to the metadata property of this MetricsStats.
        :type metadata: MetricsStatsMetadata

        :param log:
            The value to assign to the log property of this MetricsStats.
        :type log: MetricsStatsLog

        :param filesystems:
            The value to assign to the filesystems property of this MetricsStats.
        :type filesystems: MetricsStatsFilesystems

        :param cloudsyncs:
            The value to assign to the cloudsyncs property of this MetricsStats.
        :type cloudsyncs: MetricsStatsCloudsyncs

        :param data:
            The value to assign to the data property of this MetricsStats.
        :type data: MetricsStatsData

        """
        self.swagger_types = {
            'cpu': 'MetricsStatsCpu',
            'memory': 'MetricsStatsMem',
            'cache': 'MetricsStatsCache',
            'metadata': 'MetricsStatsMetadata',
            'log': 'MetricsStatsLog',
            'filesystems': 'MetricsStatsFilesystems',
            'cloudsyncs': 'MetricsStatsCloudsyncs',
            'data': 'MetricsStatsData'
        }

        self.attribute_map = {
            'cpu': 'cpu',
            'memory': 'memory',
            'cache': 'cache',
            'metadata': 'metadata',
            'log': 'log',
            'filesystems': 'filesystems',
            'cloudsyncs': 'cloudsyncs',
            'data': 'data'
        }

        self._cpu = None
        self._memory = None
        self._cache = None
        self._metadata = None
        self._log = None
        self._filesystems = None
        self._cloudsyncs = None
        self._data = None

    @property
    def cpu(self):
        """
        Gets the cpu of this MetricsStats.
        CPU statistics.


        :return: The cpu of this MetricsStats.
        :rtype: MetricsStatsCpu
        """
        return self._cpu

    @cpu.setter
    def cpu(self, cpu):
        """
        Sets the cpu of this MetricsStats.
        CPU statistics.


        :param cpu: The cpu of this MetricsStats.
        :type: MetricsStatsCpu
        """
        self._cpu = cpu

    @property
    def memory(self):
        """
        Gets the memory of this MetricsStats.
        Memory statistics.


        :return: The memory of this MetricsStats.
        :rtype: MetricsStatsMem
        """
        return self._memory

    @memory.setter
    def memory(self, memory):
        """
        Sets the memory of this MetricsStats.
        Memory statistics.


        :param memory: The memory of this MetricsStats.
        :type: MetricsStatsMem
        """
        self._memory = memory

    @property
    def cache(self):
        """
        Gets the cache of this MetricsStats.
        File system cache statistics.


        :return: The cache of this MetricsStats.
        :rtype: MetricsStatsCache
        """
        return self._cache

    @cache.setter
    def cache(self, cache):
        """
        Sets the cache of this MetricsStats.
        File system cache statistics.


        :param cache: The cache of this MetricsStats.
        :type: MetricsStatsCache
        """
        self._cache = cache

    @property
    def metadata(self):
        """
        Gets the metadata of this MetricsStats.
        Metadata storage statistics.


        :return: The metadata of this MetricsStats.
        :rtype: MetricsStatsMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this MetricsStats.
        Metadata storage statistics.


        :param metadata: The metadata of this MetricsStats.
        :type: MetricsStatsMetadata
        """
        self._metadata = metadata

    @property
    def log(self):
        """
        Gets the log of this MetricsStats.
        Log storage statistics.


        :return: The log of this MetricsStats.
        :rtype: MetricsStatsLog
        """
        return self._log

    @log.setter
    def log(self, log):
        """
        Sets the log of this MetricsStats.
        Log storage statistics.


        :param log: The log of this MetricsStats.
        :type: MetricsStatsLog
        """
        self._log = log

    @property
    def filesystems(self):
        """
        Gets the filesystems of this MetricsStats.
        File systems statistics.


        :return: The filesystems of this MetricsStats.
        :rtype: MetricsStatsFilesystems
        """
        return self._filesystems

    @filesystems.setter
    def filesystems(self, filesystems):
        """
        Sets the filesystems of this MetricsStats.
        File systems statistics.


        :param filesystems: The filesystems of this MetricsStats.
        :type: MetricsStatsFilesystems
        """
        self._filesystems = filesystems

    @property
    def cloudsyncs(self):
        """
        Gets the cloudsyncs of this MetricsStats.
        Cloud syncs statistics.


        :return: The cloudsyncs of this MetricsStats.
        :rtype: MetricsStatsCloudsyncs
        """
        return self._cloudsyncs

    @cloudsyncs.setter
    def cloudsyncs(self, cloudsyncs):
        """
        Sets the cloudsyncs of this MetricsStats.
        Cloud syncs statistics.


        :param cloudsyncs: The cloudsyncs of this MetricsStats.
        :type: MetricsStatsCloudsyncs
        """
        self._cloudsyncs = cloudsyncs

    @property
    def data(self):
        """
        Gets the data of this MetricsStats.
        Data activity statistics.


        :return: The data of this MetricsStats.
        :rtype: MetricsStatsData
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this MetricsStats.
        Data activity statistics.


        :param data: The data of this MetricsStats.
        :type: MetricsStatsData
        """
        self._data = data

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
