# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricsStatsCache(object):
    """
    File system cache statistics.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricsStatsCache object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param util_percent:
            The value to assign to the util_percent property of this MetricsStatsCache.
        :type util_percent: float

        :param hit_percent:
            The value to assign to the hit_percent property of this MetricsStatsCache.
        :type hit_percent: float

        """
        self.swagger_types = {
            'util_percent': 'float',
            'hit_percent': 'float'
        }

        self.attribute_map = {
            'util_percent': 'utilPercent',
            'hit_percent': 'hitPercent'
        }

        self._util_percent = None
        self._hit_percent = None

    @property
    def util_percent(self):
        """
        Gets the util_percent of this MetricsStatsCache.
        File system cache utilization (percent).

        Example: `45`


        :return: The util_percent of this MetricsStatsCache.
        :rtype: float
        """
        return self._util_percent

    @util_percent.setter
    def util_percent(self, util_percent):
        """
        Sets the util_percent of this MetricsStatsCache.
        File system cache utilization (percent).

        Example: `45`


        :param util_percent: The util_percent of this MetricsStatsCache.
        :type: float
        """
        self._util_percent = util_percent

    @property
    def hit_percent(self):
        """
        Gets the hit_percent of this MetricsStatsCache.
        File system hits (percent).

        Example: `80`


        :return: The hit_percent of this MetricsStatsCache.
        :rtype: float
        """
        return self._hit_percent

    @hit_percent.setter
    def hit_percent(self, hit_percent):
        """
        Sets the hit_percent of this MetricsStatsCache.
        File system hits (percent).

        Example: `80`


        :param hit_percent: The hit_percent of this MetricsStatsCache.
        :type: float
        """
        self._hit_percent = hit_percent

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
