# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricsStatsCloudsyncs(object):
    """
    Cloud syncs statistics.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricsStatsCloudsyncs object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param count:
            The value to assign to the count property of this MetricsStatsCloudsyncs.
        :type count: float

        :param running_count:
            The value to assign to the running_count property of this MetricsStatsCloudsyncs.
        :type running_count: float

        :param created_count:
            The value to assign to the created_count property of this MetricsStatsCloudsyncs.
        :type created_count: float

        :param completed_count:
            The value to assign to the completed_count property of this MetricsStatsCloudsyncs.
        :type completed_count: float

        :param canceled_count:
            The value to assign to the canceled_count property of this MetricsStatsCloudsyncs.
        :type canceled_count: float

        :param failed_count:
            The value to assign to the failed_count property of this MetricsStatsCloudsyncs.
        :type failed_count: float

        :param upload_count:
            The value to assign to the upload_count property of this MetricsStatsCloudsyncs.
        :type upload_count: float

        :param download_count:
            The value to assign to the download_count property of this MetricsStatsCloudsyncs.
        :type download_count: float

        """
        self.swagger_types = {
            'count': 'float',
            'running_count': 'float',
            'created_count': 'float',
            'completed_count': 'float',
            'canceled_count': 'float',
            'failed_count': 'float',
            'upload_count': 'float',
            'download_count': 'float'
        }

        self.attribute_map = {
            'count': 'count',
            'running_count': 'runningCount',
            'created_count': 'createdCount',
            'completed_count': 'completedCount',
            'canceled_count': 'canceledCount',
            'failed_count': 'failedCount',
            'upload_count': 'uploadCount',
            'download_count': 'downloadCount'
        }

        self._count = None
        self._running_count = None
        self._created_count = None
        self._completed_count = None
        self._canceled_count = None
        self._failed_count = None
        self._upload_count = None
        self._download_count = None

    @property
    def count(self):
        """
        Gets the count of this MetricsStatsCloudsyncs.
        Total number of cloud syncs.

        Example: `7`


        :return: The count of this MetricsStatsCloudsyncs.
        :rtype: float
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this MetricsStatsCloudsyncs.
        Total number of cloud syncs.

        Example: `7`


        :param count: The count of this MetricsStatsCloudsyncs.
        :type: float
        """
        self._count = count

    @property
    def running_count(self):
        """
        Gets the running_count of this MetricsStatsCloudsyncs.
        Number of running cloud syncs.

        Example: `1`


        :return: The running_count of this MetricsStatsCloudsyncs.
        :rtype: float
        """
        return self._running_count

    @running_count.setter
    def running_count(self, running_count):
        """
        Sets the running_count of this MetricsStatsCloudsyncs.
        Number of running cloud syncs.

        Example: `1`


        :param running_count: The running_count of this MetricsStatsCloudsyncs.
        :type: float
        """
        self._running_count = running_count

    @property
    def created_count(self):
        """
        Gets the created_count of this MetricsStatsCloudsyncs.
        Number of created cloud syncs.

        Example: `2`


        :return: The created_count of this MetricsStatsCloudsyncs.
        :rtype: float
        """
        return self._created_count

    @created_count.setter
    def created_count(self, created_count):
        """
        Sets the created_count of this MetricsStatsCloudsyncs.
        Number of created cloud syncs.

        Example: `2`


        :param created_count: The created_count of this MetricsStatsCloudsyncs.
        :type: float
        """
        self._created_count = created_count

    @property
    def completed_count(self):
        """
        Gets the completed_count of this MetricsStatsCloudsyncs.
        Number of completed cloud syncs.

        Example: `3`


        :return: The completed_count of this MetricsStatsCloudsyncs.
        :rtype: float
        """
        return self._completed_count

    @completed_count.setter
    def completed_count(self, completed_count):
        """
        Sets the completed_count of this MetricsStatsCloudsyncs.
        Number of completed cloud syncs.

        Example: `3`


        :param completed_count: The completed_count of this MetricsStatsCloudsyncs.
        :type: float
        """
        self._completed_count = completed_count

    @property
    def canceled_count(self):
        """
        Gets the canceled_count of this MetricsStatsCloudsyncs.
        Number of canceled cloud syncs.

        Example: `1`


        :return: The canceled_count of this MetricsStatsCloudsyncs.
        :rtype: float
        """
        return self._canceled_count

    @canceled_count.setter
    def canceled_count(self, canceled_count):
        """
        Sets the canceled_count of this MetricsStatsCloudsyncs.
        Number of canceled cloud syncs.

        Example: `1`


        :param canceled_count: The canceled_count of this MetricsStatsCloudsyncs.
        :type: float
        """
        self._canceled_count = canceled_count

    @property
    def failed_count(self):
        """
        Gets the failed_count of this MetricsStatsCloudsyncs.
        Number of failed cloud syncs.

        Example: `0`


        :return: The failed_count of this MetricsStatsCloudsyncs.
        :rtype: float
        """
        return self._failed_count

    @failed_count.setter
    def failed_count(self, failed_count):
        """
        Sets the failed_count of this MetricsStatsCloudsyncs.
        Number of failed cloud syncs.

        Example: `0`


        :param failed_count: The failed_count of this MetricsStatsCloudsyncs.
        :type: float
        """
        self._failed_count = failed_count

    @property
    def upload_count(self):
        """
        Gets the upload_count of this MetricsStatsCloudsyncs.
        Number of upload cloud syncs.

        Example: `4`


        :return: The upload_count of this MetricsStatsCloudsyncs.
        :rtype: float
        """
        return self._upload_count

    @upload_count.setter
    def upload_count(self, upload_count):
        """
        Sets the upload_count of this MetricsStatsCloudsyncs.
        Number of upload cloud syncs.

        Example: `4`


        :param upload_count: The upload_count of this MetricsStatsCloudsyncs.
        :type: float
        """
        self._upload_count = upload_count

    @property
    def download_count(self):
        """
        Gets the download_count of this MetricsStatsCloudsyncs.
        Number of download cloud syncs.

        Example: `3`


        :return: The download_count of this MetricsStatsCloudsyncs.
        :rtype: float
        """
        return self._download_count

    @download_count.setter
    def download_count(self, download_count):
        """
        Sets the download_count of this MetricsStatsCloudsyncs.
        Number of download cloud syncs.

        Example: `3`


        :param download_count: The download_count of this MetricsStatsCloudsyncs.
        :type: float
        """
        self._download_count = download_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
