# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricsStatsData(object):
    """
    Data activity statistics.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricsStatsData object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param uploaded_data_in_bytes:
            The value to assign to the uploaded_data_in_bytes property of this MetricsStatsData.
        :type uploaded_data_in_bytes: float

        :param downloaded_data_in_bytes:
            The value to assign to the downloaded_data_in_bytes property of this MetricsStatsData.
        :type downloaded_data_in_bytes: float

        :param write_data_in_bytes:
            The value to assign to the write_data_in_bytes property of this MetricsStatsData.
        :type write_data_in_bytes: float

        :param read_data_in_bytes:
            The value to assign to the read_data_in_bytes property of this MetricsStatsData.
        :type read_data_in_bytes: float

        :param pending_data_in_bytes:
            The value to assign to the pending_data_in_bytes property of this MetricsStatsData.
        :type pending_data_in_bytes: float

        :param upload_throughput_in_m_bps:
            The value to assign to the upload_throughput_in_m_bps property of this MetricsStatsData.
        :type upload_throughput_in_m_bps: float

        :param download_throughput_in_m_bps:
            The value to assign to the download_throughput_in_m_bps property of this MetricsStatsData.
        :type download_throughput_in_m_bps: float

        """
        self.swagger_types = {
            'uploaded_data_in_bytes': 'float',
            'downloaded_data_in_bytes': 'float',
            'write_data_in_bytes': 'float',
            'read_data_in_bytes': 'float',
            'pending_data_in_bytes': 'float',
            'upload_throughput_in_m_bps': 'float',
            'download_throughput_in_m_bps': 'float'
        }

        self.attribute_map = {
            'uploaded_data_in_bytes': 'uploadedDataInBytes',
            'downloaded_data_in_bytes': 'downloadedDataInBytes',
            'write_data_in_bytes': 'writeDataInBytes',
            'read_data_in_bytes': 'readDataInBytes',
            'pending_data_in_bytes': 'pendingDataInBytes',
            'upload_throughput_in_m_bps': 'uploadThroughputInMBps',
            'download_throughput_in_m_bps': 'downloadThroughputInMBps'
        }

        self._uploaded_data_in_bytes = None
        self._downloaded_data_in_bytes = None
        self._write_data_in_bytes = None
        self._read_data_in_bytes = None
        self._pending_data_in_bytes = None
        self._upload_throughput_in_m_bps = None
        self._download_throughput_in_m_bps = None

    @property
    def uploaded_data_in_bytes(self):
        """
        Gets the uploaded_data_in_bytes of this MetricsStatsData.
        Uploaded data in bytes.

        Example: `134217728000`


        :return: The uploaded_data_in_bytes of this MetricsStatsData.
        :rtype: float
        """
        return self._uploaded_data_in_bytes

    @uploaded_data_in_bytes.setter
    def uploaded_data_in_bytes(self, uploaded_data_in_bytes):
        """
        Sets the uploaded_data_in_bytes of this MetricsStatsData.
        Uploaded data in bytes.

        Example: `134217728000`


        :param uploaded_data_in_bytes: The uploaded_data_in_bytes of this MetricsStatsData.
        :type: float
        """
        self._uploaded_data_in_bytes = uploaded_data_in_bytes

    @property
    def downloaded_data_in_bytes(self):
        """
        Gets the downloaded_data_in_bytes of this MetricsStatsData.
        Downloaded data in bytes.

        Example: `80530636800`


        :return: The downloaded_data_in_bytes of this MetricsStatsData.
        :rtype: float
        """
        return self._downloaded_data_in_bytes

    @downloaded_data_in_bytes.setter
    def downloaded_data_in_bytes(self, downloaded_data_in_bytes):
        """
        Sets the downloaded_data_in_bytes of this MetricsStatsData.
        Downloaded data in bytes.

        Example: `80530636800`


        :param downloaded_data_in_bytes: The downloaded_data_in_bytes of this MetricsStatsData.
        :type: float
        """
        self._downloaded_data_in_bytes = downloaded_data_in_bytes

    @property
    def write_data_in_bytes(self):
        """
        Gets the write_data_in_bytes of this MetricsStatsData.
        Write (ingestion) data in bytes.

        Example: `53687091200`


        :return: The write_data_in_bytes of this MetricsStatsData.
        :rtype: float
        """
        return self._write_data_in_bytes

    @write_data_in_bytes.setter
    def write_data_in_bytes(self, write_data_in_bytes):
        """
        Sets the write_data_in_bytes of this MetricsStatsData.
        Write (ingestion) data in bytes.

        Example: `53687091200`


        :param write_data_in_bytes: The write_data_in_bytes of this MetricsStatsData.
        :type: float
        """
        self._write_data_in_bytes = write_data_in_bytes

    @property
    def read_data_in_bytes(self):
        """
        Gets the read_data_in_bytes of this MetricsStatsData.
        Read data in bytes.

        Example: `64424509440`


        :return: The read_data_in_bytes of this MetricsStatsData.
        :rtype: float
        """
        return self._read_data_in_bytes

    @read_data_in_bytes.setter
    def read_data_in_bytes(self, read_data_in_bytes):
        """
        Sets the read_data_in_bytes of this MetricsStatsData.
        Read data in bytes.

        Example: `64424509440`


        :param read_data_in_bytes: The read_data_in_bytes of this MetricsStatsData.
        :type: float
        """
        self._read_data_in_bytes = read_data_in_bytes

    @property
    def pending_data_in_bytes(self):
        """
        Gets the pending_data_in_bytes of this MetricsStatsData.
        Pending data in bytes.

        Example: `5368709120`


        :return: The pending_data_in_bytes of this MetricsStatsData.
        :rtype: float
        """
        return self._pending_data_in_bytes

    @pending_data_in_bytes.setter
    def pending_data_in_bytes(self, pending_data_in_bytes):
        """
        Sets the pending_data_in_bytes of this MetricsStatsData.
        Pending data in bytes.

        Example: `5368709120`


        :param pending_data_in_bytes: The pending_data_in_bytes of this MetricsStatsData.
        :type: float
        """
        self._pending_data_in_bytes = pending_data_in_bytes

    @property
    def upload_throughput_in_m_bps(self):
        """
        Gets the upload_throughput_in_m_bps of this MetricsStatsData.
        Upload throughput in megabytes per second.


        :return: The upload_throughput_in_m_bps of this MetricsStatsData.
        :rtype: float
        """
        return self._upload_throughput_in_m_bps

    @upload_throughput_in_m_bps.setter
    def upload_throughput_in_m_bps(self, upload_throughput_in_m_bps):
        """
        Sets the upload_throughput_in_m_bps of this MetricsStatsData.
        Upload throughput in megabytes per second.


        :param upload_throughput_in_m_bps: The upload_throughput_in_m_bps of this MetricsStatsData.
        :type: float
        """
        self._upload_throughput_in_m_bps = upload_throughput_in_m_bps

    @property
    def download_throughput_in_m_bps(self):
        """
        Gets the download_throughput_in_m_bps of this MetricsStatsData.
        Download throughput in megabytes per second.


        :return: The download_throughput_in_m_bps of this MetricsStatsData.
        :rtype: float
        """
        return self._download_throughput_in_m_bps

    @download_throughput_in_m_bps.setter
    def download_throughput_in_m_bps(self, download_throughput_in_m_bps):
        """
        Sets the download_throughput_in_m_bps of this MetricsStatsData.
        Download throughput in megabytes per second.


        :param download_throughput_in_m_bps: The download_throughput_in_m_bps of this MetricsStatsData.
        :type: float
        """
        self._download_throughput_in_m_bps = download_throughput_in_m_bps

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
