# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricsStatsFilesystems(object):
    """
    File systems statistics.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricsStatsFilesystems object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param count:
            The value to assign to the count property of this MetricsStatsFilesystems.
        :type count: float

        :param active_count:
            The value to assign to the active_count property of this MetricsStatsFilesystems.
        :type active_count: float

        """
        self.swagger_types = {
            'count': 'float',
            'active_count': 'float'
        }

        self.attribute_map = {
            'count': 'count',
            'active_count': 'activeCount'
        }

        self._count = None
        self._active_count = None

    @property
    def count(self):
        """
        Gets the count of this MetricsStatsFilesystems.
        Total number of file systems created.

        Example: `4`


        :return: The count of this MetricsStatsFilesystems.
        :rtype: float
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this MetricsStatsFilesystems.
        Total number of file systems created.

        Example: `4`


        :param count: The count of this MetricsStatsFilesystems.
        :type: float
        """
        self._count = count

    @property
    def active_count(self):
        """
        Gets the active_count of this MetricsStatsFilesystems.
        Total number of connected file systems.

        Example: `3`


        :return: The active_count of this MetricsStatsFilesystems.
        :rtype: float
        """
        return self._active_count

    @active_count.setter
    def active_count(self, active_count):
        """
        Sets the active_count of this MetricsStatsFilesystems.
        Total number of connected file systems.

        Example: `3`


        :param active_count: The active_count of this MetricsStatsFilesystems.
        :type: float
        """
        self._active_count = active_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
