# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricsStatsLog(object):
    """
    Log storage statistics.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricsStatsLog object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param util_percent:
            The value to assign to the util_percent property of this MetricsStatsLog.
        :type util_percent: float

        """
        self.swagger_types = {
            'util_percent': 'float'
        }

        self.attribute_map = {
            'util_percent': 'utilPercent'
        }

        self._util_percent = None

    @property
    def util_percent(self):
        """
        Gets the util_percent of this MetricsStatsLog.
        Log storage utilization (percent).

        Example: `65`


        :return: The util_percent of this MetricsStatsLog.
        :rtype: float
        """
        return self._util_percent

    @util_percent.setter
    def util_percent(self, util_percent):
        """
        Sets the util_percent of this MetricsStatsLog.
        Log storage utilization (percent).

        Example: `65`


        :param util_percent: The util_percent of this MetricsStatsLog.
        :type: float
        """
        self._util_percent = util_percent

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
