# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StatusReasons(object):
    """
    The reasons for the overall health status. The object can include an array of reason strings for the 'CRITICAL'
    health status and another array of reason strings for the 'WARNING' health status. The 'CRITICAL' health status
    includes both arrays if a warning also exists.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new StatusReasons object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param critical:
            The value to assign to the critical property of this StatusReasons.
        :type critical: list[str]

        :param warning:
            The value to assign to the warning property of this StatusReasons.
        :type warning: list[str]

        """
        self.swagger_types = {
            'critical': 'list[str]',
            'warning': 'list[str]'
        }

        self.attribute_map = {
            'critical': 'critical',
            'warning': 'warning'
        }

        self._critical = None
        self._warning = None

    @property
    def critical(self):
        """
        Gets the critical of this StatusReasons.
        An array of reasons for the critical status.

        Example: `Rejecting IO due to low cache space`


        :return: The critical of this StatusReasons.
        :rtype: list[str]
        """
        return self._critical

    @critical.setter
    def critical(self, critical):
        """
        Sets the critical of this StatusReasons.
        An array of reasons for the critical status.

        Example: `Rejecting IO due to low cache space`


        :param critical: The critical of this StatusReasons.
        :type: list[str]
        """
        self._critical = critical

    @property
    def warning(self):
        """
        Gets the warning of this StatusReasons.
        An array of reasons for the warning status.

        Example: `A newer version is available`


        :return: The warning of this StatusReasons.
        :rtype: list[str]
        """
        return self._warning

    @warning.setter
    def warning(self, warning):
        """
        Sets the warning of this StatusReasons.
        An array of reasons for the warning status.

        Example: `A newer version is available`


        :param warning: The warning of this StatusReasons.
        :type: list[str]
        """
        self._warning = warning

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
