# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StorageGatewayHealth(object):
    """
    Information describing the current health of the storage gateway.
    """

    #: A constant which can be used with the status property of a StorageGatewayHealth.
    #: This constant has a value of "ACTIVE"
    STATUS_ACTIVE = "ACTIVE"

    #: A constant which can be used with the status property of a StorageGatewayHealth.
    #: This constant has a value of "INACTIVE"
    STATUS_INACTIVE = "INACTIVE"

    #: A constant which can be used with the status property of a StorageGatewayHealth.
    #: This constant has a value of "WARNING"
    STATUS_WARNING = "WARNING"

    #: A constant which can be used with the status property of a StorageGatewayHealth.
    #: This constant has a value of "CRITICAL"
    STATUS_CRITICAL = "CRITICAL"

    def __init__(self, **kwargs):
        """
        Initializes a new StorageGatewayHealth object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param status:
            The value to assign to the status property of this StorageGatewayHealth.
            Allowed values for this property are: "ACTIVE", "INACTIVE", "WARNING", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param reasons:
            The value to assign to the reasons property of this StorageGatewayHealth.
        :type reasons: StatusReasons

        :param version:
            The value to assign to the version property of this StorageGatewayHealth.
        :type version: str

        :param is_newer_version_available:
            The value to assign to the is_newer_version_available property of this StorageGatewayHealth.
        :type is_newer_version_available: bool

        :param time_last_heartbeat_received:
            The value to assign to the time_last_heartbeat_received property of this StorageGatewayHealth.
        :type time_last_heartbeat_received: datetime

        :param metrics:
            The value to assign to the metrics property of this StorageGatewayHealth.
        :type metrics: Metrics

        """
        self.swagger_types = {
            'status': 'str',
            'reasons': 'StatusReasons',
            'version': 'str',
            'is_newer_version_available': 'bool',
            'time_last_heartbeat_received': 'datetime',
            'metrics': 'Metrics'
        }

        self.attribute_map = {
            'status': 'status',
            'reasons': 'reasons',
            'version': 'version',
            'is_newer_version_available': 'isNewerVersionAvailable',
            'time_last_heartbeat_received': 'timeLastHeartbeatReceived',
            'metrics': 'metrics'
        }

        self._status = None
        self._reasons = None
        self._version = None
        self._is_newer_version_available = None
        self._time_last_heartbeat_received = None
        self._metrics = None

    @property
    def status(self):
        """
        **[Required]** Gets the status of this StorageGatewayHealth.
        The overall health status of the storage gateway.

        *  ACTIVE - The storage gateway is running with no issues.
        *  INACTIVE - The storage gateway instance has not yet been installed on a Compute instance or on premises,
        or the control plane has not received recent heartbeat data.
        *  WARNING - The storage gateway has warnings. The `reasons` strings describe why this health status appears.
        *  CRITICAL - The storage gateway has critical issues. The `reasons` strings describe why this health
        status appears.

        Allowed values for this property are: "ACTIVE", "INACTIVE", "WARNING", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this StorageGatewayHealth.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this StorageGatewayHealth.
        The overall health status of the storage gateway.

        *  ACTIVE - The storage gateway is running with no issues.
        *  INACTIVE - The storage gateway instance has not yet been installed on a Compute instance or on premises,
        or the control plane has not received recent heartbeat data.
        *  WARNING - The storage gateway has warnings. The `reasons` strings describe why this health status appears.
        *  CRITICAL - The storage gateway has critical issues. The `reasons` strings describe why this health
        status appears.


        :param status: The status of this StorageGatewayHealth.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE", "WARNING", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def reasons(self):
        """
        Gets the reasons of this StorageGatewayHealth.
        Additional information about WARNING and CRITICAL health statuses.


        :return: The reasons of this StorageGatewayHealth.
        :rtype: StatusReasons
        """
        return self._reasons

    @reasons.setter
    def reasons(self, reasons):
        """
        Sets the reasons of this StorageGatewayHealth.
        Additional information about WARNING and CRITICAL health statuses.


        :param reasons: The reasons of this StorageGatewayHealth.
        :type: StatusReasons
        """
        self._reasons = reasons

    @property
    def version(self):
        """
        **[Required]** Gets the version of this StorageGatewayHealth.
        The version of the storage gateway instance.

        Example: `2.0`


        :return: The version of this StorageGatewayHealth.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this StorageGatewayHealth.
        The version of the storage gateway instance.

        Example: `2.0`


        :param version: The version of this StorageGatewayHealth.
        :type: str
        """
        self._version = version

    @property
    def is_newer_version_available(self):
        """
        **[Required]** Gets the is_newer_version_available of this StorageGatewayHealth.
        Whether a newer storage gateway version is available.

        Example: `false`


        :return: The is_newer_version_available of this StorageGatewayHealth.
        :rtype: bool
        """
        return self._is_newer_version_available

    @is_newer_version_available.setter
    def is_newer_version_available(self, is_newer_version_available):
        """
        Sets the is_newer_version_available of this StorageGatewayHealth.
        Whether a newer storage gateway version is available.

        Example: `false`


        :param is_newer_version_available: The is_newer_version_available of this StorageGatewayHealth.
        :type: bool
        """
        self._is_newer_version_available = is_newer_version_available

    @property
    def time_last_heartbeat_received(self):
        """
        **[Required]** Gets the time_last_heartbeat_received of this StorageGatewayHealth.
        A timestamp identifying when the most recent heartbeat was received, in the format defined by RFC3339.

        Example: `2019-05-17T19:55:49.263Z`


        :return: The time_last_heartbeat_received of this StorageGatewayHealth.
        :rtype: datetime
        """
        return self._time_last_heartbeat_received

    @time_last_heartbeat_received.setter
    def time_last_heartbeat_received(self, time_last_heartbeat_received):
        """
        Sets the time_last_heartbeat_received of this StorageGatewayHealth.
        A timestamp identifying when the most recent heartbeat was received, in the format defined by RFC3339.

        Example: `2019-05-17T19:55:49.263Z`


        :param time_last_heartbeat_received: The time_last_heartbeat_received of this StorageGatewayHealth.
        :type: datetime
        """
        self._time_last_heartbeat_received = time_last_heartbeat_received

    @property
    def metrics(self):
        """
        **[Required]** Gets the metrics of this StorageGatewayHealth.
        Metrics data about the specified storage gateway.


        :return: The metrics of this StorageGatewayHealth.
        :rtype: Metrics
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """
        Sets the metrics of this StorageGatewayHealth.
        Metrics data about the specified storage gateway.


        :param metrics: The metrics of this StorageGatewayHealth.
        :type: Metrics
        """
        self._metrics = metrics

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
