# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StorageGatewaySummary(object):
    """
    Summary view of the specified storage gateway.
    """

    #: A constant which can be used with the status property of a StorageGatewaySummary.
    #: This constant has a value of "ACTIVE"
    STATUS_ACTIVE = "ACTIVE"

    #: A constant which can be used with the status property of a StorageGatewaySummary.
    #: This constant has a value of "INACTIVE"
    STATUS_INACTIVE = "INACTIVE"

    #: A constant which can be used with the status property of a StorageGatewaySummary.
    #: This constant has a value of "WARNING"
    STATUS_WARNING = "WARNING"

    #: A constant which can be used with the status property of a StorageGatewaySummary.
    #: This constant has a value of "CRITICAL"
    STATUS_CRITICAL = "CRITICAL"

    #: A constant which can be used with the lifecycle_state property of a StorageGatewaySummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a StorageGatewaySummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a StorageGatewaySummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a StorageGatewaySummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a StorageGatewaySummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new StorageGatewaySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this StorageGatewaySummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this StorageGatewaySummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this StorageGatewaySummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this StorageGatewaySummary.
        :type description: str

        :param status:
            The value to assign to the status property of this StorageGatewaySummary.
            Allowed values for this property are: "ACTIVE", "INACTIVE", "WARNING", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param version:
            The value to assign to the version property of this StorageGatewaySummary.
        :type version: str

        :param is_newer_version_available:
            The value to assign to the is_newer_version_available property of this StorageGatewaySummary.
        :type is_newer_version_available: bool

        :param time_created:
            The value to assign to the time_created property of this StorageGatewaySummary.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this StorageGatewaySummary.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this StorageGatewaySummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this StorageGatewaySummary.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'status': 'str',
            'version': 'str',
            'is_newer_version_available': 'bool',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'status': 'status',
            'version': 'version',
            'is_newer_version_available': 'isNewerVersionAvailable',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._status = None
        self._version = None
        self._is_newer_version_available = None
        self._time_created = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this StorageGatewaySummary.
        The `OCID`__ of the storage gateway.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this StorageGatewaySummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this StorageGatewaySummary.
        The `OCID`__ of the storage gateway.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this StorageGatewaySummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this StorageGatewaySummary.
        The `OCID`__ of the compartment containing the storage gateway.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this StorageGatewaySummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this StorageGatewaySummary.
        The `OCID`__ of the compartment containing the storage gateway.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this StorageGatewaySummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this StorageGatewaySummary.
        The user-friendly name of the storage gateway. It does not have to be unique, and it is changeable.

        Example: `example_storage_gateway`


        :return: The display_name of this StorageGatewaySummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this StorageGatewaySummary.
        The user-friendly name of the storage gateway. It does not have to be unique, and it is changeable.

        Example: `example_storage_gateway`


        :param display_name: The display_name of this StorageGatewaySummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this StorageGatewaySummary.
        The changeable description assigned to the storage gateway during creation. It does not have to be unique.

         Example: `my first storage gateway`


        :return: The description of this StorageGatewaySummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this StorageGatewaySummary.
        The changeable description assigned to the storage gateway during creation. It does not have to be unique.

         Example: `my first storage gateway`


        :param description: The description of this StorageGatewaySummary.
        :type: str
        """
        self._description = description

    @property
    def status(self):
        """
        **[Required]** Gets the status of this StorageGatewaySummary.
        The overall health status of the storage gateway.

        *  ACTIVE - The storage gateway is running with no issues.
        *  INACTIVE - The storage gateway instance has not yet been installed on a Compute instance or on premises,
        or the control plane has not received recent heartbeat data.
        *  WARNING - The storage gateway has warnings.
        *  CRITICAL - The storage gateway has critical issues.

        Allowed values for this property are: "ACTIVE", "INACTIVE", "WARNING", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this StorageGatewaySummary.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this StorageGatewaySummary.
        The overall health status of the storage gateway.

        *  ACTIVE - The storage gateway is running with no issues.
        *  INACTIVE - The storage gateway instance has not yet been installed on a Compute instance or on premises,
        or the control plane has not received recent heartbeat data.
        *  WARNING - The storage gateway has warnings.
        *  CRITICAL - The storage gateway has critical issues.


        :param status: The status of this StorageGatewaySummary.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE", "WARNING", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def version(self):
        """
        **[Required]** Gets the version of this StorageGatewaySummary.
        The version of the storage gateway instance.

        Example: `2.0`


        :return: The version of this StorageGatewaySummary.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this StorageGatewaySummary.
        The version of the storage gateway instance.

        Example: `2.0`


        :param version: The version of this StorageGatewaySummary.
        :type: str
        """
        self._version = version

    @property
    def is_newer_version_available(self):
        """
        **[Required]** Gets the is_newer_version_available of this StorageGatewaySummary.
        Whether a newer storage gateway version is available.

        Example: `false`


        :return: The is_newer_version_available of this StorageGatewaySummary.
        :rtype: bool
        """
        return self._is_newer_version_available

    @is_newer_version_available.setter
    def is_newer_version_available(self, is_newer_version_available):
        """
        Sets the is_newer_version_available of this StorageGatewaySummary.
        Whether a newer storage gateway version is available.

        Example: `false`


        :param is_newer_version_available: The is_newer_version_available of this StorageGatewaySummary.
        :type: bool
        """
        self._is_newer_version_available = is_newer_version_available

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this StorageGatewaySummary.
        The date and time the storage gateway was created, in the format defined by RFC3339.

        Example: `2019-05-16T21:52:40.793Z`


        :return: The time_created of this StorageGatewaySummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this StorageGatewaySummary.
        The date and time the storage gateway was created, in the format defined by RFC3339.

        Example: `2019-05-16T21:52:40.793Z`


        :param time_created: The time_created of this StorageGatewaySummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this StorageGatewaySummary.
        The current lifecycle state of the storage gateway. You cannot use the storage gateway before the state is ACTIVE.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this StorageGatewaySummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this StorageGatewaySummary.
        The current lifecycle state of the storage gateway. You cannot use the storage gateway before the state is ACTIVE.


        :param lifecycle_state: The lifecycle_state of this StorageGatewaySummary.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this StorageGatewaySummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information,
        see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this StorageGatewaySummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this StorageGatewaySummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information,
        see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this StorageGatewaySummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this StorageGatewaySummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this StorageGatewaySummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this StorageGatewaySummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this StorageGatewaySummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
