# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateFileSystemDetails(object):
    """
    Configuration details for updating a storage gateway file system.

    **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateFileSystemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this UpdateFileSystemDetails.
        :type description: str

        :param nfs_allowed_hosts:
            The value to assign to the nfs_allowed_hosts property of this UpdateFileSystemDetails.
        :type nfs_allowed_hosts: str

        :param nfs_export_options:
            The value to assign to the nfs_export_options property of this UpdateFileSystemDetails.
        :type nfs_export_options: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateFileSystemDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateFileSystemDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'description': 'str',
            'nfs_allowed_hosts': 'str',
            'nfs_export_options': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'description': 'description',
            'nfs_allowed_hosts': 'nfsAllowedHosts',
            'nfs_export_options': 'nfsExportOptions',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._description = None
        self._nfs_allowed_hosts = None
        self._nfs_export_options = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def description(self):
        """
        Gets the description of this UpdateFileSystemDetails.
        A description of the file system. It does not have to be unique, and it can be changed.

        Example: `my first storage gateway file system`


        :return: The description of this UpdateFileSystemDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateFileSystemDetails.
        A description of the file system. It does not have to be unique, and it can be changed.

        Example: `my first storage gateway file system`


        :param description: The description of this UpdateFileSystemDetails.
        :type: str
        """
        self._description = description

    @property
    def nfs_allowed_hosts(self):
        """
        Gets the nfs_allowed_hosts of this UpdateFileSystemDetails.
        A list of hosts allowed to connect to the NFS export. The list is comma-separated and whitespace is optional.
        Specify `*` to allow all hosts to connect.

        Example: `2001:db8:9:e54::/64, 192.168.2.0/24`


        :return: The nfs_allowed_hosts of this UpdateFileSystemDetails.
        :rtype: str
        """
        return self._nfs_allowed_hosts

    @nfs_allowed_hosts.setter
    def nfs_allowed_hosts(self, nfs_allowed_hosts):
        """
        Sets the nfs_allowed_hosts of this UpdateFileSystemDetails.
        A list of hosts allowed to connect to the NFS export. The list is comma-separated and whitespace is optional.
        Specify `*` to allow all hosts to connect.

        Example: `2001:db8:9:e54::/64, 192.168.2.0/24`


        :param nfs_allowed_hosts: The nfs_allowed_hosts of this UpdateFileSystemDetails.
        :type: str
        """
        self._nfs_allowed_hosts = nfs_allowed_hosts

    @property
    def nfs_export_options(self):
        """
        Gets the nfs_export_options of this UpdateFileSystemDetails.
        The NFS export options.

        Do not specify the `fsid` option.

        Example: `rw, sync, insecure, no_subtree_check, no_root_squash`


        :return: The nfs_export_options of this UpdateFileSystemDetails.
        :rtype: str
        """
        return self._nfs_export_options

    @nfs_export_options.setter
    def nfs_export_options(self, nfs_export_options):
        """
        Sets the nfs_export_options of this UpdateFileSystemDetails.
        The NFS export options.

        Do not specify the `fsid` option.

        Example: `rw, sync, insecure, no_subtree_check, no_root_squash`


        :param nfs_export_options: The nfs_export_options of this UpdateFileSystemDetails.
        :type: str
        """
        self._nfs_export_options = nfs_export_options

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateFileSystemDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information,
        see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateFileSystemDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateFileSystemDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information,
        see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateFileSystemDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateFileSystemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateFileSystemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateFileSystemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateFileSystemDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
