# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from __future__ import absolute_import

from .archiver import Archiver
from .archiver_error import ArchiverError
from .change_connect_harness_compartment_details import ChangeConnectHarnessCompartmentDetails
from .change_stream_compartment_details import ChangeStreamCompartmentDetails
from .connect_harness import ConnectHarness
from .connect_harness_summary import ConnectHarnessSummary
from .create_archiver_details import CreateArchiverDetails
from .create_connect_harness_details import CreateConnectHarnessDetails
from .create_cursor_details import CreateCursorDetails
from .create_group_cursor_details import CreateGroupCursorDetails
from .create_stream_details import CreateStreamDetails
from .cursor import Cursor
from .default_stream_pool import DefaultStreamPool
from .default_stream_pool_summary import DefaultStreamPoolSummary
from .group import Group
from .kafka_connection_settings import KafkaConnectionSettings
from .message import Message
from .partition_reservation import PartitionReservation
from .put_messages_details import PutMessagesDetails
from .put_messages_details_entry import PutMessagesDetailsEntry
from .put_messages_result import PutMessagesResult
from .put_messages_result_entry import PutMessagesResultEntry
from .stream import Stream
from .stream_summary import StreamSummary
from .update_archiver_details import UpdateArchiverDetails
from .update_connect_harness_details import UpdateConnectHarnessDetails
from .update_default_stream_pool_details import UpdateDefaultStreamPoolDetails
from .update_group_details import UpdateGroupDetails
from .update_stream_details import UpdateStreamDetails

# Maps type names to classes for streaming services.
streaming_type_mapping = {
    "Archiver": Archiver,
    "ArchiverError": ArchiverError,
    "ChangeConnectHarnessCompartmentDetails": ChangeConnectHarnessCompartmentDetails,
    "ChangeStreamCompartmentDetails": ChangeStreamCompartmentDetails,
    "ConnectHarness": ConnectHarness,
    "ConnectHarnessSummary": ConnectHarnessSummary,
    "CreateArchiverDetails": CreateArchiverDetails,
    "CreateConnectHarnessDetails": CreateConnectHarnessDetails,
    "CreateCursorDetails": CreateCursorDetails,
    "CreateGroupCursorDetails": CreateGroupCursorDetails,
    "CreateStreamDetails": CreateStreamDetails,
    "Cursor": Cursor,
    "DefaultStreamPool": DefaultStreamPool,
    "DefaultStreamPoolSummary": DefaultStreamPoolSummary,
    "Group": Group,
    "KafkaConnectionSettings": KafkaConnectionSettings,
    "Message": Message,
    "PartitionReservation": PartitionReservation,
    "PutMessagesDetails": PutMessagesDetails,
    "PutMessagesDetailsEntry": PutMessagesDetailsEntry,
    "PutMessagesResult": PutMessagesResult,
    "PutMessagesResultEntry": PutMessagesResultEntry,
    "Stream": Stream,
    "StreamSummary": StreamSummary,
    "UpdateArchiverDetails": UpdateArchiverDetails,
    "UpdateConnectHarnessDetails": UpdateConnectHarnessDetails,
    "UpdateDefaultStreamPoolDetails": UpdateDefaultStreamPoolDetails,
    "UpdateGroupDetails": UpdateGroupDetails,
    "UpdateStreamDetails": UpdateStreamDetails
}
