# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DefaultStreamPool(object):
    """
    The default stream pool for a compartment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DefaultStreamPool object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DefaultStreamPool.
        :type id: str

        :param kafka_handle:
            The value to assign to the kafka_handle property of this DefaultStreamPool.
        :type kafka_handle: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DefaultStreamPool.
        :type compartment_id: str

        :param kafka_auto_create_topics_enable:
            The value to assign to the kafka_auto_create_topics_enable property of this DefaultStreamPool.
        :type kafka_auto_create_topics_enable: bool

        :param kafka_log_retention_hours:
            The value to assign to the kafka_log_retention_hours property of this DefaultStreamPool.
        :type kafka_log_retention_hours: int

        :param kafka_num_partitions:
            The value to assign to the kafka_num_partitions property of this DefaultStreamPool.
        :type kafka_num_partitions: int

        :param kafka_connection_settings:
            The value to assign to the kafka_connection_settings property of this DefaultStreamPool.
        :type kafka_connection_settings: KafkaConnectionSettings

        """
        self.swagger_types = {
            'id': 'str',
            'kafka_handle': 'str',
            'compartment_id': 'str',
            'kafka_auto_create_topics_enable': 'bool',
            'kafka_log_retention_hours': 'int',
            'kafka_num_partitions': 'int',
            'kafka_connection_settings': 'KafkaConnectionSettings'
        }

        self.attribute_map = {
            'id': 'id',
            'kafka_handle': 'kafkaHandle',
            'compartment_id': 'compartmentId',
            'kafka_auto_create_topics_enable': 'kafkaAutoCreateTopicsEnable',
            'kafka_log_retention_hours': 'kafkaLogRetentionHours',
            'kafka_num_partitions': 'kafkaNumPartitions',
            'kafka_connection_settings': 'kafkaConnectionSettings'
        }

        self._id = None
        self._kafka_handle = None
        self._compartment_id = None
        self._kafka_auto_create_topics_enable = None
        self._kafka_log_retention_hours = None
        self._kafka_num_partitions = None
        self._kafka_connection_settings = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DefaultStreamPool.
        The OCID of the default stream pool.


        :return: The id of this DefaultStreamPool.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DefaultStreamPool.
        The OCID of the default stream pool.


        :param id: The id of this DefaultStreamPool.
        :type: str
        """
        self._id = id

    @property
    def kafka_handle(self):
        """
        **[Required]** Gets the kafka_handle of this DefaultStreamPool.
        The handle used in the kafka compatibility username.


        :return: The kafka_handle of this DefaultStreamPool.
        :rtype: str
        """
        return self._kafka_handle

    @kafka_handle.setter
    def kafka_handle(self, kafka_handle):
        """
        Sets the kafka_handle of this DefaultStreamPool.
        The handle used in the kafka compatibility username.


        :param kafka_handle: The kafka_handle of this DefaultStreamPool.
        :type: str
        """
        self._kafka_handle = kafka_handle

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DefaultStreamPool.
        Compartment OCID that the pool belongs to.


        :return: The compartment_id of this DefaultStreamPool.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DefaultStreamPool.
        Compartment OCID that the pool belongs to.


        :param compartment_id: The compartment_id of this DefaultStreamPool.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def kafka_auto_create_topics_enable(self):
        """
        **[Required]** Gets the kafka_auto_create_topics_enable of this DefaultStreamPool.
        Enable auto creation of topic on the server.


        :return: The kafka_auto_create_topics_enable of this DefaultStreamPool.
        :rtype: bool
        """
        return self._kafka_auto_create_topics_enable

    @kafka_auto_create_topics_enable.setter
    def kafka_auto_create_topics_enable(self, kafka_auto_create_topics_enable):
        """
        Sets the kafka_auto_create_topics_enable of this DefaultStreamPool.
        Enable auto creation of topic on the server.


        :param kafka_auto_create_topics_enable: The kafka_auto_create_topics_enable of this DefaultStreamPool.
        :type: bool
        """
        self._kafka_auto_create_topics_enable = kafka_auto_create_topics_enable

    @property
    def kafka_log_retention_hours(self):
        """
        **[Required]** Gets the kafka_log_retention_hours of this DefaultStreamPool.
        The number of hours to keep a log file before deleting it (in hours).


        :return: The kafka_log_retention_hours of this DefaultStreamPool.
        :rtype: int
        """
        return self._kafka_log_retention_hours

    @kafka_log_retention_hours.setter
    def kafka_log_retention_hours(self, kafka_log_retention_hours):
        """
        Sets the kafka_log_retention_hours of this DefaultStreamPool.
        The number of hours to keep a log file before deleting it (in hours).


        :param kafka_log_retention_hours: The kafka_log_retention_hours of this DefaultStreamPool.
        :type: int
        """
        self._kafka_log_retention_hours = kafka_log_retention_hours

    @property
    def kafka_num_partitions(self):
        """
        **[Required]** Gets the kafka_num_partitions of this DefaultStreamPool.
        The default number of log partitions per topic.


        :return: The kafka_num_partitions of this DefaultStreamPool.
        :rtype: int
        """
        return self._kafka_num_partitions

    @kafka_num_partitions.setter
    def kafka_num_partitions(self, kafka_num_partitions):
        """
        Sets the kafka_num_partitions of this DefaultStreamPool.
        The default number of log partitions per topic.


        :param kafka_num_partitions: The kafka_num_partitions of this DefaultStreamPool.
        :type: int
        """
        self._kafka_num_partitions = kafka_num_partitions

    @property
    def kafka_connection_settings(self):
        """
        Gets the kafka_connection_settings of this DefaultStreamPool.

        :return: The kafka_connection_settings of this DefaultStreamPool.
        :rtype: KafkaConnectionSettings
        """
        return self._kafka_connection_settings

    @kafka_connection_settings.setter
    def kafka_connection_settings(self, kafka_connection_settings):
        """
        Sets the kafka_connection_settings of this DefaultStreamPool.

        :param kafka_connection_settings: The kafka_connection_settings of this DefaultStreamPool.
        :type: KafkaConnectionSettings
        """
        self._kafka_connection_settings = kafka_connection_settings

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
