# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KafkaConnectionSettings(object):
    """
    Connection settings to use Kafka compat API.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new KafkaConnectionSettings object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param admin_bootstrap_servers:
            The value to assign to the admin_bootstrap_servers property of this KafkaConnectionSettings.
        :type admin_bootstrap_servers: str

        :param bootstrap_servers:
            The value to assign to the bootstrap_servers property of this KafkaConnectionSettings.
        :type bootstrap_servers: str

        """
        self.swagger_types = {
            'admin_bootstrap_servers': 'str',
            'bootstrap_servers': 'str'
        }

        self.attribute_map = {
            'admin_bootstrap_servers': 'adminBootstrapServers',
            'bootstrap_servers': 'bootstrapServers'
        }

        self._admin_bootstrap_servers = None
        self._bootstrap_servers = None

    @property
    def admin_bootstrap_servers(self):
        """
        Gets the admin_bootstrap_servers of this KafkaConnectionSettings.
        Admin bootstrap servers.


        :return: The admin_bootstrap_servers of this KafkaConnectionSettings.
        :rtype: str
        """
        return self._admin_bootstrap_servers

    @admin_bootstrap_servers.setter
    def admin_bootstrap_servers(self, admin_bootstrap_servers):
        """
        Sets the admin_bootstrap_servers of this KafkaConnectionSettings.
        Admin bootstrap servers.


        :param admin_bootstrap_servers: The admin_bootstrap_servers of this KafkaConnectionSettings.
        :type: str
        """
        self._admin_bootstrap_servers = admin_bootstrap_servers

    @property
    def bootstrap_servers(self):
        """
        Gets the bootstrap_servers of this KafkaConnectionSettings.
        Bootstrap servers.


        :return: The bootstrap_servers of this KafkaConnectionSettings.
        :rtype: str
        """
        return self._bootstrap_servers

    @bootstrap_servers.setter
    def bootstrap_servers(self, bootstrap_servers):
        """
        Sets the bootstrap_servers of this KafkaConnectionSettings.
        Bootstrap servers.


        :param bootstrap_servers: The bootstrap_servers of this KafkaConnectionSettings.
        :type: str
        """
        self._bootstrap_servers = bootstrap_servers

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
