# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateDefaultStreamPoolDetails(object):
    """
    Object used to update the default stream pool's details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateDefaultStreamPoolDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kafka_auto_create_topics_enable:
            The value to assign to the kafka_auto_create_topics_enable property of this UpdateDefaultStreamPoolDetails.
        :type kafka_auto_create_topics_enable: bool

        :param kafka_log_retention_hours:
            The value to assign to the kafka_log_retention_hours property of this UpdateDefaultStreamPoolDetails.
        :type kafka_log_retention_hours: int

        :param kafka_num_partitions:
            The value to assign to the kafka_num_partitions property of this UpdateDefaultStreamPoolDetails.
        :type kafka_num_partitions: int

        """
        self.swagger_types = {
            'kafka_auto_create_topics_enable': 'bool',
            'kafka_log_retention_hours': 'int',
            'kafka_num_partitions': 'int'
        }

        self.attribute_map = {
            'kafka_auto_create_topics_enable': 'kafkaAutoCreateTopicsEnable',
            'kafka_log_retention_hours': 'kafkaLogRetentionHours',
            'kafka_num_partitions': 'kafkaNumPartitions'
        }

        self._kafka_auto_create_topics_enable = None
        self._kafka_log_retention_hours = None
        self._kafka_num_partitions = None

    @property
    def kafka_auto_create_topics_enable(self):
        """
        Gets the kafka_auto_create_topics_enable of this UpdateDefaultStreamPoolDetails.
        Enable auto creation of topic on the server


        :return: The kafka_auto_create_topics_enable of this UpdateDefaultStreamPoolDetails.
        :rtype: bool
        """
        return self._kafka_auto_create_topics_enable

    @kafka_auto_create_topics_enable.setter
    def kafka_auto_create_topics_enable(self, kafka_auto_create_topics_enable):
        """
        Sets the kafka_auto_create_topics_enable of this UpdateDefaultStreamPoolDetails.
        Enable auto creation of topic on the server


        :param kafka_auto_create_topics_enable: The kafka_auto_create_topics_enable of this UpdateDefaultStreamPoolDetails.
        :type: bool
        """
        self._kafka_auto_create_topics_enable = kafka_auto_create_topics_enable

    @property
    def kafka_log_retention_hours(self):
        """
        Gets the kafka_log_retention_hours of this UpdateDefaultStreamPoolDetails.
        The number of hours to keep a log file before deleting it (in hours)


        :return: The kafka_log_retention_hours of this UpdateDefaultStreamPoolDetails.
        :rtype: int
        """
        return self._kafka_log_retention_hours

    @kafka_log_retention_hours.setter
    def kafka_log_retention_hours(self, kafka_log_retention_hours):
        """
        Sets the kafka_log_retention_hours of this UpdateDefaultStreamPoolDetails.
        The number of hours to keep a log file before deleting it (in hours)


        :param kafka_log_retention_hours: The kafka_log_retention_hours of this UpdateDefaultStreamPoolDetails.
        :type: int
        """
        self._kafka_log_retention_hours = kafka_log_retention_hours

    @property
    def kafka_num_partitions(self):
        """
        Gets the kafka_num_partitions of this UpdateDefaultStreamPoolDetails.
        The default number of log partitions per topic


        :return: The kafka_num_partitions of this UpdateDefaultStreamPoolDetails.
        :rtype: int
        """
        return self._kafka_num_partitions

    @kafka_num_partitions.setter
    def kafka_num_partitions(self, kafka_num_partitions):
        """
        Sets the kafka_num_partitions of this UpdateDefaultStreamPoolDetails.
        The default number of log partitions per topic


        :param kafka_num_partitions: The kafka_num_partitions of this UpdateDefaultStreamPoolDetails.
        :type: int
        """
        self._kafka_num_partitions = kafka_num_partitions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
