# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CostRecord(object):
    """
    Object describing the cost and the usage for a specific resource type within the defined time interval.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CostRecord object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compute_type:
            The value to assign to the compute_type property of this CostRecord.
        :type compute_type: str

        :param computed_quantity:
            The value to assign to the computed_quantity property of this CostRecord.
        :type computed_quantity: float

        :param computed_amount:
            The value to assign to the computed_amount property of this CostRecord.
        :type computed_amount: float

        :param unit_price:
            The value to assign to the unit_price property of this CostRecord.
        :type unit_price: float

        """
        self.swagger_types = {
            'compute_type': 'str',
            'computed_quantity': 'float',
            'computed_amount': 'float',
            'unit_price': 'float'
        }

        self.attribute_map = {
            'compute_type': 'computeType',
            'computed_quantity': 'computedQuantity',
            'computed_amount': 'computedAmount',
            'unit_price': 'unitPrice'
        }

        self._compute_type = None
        self._computed_quantity = None
        self._computed_amount = None
        self._unit_price = None

    @property
    def compute_type(self):
        """
        Gets the compute_type of this CostRecord.
        The type of cost. Note that this property is not available for filtered queries (by compartmentId or cost tracking tag).


        :return: The compute_type of this CostRecord.
        :rtype: str
        """
        return self._compute_type

    @compute_type.setter
    def compute_type(self, compute_type):
        """
        Sets the compute_type of this CostRecord.
        The type of cost. Note that this property is not available for filtered queries (by compartmentId or cost tracking tag).


        :param compute_type: The compute_type of this CostRecord.
        :type: str
        """
        self._compute_type = compute_type

    @property
    def computed_quantity(self):
        """
        Gets the computed_quantity of this CostRecord.
        The amount of usage of the target resource (measured in {displayUnitName} units).


        :return: The computed_quantity of this CostRecord.
        :rtype: float
        """
        return self._computed_quantity

    @computed_quantity.setter
    def computed_quantity(self, computed_quantity):
        """
        Sets the computed_quantity of this CostRecord.
        The amount of usage of the target resource (measured in {displayUnitName} units).


        :param computed_quantity: The computed_quantity of this CostRecord.
        :type: float
        """
        self._computed_quantity = computed_quantity

    @property
    def computed_amount(self):
        """
        Gets the computed_amount of this CostRecord.
        The cost of the target resource (measured in {currency} currency).


        :return: The computed_amount of this CostRecord.
        :rtype: float
        """
        return self._computed_amount

    @computed_amount.setter
    def computed_amount(self, computed_amount):
        """
        Sets the computed_amount of this CostRecord.
        The cost of the target resource (measured in {currency} currency).


        :param computed_amount: The computed_amount of this CostRecord.
        :type: float
        """
        self._computed_amount = computed_amount

    @property
    def unit_price(self):
        """
        Gets the unit_price of this CostRecord.
        The unit price. Note that this property is not available for filtered queries (by compartmentId or cost tracking tag).


        :return: The unit_price of this CostRecord.
        :rtype: float
        """
        return self._unit_price

    @unit_price.setter
    def unit_price(self, unit_price):
        """
        Sets the unit_price of this CostRecord.
        The unit price. Note that this property is not available for filtered queries (by compartmentId or cost tracking tag).


        :param unit_price: The unit_price of this CostRecord.
        :type: float
        """
        self._unit_price = unit_price

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
