# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SubscriptionInfo(object):
    """
    The response object for the GetSubscriptionInfo API call. It provides information about the specified billing cycle.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SubscriptionInfo object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tenancy_id:
            The value to assign to the tenancy_id property of this SubscriptionInfo.
        :type tenancy_id: str

        :param bill_start:
            The value to assign to the bill_start property of this SubscriptionInfo.
        :type bill_start: datetime

        :param bill_end:
            The value to assign to the bill_end property of this SubscriptionInfo.
        :type bill_end: datetime

        :param bill_total_balance:
            The value to assign to the bill_total_balance property of this SubscriptionInfo.
        :type bill_total_balance: float

        :param bill_total_purchased:
            The value to assign to the bill_total_purchased property of this SubscriptionInfo.
        :type bill_total_purchased: float

        :param bill_modified_time:
            The value to assign to the bill_modified_time property of this SubscriptionInfo.
        :type bill_modified_time: datetime

        :param bill_currency:
            The value to assign to the bill_currency property of this SubscriptionInfo.
        :type bill_currency: str

        """
        self.swagger_types = {
            'tenancy_id': 'str',
            'bill_start': 'datetime',
            'bill_end': 'datetime',
            'bill_total_balance': 'float',
            'bill_total_purchased': 'float',
            'bill_modified_time': 'datetime',
            'bill_currency': 'str'
        }

        self.attribute_map = {
            'tenancy_id': 'tenancyId',
            'bill_start': 'billStart',
            'bill_end': 'billEnd',
            'bill_total_balance': 'billTotalBalance',
            'bill_total_purchased': 'billTotalPurchased',
            'bill_modified_time': 'billModifiedTime',
            'bill_currency': 'billCurrency'
        }

        self._tenancy_id = None
        self._bill_start = None
        self._bill_end = None
        self._bill_total_balance = None
        self._bill_total_purchased = None
        self._bill_modified_time = None
        self._bill_currency = None

    @property
    def tenancy_id(self):
        """
        Gets the tenancy_id of this SubscriptionInfo.
        The OCID of the target tenancy.


        :return: The tenancy_id of this SubscriptionInfo.
        :rtype: str
        """
        return self._tenancy_id

    @tenancy_id.setter
    def tenancy_id(self, tenancy_id):
        """
        Sets the tenancy_id of this SubscriptionInfo.
        The OCID of the target tenancy.


        :param tenancy_id: The tenancy_id of this SubscriptionInfo.
        :type: str
        """
        self._tenancy_id = tenancy_id

    @property
    def bill_start(self):
        """
        Gets the bill_start of this SubscriptionInfo.
        The billing cycle start date (UTC), in the format specified by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The bill_start of this SubscriptionInfo.
        :rtype: datetime
        """
        return self._bill_start

    @bill_start.setter
    def bill_start(self, bill_start):
        """
        Sets the bill_start of this SubscriptionInfo.
        The billing cycle start date (UTC), in the format specified by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param bill_start: The bill_start of this SubscriptionInfo.
        :type: datetime
        """
        self._bill_start = bill_start

    @property
    def bill_end(self):
        """
        Gets the bill_end of this SubscriptionInfo.
        The billing cycle end date (UTC), in the format specified by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The bill_end of this SubscriptionInfo.
        :rtype: datetime
        """
        return self._bill_end

    @bill_end.setter
    def bill_end(self, bill_end):
        """
        Sets the bill_end of this SubscriptionInfo.
        The billing cycle end date (UTC), in the format specified by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param bill_end: The bill_end of this SubscriptionInfo.
        :type: datetime
        """
        self._bill_end = bill_end

    @property
    def bill_total_balance(self):
        """
        Gets the bill_total_balance of this SubscriptionInfo.
        Total balance for the billing cycle.


        :return: The bill_total_balance of this SubscriptionInfo.
        :rtype: float
        """
        return self._bill_total_balance

    @bill_total_balance.setter
    def bill_total_balance(self, bill_total_balance):
        """
        Sets the bill_total_balance of this SubscriptionInfo.
        Total balance for the billing cycle.


        :param bill_total_balance: The bill_total_balance of this SubscriptionInfo.
        :type: float
        """
        self._bill_total_balance = bill_total_balance

    @property
    def bill_total_purchased(self):
        """
        Gets the bill_total_purchased of this SubscriptionInfo.
        Total available credit for the billing cycle.


        :return: The bill_total_purchased of this SubscriptionInfo.
        :rtype: float
        """
        return self._bill_total_purchased

    @bill_total_purchased.setter
    def bill_total_purchased(self, bill_total_purchased):
        """
        Sets the bill_total_purchased of this SubscriptionInfo.
        Total available credit for the billing cycle.


        :param bill_total_purchased: The bill_total_purchased of this SubscriptionInfo.
        :type: float
        """
        self._bill_total_purchased = bill_total_purchased

    @property
    def bill_modified_time(self):
        """
        Gets the bill_modified_time of this SubscriptionInfo.
        Date and time (UTC) the balance was last modified.


        :return: The bill_modified_time of this SubscriptionInfo.
        :rtype: datetime
        """
        return self._bill_modified_time

    @bill_modified_time.setter
    def bill_modified_time(self, bill_modified_time):
        """
        Sets the bill_modified_time of this SubscriptionInfo.
        Date and time (UTC) the balance was last modified.


        :param bill_modified_time: The bill_modified_time of this SubscriptionInfo.
        :type: datetime
        """
        self._bill_modified_time = bill_modified_time

    @property
    def bill_currency(self):
        """
        Gets the bill_currency of this SubscriptionInfo.
        The currency of the subscription, in the format specified by `ISO-4217`__.

        __ https://www.iso.org/iso-4217-currency-codes.html


        :return: The bill_currency of this SubscriptionInfo.
        :rtype: str
        """
        return self._bill_currency

    @bill_currency.setter
    def bill_currency(self, bill_currency):
        """
        Sets the bill_currency of this SubscriptionInfo.
        The currency of the subscription, in the format specified by `ISO-4217`__.

        __ https://www.iso.org/iso-4217-currency-codes.html


        :param bill_currency: The bill_currency of this SubscriptionInfo.
        :type: str
        """
        self._bill_currency = bill_currency

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
