# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UsageRecord(object):
    """
    A record of a specific range of usage, including cost for the specified resource type for the specified time interval.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UsageRecord object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param start_time:
            The value to assign to the start_time property of this UsageRecord.
        :type start_time: datetime

        :param end_time:
            The value to assign to the end_time property of this UsageRecord.
        :type end_time: datetime

        :param internal_resource_name:
            The value to assign to the internal_resource_name property of this UsageRecord.
        :type internal_resource_name: str

        :param display_resource_name:
            The value to assign to the display_resource_name property of this UsageRecord.
        :type display_resource_name: str

        :param display_unit_name:
            The value to assign to the display_unit_name property of this UsageRecord.
        :type display_unit_name: str

        :param service_name:
            The value to assign to the service_name property of this UsageRecord.
        :type service_name: str

        :param currency:
            The value to assign to the currency property of this UsageRecord.
        :type currency: str

        :param gsi_product_id:
            The value to assign to the gsi_product_id property of this UsageRecord.
        :type gsi_product_id: str

        :param costs:
            The value to assign to the costs property of this UsageRecord.
        :type costs: list[CostRecord]

        """
        self.swagger_types = {
            'start_time': 'datetime',
            'end_time': 'datetime',
            'internal_resource_name': 'str',
            'display_resource_name': 'str',
            'display_unit_name': 'str',
            'service_name': 'str',
            'currency': 'str',
            'gsi_product_id': 'str',
            'costs': 'list[CostRecord]'
        }

        self.attribute_map = {
            'start_time': 'startTime',
            'end_time': 'endTime',
            'internal_resource_name': 'internalResourceName',
            'display_resource_name': 'displayResourceName',
            'display_unit_name': 'displayUnitName',
            'service_name': 'serviceName',
            'currency': 'currency',
            'gsi_product_id': 'gsiProductId',
            'costs': 'costs'
        }

        self._start_time = None
        self._end_time = None
        self._internal_resource_name = None
        self._display_resource_name = None
        self._display_unit_name = None
        self._service_name = None
        self._currency = None
        self._gsi_product_id = None
        self._costs = None

    @property
    def start_time(self):
        """
        Gets the start_time of this UsageRecord.
        The start time (UTC) of the interval for which this usage record belongs (inclusive).


        :return: The start_time of this UsageRecord.
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """
        Sets the start_time of this UsageRecord.
        The start time (UTC) of the interval for which this usage record belongs (inclusive).


        :param start_time: The start_time of this UsageRecord.
        :type: datetime
        """
        self._start_time = start_time

    @property
    def end_time(self):
        """
        Gets the end_time of this UsageRecord.
        The end time (UTC) of the interval for which this usage record belongs (exclusive).


        :return: The end_time of this UsageRecord.
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """
        Sets the end_time of this UsageRecord.
        The end time (UTC) of the interval for which this usage record belongs (exclusive).


        :param end_time: The end_time of this UsageRecord.
        :type: datetime
        """
        self._end_time = end_time

    @property
    def internal_resource_name(self):
        """
        Gets the internal_resource_name of this UsageRecord.
        The name of the internal resource type.


        :return: The internal_resource_name of this UsageRecord.
        :rtype: str
        """
        return self._internal_resource_name

    @internal_resource_name.setter
    def internal_resource_name(self, internal_resource_name):
        """
        Sets the internal_resource_name of this UsageRecord.
        The name of the internal resource type.


        :param internal_resource_name: The internal_resource_name of this UsageRecord.
        :type: str
        """
        self._internal_resource_name = internal_resource_name

    @property
    def display_resource_name(self):
        """
        Gets the display_resource_name of this UsageRecord.
        The human-readable, friendly name of the resource type.


        :return: The display_resource_name of this UsageRecord.
        :rtype: str
        """
        return self._display_resource_name

    @display_resource_name.setter
    def display_resource_name(self, display_resource_name):
        """
        Sets the display_resource_name of this UsageRecord.
        The human-readable, friendly name of the resource type.


        :param display_resource_name: The display_resource_name of this UsageRecord.
        :type: str
        """
        self._display_resource_name = display_resource_name

    @property
    def display_unit_name(self):
        """
        Gets the display_unit_name of this UsageRecord.
        The unit type of the resource that is being measured.


        :return: The display_unit_name of this UsageRecord.
        :rtype: str
        """
        return self._display_unit_name

    @display_unit_name.setter
    def display_unit_name(self, display_unit_name):
        """
        Sets the display_unit_name of this UsageRecord.
        The unit type of the resource that is being measured.


        :param display_unit_name: The display_unit_name of this UsageRecord.
        :type: str
        """
        self._display_unit_name = display_unit_name

    @property
    def service_name(self):
        """
        Gets the service_name of this UsageRecord.
        The human-readable, friendly name of the service.


        :return: The service_name of this UsageRecord.
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name):
        """
        Sets the service_name of this UsageRecord.
        The human-readable, friendly name of the service.


        :param service_name: The service_name of this UsageRecord.
        :type: str
        """
        self._service_name = service_name

    @property
    def currency(self):
        """
        Gets the currency of this UsageRecord.
        The currency of the cost value, in the format specified by `ISO-4217`__.

        __ https://www.iso.org/iso-4217-currency-codes.html


        :return: The currency of this UsageRecord.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this UsageRecord.
        The currency of the cost value, in the format specified by `ISO-4217`__.

        __ https://www.iso.org/iso-4217-currency-codes.html


        :param currency: The currency of this UsageRecord.
        :type: str
        """
        self._currency = currency

    @property
    def gsi_product_id(self):
        """
        Gets the gsi_product_id of this UsageRecord.
        The product identifier, or skuId.


        :return: The gsi_product_id of this UsageRecord.
        :rtype: str
        """
        return self._gsi_product_id

    @gsi_product_id.setter
    def gsi_product_id(self, gsi_product_id):
        """
        Sets the gsi_product_id of this UsageRecord.
        The product identifier, or skuId.


        :param gsi_product_id: The gsi_product_id of this UsageRecord.
        :type: str
        """
        self._gsi_product_id = gsi_product_id

    @property
    def costs(self):
        """
        Gets the costs of this UsageRecord.
        A list of the actual costs and usage amounts for the target resource type within the
        defined time interval (startTime to endTime).


        :return: The costs of this UsageRecord.
        :rtype: list[CostRecord]
        """
        return self._costs

    @costs.setter
    def costs(self, costs):
        """
        Sets the costs of this UsageRecord.
        A list of the actual costs and usage amounts for the target resource type within the
        defined time interval (startTime to endTime).


        :param costs: The costs of this UsageRecord.
        :type: list[CostRecord]
        """
        self._costs = costs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
