/* 
 * Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

// Dummy file. Actual implementation is in frontend/linux/workbench/main_form.h/cpp

#ifndef _STUB_APP_H_
#define _STUB_APP_H_

#ifdef _WIN32

#include "stub_base.h"

#include "mforms/app.h"

namespace mforms {
namespace stub {

class AppImpl : public ObjectImpl
{ 
  static void __stdcall set_status_text(App *app, const std::string &title) {}
    
  static std::string __stdcall get_resource_path(App *app, const std::string &file);

  static base::Rect __stdcall get_application_bounds(App *app) 
  {
    return base::Rect();
  }
    
  static int __stdcall enter_event_loop(App *app, float max_wait_time) 
  {
    return 0;
  }
  static void __stdcall exit_event_loop(App *app, int result) {}
    
  static void __stdcall begin_thread_loop() {}
  static void __stdcall end_thread_loop() {}

  static base::Color __stdcall get_system_color(SystemColor type) 
  {
    return base::Color();
  }

public:
  static void init(wb::WBOptions *theOptions);
};

};
};

#endif

#endif