

-- Object: web_object
-- Desc:   Stores the content of the individual web pages
-- DROP TABLE IF EXISTS web_object;
CREATE TABLE IF NOT EXISTS web_object (
  id_web_object INTEGER PRIMARY KEY AUTOINCREMENT,
  path TEXT UNIQUE NOT NULL,
  content_type TEXT NOT NULL,
  content BLOB,
  allow_embedded_code_execution INTEGER DEFAULT 0
  );
  
CREATE INDEX IF NOT EXISTS idx_web_object_path ON web_object(path);


-- Object: web_source
-- Desc:   Specifies the source url where to look for doc-lib manuals and updates
DROP TABLE IF EXISTS web_source;
CREATE TABLE web_source (
  id_web_source INTEGER PRIMARY KEY AUTOINCREMENT,
  url TEXT NOT NULL
  );

INSERT INTO web_source(id_web_source, url)
  VALUES (1, "http://wb.mysql.com/doc-lib/");


-- Object: lib
-- Desc:   Specifies the source url where to look for doc-lib manuals and updates
DROP TABLE IF EXISTS lib;
CREATE TABLE lib (
  id_lib INTEGER PRIMARY KEY,
  caption TEXT NOT NULL,
  img_path TEXT NOT NULL,
  db_file_name TEXT NOT NULL,
  release_date DATE
  );

INSERT INTO lib(id_lib, caption, img_path, 
  db_file_name, release_date)
  VALUES (1, "MySQL Workbench 6.0 Manual", "/webui/images/lib_wb.png", 
    "mysqldoclib.sqlite", "2001-05-10");

INSERT INTO lib(id_lib, caption, img_path, 
  db_file_name, release_date)
  VALUES (2, "MySQL Server 5.6 and Workbench 6.0 Manuals", "/webui/images/lib_server51_wb52.png", 
    "mysqldoclib_full_56.sqlite", "2001-05-10");
