@echo off

rem -------------------------------------------------------------------------------
rem Check parameter
if [%1] == [] goto Usage
if [%2] == [] goto Usage

rem -------------------------------------------------------------------------------
rem Script start
echo Preparing output directory...

rem -------------------------------------------------------------------------------
rem Set directory variables

set TOP_SRC_DIR=%1

set RES_DIR=%1res
echo Resources directory: %RES_DIR%

set IMAGES_DIR=%1images
echo Images directory: %IMAGES_DIR%

set SCRIPTS_DIR=%1scripts
echo Scripts directory: %SCRIPTS_DIR%

set EXT_LIB_DIR=%1..\mysql-gui-win-res\lib
echo Windows resource directory: %EXT_LIB_DIR%

set EXT_BIN_DIR=%1..\mysql-gui-win-res\redist-bin\%2
echo External binary directory: %EXT_BIN_DIR%

set EXT_SRC_DIR=%1..\mysql-gui-win-res\source\original-packages
echo External source directory: %EXT_SRC_DIR%

set TARGET_DIR=%1bin\%2
echo Target directory: %TARGET_DIR%

set FONTS_DIR=%1res\fonts
echo Fonts directory: %FONTS_DIR%

set PYTHON_SRC_DIR=%1..\mysql-gui-win-res\python27\
echo Python directory: %PYTHON_SRC_DIR%

set PYTHON_EXE=%PYTHON_SRC_DIR%\python
rem set PYTHON_EXE=\python27\python

rem -------------------------------------------------------------------------------
rem Copy the files to the target directory

echo Copy Struct files ...
if not exist %TARGET_DIR%\structs mkdir %TARGET_DIR%\structs
xcopy /i /s /y /d %RES_DIR%\grt\structs*.xml %TARGET_DIR%\structs\. 1> nul 2> nul

echo Copy image files ...
if not exist %TARGET_DIR%\images\grt\structs mkdir %TARGET_DIR%\images\grt\structs
if not exist %TARGET_DIR%\images\icons mkdir %TARGET_DIR%\images\icons
if not exist %TARGET_DIR%\images\cursors mkdir %TARGET_DIR%\images\cursors
if not exist %TARGET_DIR%\images\ui mkdir %TARGET_DIR%\images\ui
if not exist %TARGET_DIR%\images\home mkdir %TARGET_DIR%\images\home
if not exist %TARGET_DIR%\images\sql mkdir %TARGET_DIR%\images\sql
xcopy /i /s /y /d %IMAGES_DIR%\grt\*.png %TARGET_DIR%\images\grt\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\grt\structs\*.png %TARGET_DIR%\images\grt\structs\. 1> nul 2> nul
xcopy /i /y /d %IMAGES_DIR%\icons\*.png %TARGET_DIR%\images\icons\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\icons\MySQLWorkbench.ico %TARGET_DIR%\images\icons\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\toolbar\*.png %TARGET_DIR%\images\icons\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\changeset\*.png %TARGET_DIR%\images\icons\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\admin\*.png %TARGET_DIR%\images\icons\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\migration\*.png %TARGET_DIR%\images\icons\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\cursors\*.cur %TARGET_DIR%\images\cursors\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\icons\MySQLWorkbenchDoc.ico %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\icons\MySQLWBPlugin.ico %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\ui\*.png %TARGET_DIR%\images\ui\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\ui\*.xpm %TARGET_DIR%\images\ui\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\home\*.png %TARGET_DIR%\images\home\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\sql\*.png %TARGET_DIR%\images\sql\. 1> nul 2> nul

echo Copy Resource files ..
if not exist %TARGET_DIR%\data mkdir %TARGET_DIR%\data
xcopy /i /s /y /d %RES_DIR%\grtdata\*.xml %TARGET_DIR%\data\. 1> nul 2> nul
xcopy /i /s /y /d %RES_DIR%\wbdata\*.xml %TARGET_DIR%\data\. 1> nul 2> nul
xcopy /i /s /y /d %RES_DIR%\wbdata\data.db %TARGET_DIR%\data\. 1> nul 2> nul

if not exist %TARGET_DIR%\mysql.profiles mkdir %TARGET_DIR%\mysql.profiles
copy %RES_DIR%\mysql.profiles\*.xml %TARGET_DIR%\mysql.profiles\. 1> nul 2> nul

if not exist %TARGET_DIR%\snippets mkdir %TARGET_DIR%\snippets
copy %RES_DIR%\snippets\*.txt %TARGET_DIR%\snippets\. 1> nul 2> nul

if not exist %TARGET_DIR%\script_templates mkdir %TARGET_DIR%\script_templates
copy %RES_DIR%\scripts\script_templates\*.txt %TARGET_DIR%\script_templates\. 1> nul 2> nul

echo Copy Scripting Libraries...
xcopy /i /s /y /d %RES_DIR%\scripts\lua\*.lua %TARGET_DIR%\
xcopy /i /s /y /d %RES_DIR%\scripts\python\*.py %TARGET_DIR%\
xcopy /i /s /y /d %RES_DIR%\scripts\snippets\shell_snippets.* %TARGET_DIR%\
xcopy /i /s /y /d %TOP_SRC_DIR%\library\sshtunnel\sshtunnel.py %TARGET_DIR%\
xcopy /i /s /y /d %RES_DIR%\scripts\shell\*.vbs %TARGET_DIR%\

if not exist %TARGET_DIR%\workbench mkdir %TARGET_DIR%\workbench
xcopy /i /s /y /d %TOP_SRC_DIR%\library\python\workbench\*.py %TARGET_DIR%\workbench

echo Copy python/mforms
xcopy /i /s /y /d %TOP_SRC_DIR%\library\forms\swig\mforms.py %TARGET_DIR%\
xcopy /i /s /y /d %TOP_SRC_DIR%\library\forms\swig\cairo.py %TARGET_DIR%\

echo Copy libraries ...

xcopy /i /s /y /d %EXT_BIN_DIR%\mysqldump.exe %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_BIN_DIR%\mysql.exe %TARGET_DIR%\. 1> nul 2> nul

echo * MySQL client library ...
xcopy /i /s /y /d %EXT_LIB_DIR%\mysql\%2\libmysql.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\mysql\%2\libmysql.pdb %TARGET_DIR%\. 1> nul 2> nul

echo * MySQL cdbc driver ...
rem copy %EXT_LIB_DIR%\cppconn\mysql\%2\mysqlcppconn.dll %TARGET_DIR%\. 1> nul 2> nul

echo * glib libraries ...
xcopy /i /s /y /d %EXT_LIB_DIR%\glib-2.12\libglib-2.0-0.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\glib-2.12\libgmodule-2.0-0.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\glib-2.12\libgobject-2.0-0.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\glib-2.12\libgthread-2.0-0.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\glib-2.12\intl.dll %TARGET_DIR%\. 1> nul 2> nul

echo * libxml2 libraries ...
xcopy /i /s /y /d %EXT_LIB_DIR%\libxml\libxml2.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\libxml\iconv.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\libxml\zlib.dll %TARGET_DIR%\. 1> nul 2> nul

echo * zlib library ...
xcopy /i /s /y /d %EXT_LIB_DIR%\zlib\zlib1.dll %TARGET_DIR%\. 1> nul 2> nul

echo * python library ...
xcopy /i /s /y /d %EXT_LIB_DIR%"\python\%2\*.dll" %TARGET_DIR%\. 1> nul 2> nul

rem echo * sigc++ library ...
rem copy %EXT_LIB_DIR%"\sigc++\release\sigc-2.0.dll" %TARGET_DIR%\. 1> nul 2> nul
rem copy %EXT_LIB_DIR%"\sigc++\debug\sigc-2.0d.dll" %TARGET_DIR%\. 1> nul 2> nul

echo * lua library ...
xcopy /i /s /y /d %EXT_LIB_DIR%\lua-5.1\lua.dll %TARGET_DIR%\. 1> nul 2> nul

echo * glut library ...
xcopy /i /s /y /d %EXT_LIB_DIR%\glut\glut32.dll %TARGET_DIR%\. 1> nul 2> nul

echo * cairo library ...
xcopy /i /s /y /d %EXT_LIB_DIR%\cairo\*.dll %TARGET_DIR%\. 1> nul 2> nul
rem copy %EXT_LIB_DIR%\cairo\libcairo_mesa.dll %TARGET_DIR%\. 1> nul 2> nul

echo * png library ...
xcopy /i /s /y /d %EXT_LIB_DIR%\libpng\libpng12-0.dll %TARGET_DIR%\. 1> nul 2> nul

echo * MS VC runtime libraries ...
xcopy /i /s /y /d %EXT_LIB_DIR%\windows\cc3270.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\windows\cc3270mt.dll %TARGET_DIR%\. 1> nul 2> nul

echo * ctemplate library ...
copy %EXT_LIB_DIR%\ctemplate\%2\libctemplate.dll %TARGET_DIR%\. 1> nul 2> nul

echo * cppconn library ...
copy %EXT_LIB_DIR%\mysqlcppconn\%2\mysqlcppconn.dll %TARGET_DIR%\. 1> nul 2> nul

echo * pcre library ...
copy %EXT_LIB_DIR%\pcre\%2\pcre.dll %TARGET_DIR%\. 1> nul 2> nul

echo * sqlite library ...
copy %EXT_LIB_DIR%\sqlite\%2\sqlite3.dll %TARGET_DIR%\. 1> nul 2> nul

rem echo * scintilla library ... => obsolete
rem xcopy /i /s /y /d %EXT_LIB_DIR%\scintilla\SciLexer.dll %TARGET_DIR%\. 1> nul 2> nul

rem copy LGPL source packages to bin directory - only for Commercial release build
if "%2"=="Release" echo * LGPL source packages ...
if "%2"=="Release" if not exist %TARGET_DIR%\lgpl_sources mkdir %TARGET_DIR%\lgpl_sources
if "%2"=="Release" xcopy /i /s /y /d %EXT_SRC_DIR%\glib-2.12.12.tar.bz2 %TARGET_DIR%\lgpl_sources 1> nul 2> nul
if "%2"=="Release" xcopy /i /s /y /d %EXT_SRC_DIR%\libiconv-1.13.1.tar.gz %TARGET_DIR%\lgpl_sources 1> nul 2> nul
if "%2"=="Release" xcopy /i /s /y /d %EXT_SRC_DIR%\pango-1.0.5.tar.bz2 %TARGET_DIR%\lgpl_sources 1> nul 2> nul
if "%2"=="Release" xcopy /i /s /y /d %EXT_SRC_DIR%\paramiko-1.7.7.1.zip %TARGET_DIR%\lgpl_sources 1> nul 2> nul

echo * Fonts
if not exist %TARGET_DIR%\fonts mkdir %TARGET_DIR%\fonts
xcopy /i /s /y /d %FONTS_DIR%\*.* %TARGET_DIR%\fonts\. 1> nul 2> nul

echo * Templates
if not exist %TARGET_DIR%\modules\data\sqlide mkdir %TARGET_DIR%\modules\data\sqlide
xcopy /i /s /y /d %RES_DIR%\sqlidedata\templates\*.* %TARGET_DIR%\modules\data\sqlide\. 1> nul 2> nul

echo * Python libraries
if not exist %TARGET_DIR%\python mkdir %TARGET_DIR%\python 1> nul 2> nul
if not exist %TARGET_DIR%\python\lib mkdir %TARGET_DIR%\python\lib 1> nul 2> nul
if not exist %TARGET_DIR%\python\libs mkdir %TARGET_DIR%\python\libs 1> nul 2> nul
if not exist %TARGET_DIR%\python\DLLs mkdir %TARGET_DIR%\python\DLLs 1> nul 2> nul

xcopy /i /y /d %PYTHON_SRC_DIR%\lib\*.py %TARGET_DIR%\python\lib 1> nul 2> nul
xcopy /i /y /d %PYTHON_SRC_DIR%\libs\*.lib %TARGET_DIR%\python\libs 1> nul 2> nul
xcopy /i /y /d %PYTHON_SRC_DIR%\DLLs\*.pyd %TARGET_DIR%\python\DLLs 1> nul 2> nul
xcopy /i /y /d %PYTHON_SRC_DIR%\DLLs\sqlite*.dll %TARGET_DIR%\python\DLLs 1> nul 2> nul
if "%2"=="Release" del %TARGET_DIR%\python\*_d.* /S
del %TARGET_DIR%\python\*85.dll %TARGET_DIR%\python\_tkinter.*  1> nul 2> nul

xcopy /i /s /y /d %PYTHON_SRC_DIR%\%2 %TARGET_DIR% 1> nul 2> nul

xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\multiprocessing %TARGET_DIR%\python\lib\multiprocessing 1> nul 2> nul
xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\encodings %TARGET_DIR%\python\lib\encodings 1> nul 2> nul
xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\logging %TARGET_DIR%\python\lib\logging 1> nul 2> nul
xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\site-packages\Crypto %TARGET_DIR%\python\site-packages\Crypto 1> nul 2> nul
xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\site-packages\paramiko %TARGET_DIR%\python\site-packages\paramiko 1> nul 2> nul
xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\site-packages\pysqlite2 %TARGET_DIR%\python\site-packages\pysqlite2 1> nul 2> nul
xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\site-packages\%2 %TARGET_DIR%\python\site-packages 1> nul 2> nul
xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\ctypes %TARGET_DIR%\python\lib\ctypes 1> nul 2> nul
xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\sqlite3 %TARGET_DIR%\python\lib\sqlite3 1> nul 2> nul
xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\xml %TARGET_DIR%\python\lib\xml 1> nul 2> nul
xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\xml\dom %TARGET_DIR%\python\lib\xml\dom 1> nul 2> nul

echo * Copy Sample Files
if not exist %TARGET_DIR%\extras mkdir %TARGET_DIR%\extras
xcopy /i /y /d %1samples\models\* %TARGET_DIR%\extras 1> nul 2> nul

echo * README file
xcopy /i /y /d %1README %TARGET_DIR% 1> nul 2> nul

rem -------------------------------------------------------------------------------
rem Call sub-scripts

call %1\modules\PrepareOutputDir.cmd %1 %2

rem -------------------------------------------------------------------------------
rem Work is done
echo Output directory preparation complete.

rem Make sure to reset error level
set ERRORLEVEL=0

goto EndOfScript

:Usage

echo This script sets up the output directory so that applications can be started from there and find
echo all directories and files as in the final distribution. The script takes 3 parameters, the 
echo SolutionDirectory and ConfigurationName.
echo Use an ABSOLUTE PATH to the solution directory and end it with a backslash!
echo .
echo Usage: 
echo   %0 SolutionDirectory ConfigurationName
echo .
echo Example:
echo   %0 "C:\Documents and Settings\mysqldev\My Documents\work\mysql-workbench-pro\" Debug
echo .

:EndOfScript
