/* Copyright (C) 2000 MySQL AB & MySQL Finland AB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the MySQLEULA.txt file for details.
   
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named MySQLEULA.txt. The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies */

C_MODE_START

enum get_opt_var_type { GET_NO_ARG, GET_BOOL, GET_INT, GET_UINT, GET_LONG,
			GET_ULONG, GET_LL, GET_ULL, GET_STR, GET_STR_ALLOC
                      };

#define GET_ASK_ADDR	128
#define GET_TYPE_MASK	127

enum get_opt_arg_type { NO_ARG, OPT_ARG, REQUIRED_ARG };

struct my_option
{
  const char *name;                     /* Name of the option */
  int        id;                        /* unique id or short option */
  const char *comment;                  /* option comment, for autom. --help */
  gptr       *value;                    /* The variable value */
  gptr       *u_max_value;              /* The user def. max variable value */
  const char **str_values;              /* Pointer to possible values */
  enum get_opt_var_type var_type;
  enum get_opt_arg_type arg_type;
  longlong   def_value;                 /* Default value */
  longlong   min_value;                 /* Min allowed value */
  longlong   max_value;                 /* Max allowed value */
  longlong   sub_size;                  /* Subtract this from given value */
  long       block_size;                /* Value should be a mult. of this */
  int        app_type;                  /* To be used by an application */
};

extern char *disabled_my_option;
extern my_bool my_getopt_print_errors;

extern int handle_options (int *argc, char ***argv, 
			   const struct my_option *longopts, 
			   my_bool (*get_one_option)(int,
						     const struct my_option *,
						     char *));
extern void my_print_help(const struct my_option *options);
extern void my_print_variables(const struct my_option *options);
extern void my_getopt_register_get_addr(gptr* (*func_addr)(const char *, uint,
							   const struct my_option *));

ulonglong getopt_ull_limit_value(ulonglong num, const struct my_option *optp);
my_bool getopt_compare_strings(const char *s, const char *t, uint length);
C_MODE_END
