using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace test
{
  public partial class Canvas : UserControl
  {
    public enum TestMode
    {
      CairoWin32,
      CairoGlitz,
      Glitz,
    }

    public TestMode testMode = TestMode.CairoWin32;

    public Canvas()
    {
      InitializeComponent();
      SetStyle(ControlStyles.AllPaintingInWmPaint, true);
      DoubleBuffered = false;
    }

    private void Canvas_Paint(object sender, PaintEventArgs e)
    {
      Pen pen = new Pen(SystemColors.WindowText);
      e.Graphics.DrawLine(pen, new Point(e.ClipRectangle.X, e.ClipRectangle.Y),
        new Point(e.ClipRectangle.X + e.ClipRectangle.Width, e.ClipRectangle.Y + e.ClipRectangle.Height));
      e.Graphics.DrawLine(pen, new Point(e.ClipRectangle.X, e.ClipRectangle.Y + e.ClipRectangle.Height),
        new Point(e.ClipRectangle.X + e.ClipRectangle.Width, e.ClipRectangle.Y));

      Test test = new Test();
      switch (testMode)
      {
        case TestMode.CairoWin32:
          test.test_cairo_win32((IntPtr)this.Handle);
          break;
        case TestMode.CairoGlitz:
          test.test_cairo_glitz((IntPtr)this.Handle);
          break;
        case TestMode.Glitz:
          test.test_glitz((IntPtr)this.Handle);
          break;
      }
    }
  }
}
