using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using test;

namespace test_fe
{
  public partial class MainForm : Form
  {
    Canvas canvas;

    public MainForm()
    {
      InitializeComponent();

      canvas = new Canvas();
      canvas.Parent = mainPanel;
      canvas.Dock = DockStyle.Fill;
    }

    void SwitchTestMode(Canvas.TestMode testMode, String desc)
    {
      canvas.testMode = testMode;
      Text = desc;
      canvas.Invalidate();
    }

    private void testCairoWin32Button_Click(object sender, EventArgs e)
    {
      SwitchTestMode(Canvas.TestMode.CairoWin32, "Testing Cairo-WIN32");
    }

    private void testCairoGlitzButton_Click(object sender, EventArgs e)
    {
      SwitchTestMode(Canvas.TestMode.CairoGlitz, "Testing Cairo-GLITZ");
    }

    private void testGlitzButton_Click(object sender, EventArgs e)
    {
      SwitchTestMode(Canvas.TestMode.Glitz, "Testing GLITZ");
    }

    private void testCairoPdfButton_Click(object sender, EventArgs e)
    {
      Test test = new Test();
      test.test_cairo_pdf();
    }

    private void testCairoPsButton_Click(object sender, EventArgs e)
    {
      Test test = new Test();
      test.test_cairo_ps();
    }

    private void testCairoPngButton_Click(object sender, EventArgs e)
    {
      Test test = new Test();
      test.test_cairo_png();
    }

    private void testCairoSvgButton_Click(object sender, EventArgs e)
    {
      Test test = new Test();
      test.test_cairo_svg();
    }
  }
}