/* Copyright (C) 2005 MySQL AB

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA */

#include "platform_def.h"
#include <stdio.h>
#include <wchar.h>
#include "windows.h"

int rename_(const char *oldname, const char *newname)
{
  const int name_cch= MAX_PATH+1;

  WCHAR wsz_oldname[MAX_PATH+1];
  WCHAR wsz_newname[MAX_PATH+1];

  utf8_to_wc(oldname, wsz_oldname, ARR_CAPACITY(wsz_oldname));
  utf8_to_wc(newname, wsz_newname, ARR_CAPACITY(wsz_newname));

  return _wrename(wsz_oldname, wsz_newname);
}
