/* Copyright (C) 2000 MySQL AB & MySQL Finland AB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the MySQLEULA.txt file for details.
   
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named MySQLEULA.txt. The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies */

/* Error messages for mysql clients */
/* error messages for the demon is in share/language/errmsg.sys */

#ifdef	__cplusplus
extern "C" {
#endif
void	init_client_errs(void);
extern const char *client_errors[];	/* Error messages */
#ifdef	__cplusplus
}
#endif

#define CR_MIN_ERROR		2000	/* For easier client code */
#define CR_MAX_ERROR		2999
#if defined(OS2) && defined(MYSQL_SERVER)
#define CER(X) client_errors[(X)-CR_MIN_ERROR]
#elif !defined(ER)
#define ER(X) client_errors[(X)-CR_MIN_ERROR]
#endif
#define CLIENT_ERRMAP		2	/* Errormap used by my_error() */

#define CR_UNKNOWN_ERROR	2000
#define CR_SOCKET_CREATE_ERROR	2001
#define CR_CONNECTION_ERROR	2002
#define CR_CONN_HOST_ERROR	2003
#define CR_IPSOCK_ERROR		2004
#define CR_UNKNOWN_HOST		2005
#define CR_SERVER_GONE_ERROR	2006
#define CR_VERSION_ERROR	2007
#define CR_OUT_OF_MEMORY	2008
#define CR_WRONG_HOST_INFO	2009
#define CR_LOCALHOST_CONNECTION 2010
#define CR_TCP_CONNECTION	2011
#define CR_SERVER_HANDSHAKE_ERR 2012
#define CR_SERVER_LOST		2013
#define CR_COMMANDS_OUT_OF_SYNC 2014
#define CR_NAMEDPIPE_CONNECTION 2015
#define CR_NAMEDPIPEWAIT_ERROR  2016
#define CR_NAMEDPIPEOPEN_ERROR  2017
#define CR_NAMEDPIPESETSTATE_ERROR 2018
#define CR_CANT_READ_CHARSET	2019
#define CR_NET_PACKET_TOO_LARGE 2020
#define CR_EMBEDDED_CONNECTION	2021
#define CR_PROBE_SLAVE_STATUS   2022
#define CR_PROBE_SLAVE_HOSTS    2023
#define CR_PROBE_SLAVE_CONNECT  2024
#define CR_PROBE_MASTER_CONNECT 2025
#define CR_SSL_CONNECTION_ERROR 2026
#define CR_MALFORMED_PACKET     2027

/* new 4.1 error codes */
#define CR_NULL_POINTER		2028
#define CR_NO_PREPARE_STMT	2029
#define CR_NOT_ALL_PARAMS_BOUND	2030
#define CR_DATA_TRUNCATED	2031
#define CR_NO_PARAMETERS_EXISTS 2032
#define CR_INVALID_PARAMETER_NO 2033
#define CR_INVALID_BUFFER_USE	2034
#define CR_UNSUPPORTED_PARAM_TYPE 2035

#define CR_SHARED_MEMORY_CONNECTION             2036
#define CR_SHARED_MEMORY_CONNECT_REQUEST_ERROR  2037
#define CR_SHARED_MEMORY_CONNECT_ANSWER_ERROR   2038
#define CR_SHARED_MEMORY_CONNECT_FILE_MAP_ERROR 2039
#define CR_SHARED_MEMORY_CONNECT_MAP_ERROR      2040
#define CR_SHARED_MEMORY_FILE_MAP_ERROR         2041
#define CR_SHARED_MEMORY_MAP_ERROR              2042
#define CR_SHARED_MEMORY_EVENT_ERROR     	2043
#define CR_SHARED_MEMORY_CONNECT_ABANDODED_ERROR 2044
#define CR_SHARED_MEMORY_CONNECT_SET_ERROR      2045
#define CR_CONN_UNKNOW_PROTOCOL 		2046
#define CR_INVALID_CONN_HANDLE			2047
#define CR_SECURE_AUTH                          2048
