/* Copyright (C) 2005 MySQL AB

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA */

#include "platform_def.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <wchar.h>
#include <windows.h>

int stat_(const char *path, struct _stat *buffer)
{
  WCHAR wsz_path[MAX_PATH+1];

  utf8_to_wc(path, wsz_path, ARR_CAPACITY(wsz_path));

  return _wstat(wsz_path, buffer);
}
