/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 51 "parse.y"

#include "sqliteInt.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 249
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 59
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  Select* yy43;
  TriggerStep* yy75;
  struct LimitVal yy84;
  struct LikeOp yy86;
  struct {int value; int mask;} yy207;
  ExprList* yy242;
  int yy316;
  IdList* yy352;
  struct TrigEvent yy354;
  SrcList* yy419;
  Expr* yy450;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 598
#define YYNRULE 315
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
#ifdef __cplusplus
static YYMINORTYPE yyzerominor;
#else
static const YYMINORTYPE yyzerominor;
#endif

/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   296,  914,  120,  597,    2,  172,  425,  425,   62,   62,
 /*    10 */    62,   62,  210,   64,   64,   64,   64,   65,   65,   66,
 /*    20 */    66,   66,   67,  212,  398,  395,  432,  438,   69,   64,
 /*    30 */    64,   64,   64,   65,   65,   66,   66,   66,   67,  212,
 /*    40 */   458,  456,  327,  168,   61,   60,  301,  442,  443,  439,
 /*    50 */   439,   63,   63,   62,   62,   62,   62,  256,   64,   64,
 /*    60 */    64,   64,   65,   65,   66,   66,   66,   67,  212,  296,
 /*    70 */   498,  425,  425,  212,  427,   83,   68,  469,   70,  154,
 /*    80 */    64,   64,   64,   64,   65,   65,   66,   66,   66,   67,
 /*    90 */   212,   68,  307,   70,  154,  432,  438,  454,  214,   59,
 /*   100 */    65,   65,   66,   66,   66,   67,  212,  429,  429,  429,
 /*   110 */   497,  583,  296,   61,   60,  301,  442,  443,  439,  439,
 /*   120 */    63,   63,   62,   62,   62,   62,  321,   64,   64,   64,
 /*   130 */    64,   65,   65,   66,   66,   66,   67,  212,  432,  438,
 /*   140 */    95,   66,   66,   66,   67,  212,  403,  256,  421,   35,
 /*   150 */    57,   67,  212,  175,  417,  499,   61,   60,  301,  442,
 /*   160 */   443,  439,  439,   63,   63,   62,   62,   62,   62,   19,
 /*   170 */    64,   64,   64,   64,   65,   65,   66,   66,   66,   67,
 /*   180 */   212,  296,  225,  532,  299,  581,  109,  422,  242,  458,
 /*   190 */   416,  335,  414,   21,  502,  503,  346,  403,  527,  176,
 /*   200 */   160,  454,  214,  580,  579,  344,  500,  432,  438,  149,
 /*   210 */   150,  404,  405,  539,  514,  418,  151,  541,    8,  498,
 /*   220 */   538,  577,  578,  427,  296,   61,   60,  301,  442,  443,
 /*   230 */   439,  439,   63,   63,   62,   62,   62,   62,  196,   64,
 /*   240 */    64,   64,   64,   65,   65,   66,   66,   66,   67,  212,
 /*   250 */   432,  438,  454,  598,  398,  395,  429,  429,  429,  369,
 /*   260 */   558,  481,  404,  405,  372,  576,  213,  296,   61,   60,
 /*   270 */   301,  442,  443,  439,  439,   63,   63,   62,   62,   62,
 /*   280 */    62,  321,   64,   64,   64,   64,   65,   65,   66,   66,
 /*   290 */    66,   67,  212,  432,  438,  555,  503,  304,  557,  532,
 /*   300 */   218,  557,  552,  421,   36,  234,  397,    2,  542,   21,
 /*   310 */   540,   61,   60,  301,  442,  443,  439,  439,   63,   63,
 /*   320 */    62,   62,   62,   62,  388,   64,   64,   64,   64,   65,
 /*   330 */    65,   66,   66,   66,   67,  212,  415,  530,   85,  381,
 /*   340 */    78,  323,  296,  210,  304,  527,  493,  492,  379,  274,
 /*   350 */   273,  379,  274,  273,  347,  463,  241,  387,  268,  210,
 /*   360 */   533,  581,  210,  403,   20,  224,  144,  464,  432,  438,
 /*   370 */   485,  164,  114,  248,  349,  253,  350,  177,  554,  580,
 /*   380 */   465,  420,  331,   81,  257,  419,   61,   60,  301,  442,
 /*   390 */   443,  439,  439,   63,   63,   62,   62,   62,   62,  391,
 /*   400 */    64,   64,   64,   64,   65,   65,   66,   66,   66,   67,
 /*   410 */   212,  296,  224,  203,  249,  496,  403,  440,  837,  114,
 /*   420 */   248,  349,  253,  350,  177,  250,  321,  152,  404,  405,
 /*   430 */   321,  257,  303,  324,  155,  445,  445,  432,  438,  317,
 /*   440 */   400,  389,  213,   68,  209,   70,  154,  422,  421,   35,
 /*   450 */   393,  202,  421,   42,  481,   61,   60,  301,  442,  443,
 /*   460 */   439,  439,   63,   63,   62,   62,   62,   62,  422,   64,
 /*   470 */    64,   64,   64,   65,   65,   66,   66,   66,   67,  212,
 /*   480 */   296,  404,  405,  183,  513,  422,  351,  354,  355,  403,
 /*   490 */    77,  335,   79,  489,  216,  183,  334,  356,  351,  354,
 /*   500 */   355,  433,  434,  406,  407,  408,  432,  438,  235,  356,
 /*   510 */   386,   68,  291,   70,  154,  456,  531,  168,  198,  302,
 /*   520 */   449,  450,  436,  437,   61,   60,  301,  442,  443,  439,
 /*   530 */   439,   63,   63,   62,   62,   62,   62,  394,   64,   64,
 /*   540 */    64,   64,   65,   65,   66,   66,   66,   67,  212,  296,
 /*   550 */   321,  435,  422,  260,  404,  405,  321,  183,  153,  321,
 /*   560 */   351,  354,  355,  446,  332,  321,  595,  905,  321,  905,
 /*   570 */     1,  356,  421,   28,  403,  432,  438,  376,  421,   42,
 /*   580 */   477,  421,   35,  213,  548,  366,  548,  421,   50,  159,
 /*   590 */   421,   50,  422,   61,   60,  301,  442,  443,  439,  439,
 /*   600 */    63,   63,   62,   62,   62,   62,  592,   64,   64,   64,
 /*   610 */    64,   65,   65,   66,   66,   66,   67,  212,  296,  337,
 /*   620 */   217,  463,  256,   94,  339,  326,  449,  450,  172,  340,
 /*   630 */   425,  345,  532,  464,  312,  595,  904,  313,  904,  404,
 /*   640 */   405,  588,   21,  226,  432,  438,  465,  243,  504,  324,
 /*   650 */   322,  445,  445,  421,    3,  459,  230,  308,  505,  194,
 /*   660 */   278,  296,   61,   60,  301,  442,  443,  439,  439,   63,
 /*   670 */    63,   62,   62,   62,   62,  592,   64,   64,   64,   64,
 /*   680 */    65,   65,   66,   66,   66,   67,  212,  432,  438,  213,
 /*   690 */   179,  180,  181,  422,  324,  425,  445,  445,  281,  262,
 /*   700 */   279,  402,  194,  481,  296,   61,   60,  301,  442,  443,
 /*   710 */   439,  439,   63,   63,   62,   62,   62,   62,  377,   64,
 /*   720 */    64,   64,   64,   65,   65,   66,   66,   66,   67,  212,
 /*   730 */   432,  438,  591,  295,  115,  268,  422,  266,  211,  264,
 /*   740 */   373,  324,  246,  445,  445,   56,  256,  296,   61,   71,
 /*   750 */   301,  442,  443,  439,  439,   63,   63,   62,   62,   62,
 /*   760 */    62,  377,   64,   64,   64,   64,   65,   65,   66,   66,
 /*   770 */    66,   67,  212,  432,  438,  550,  269,  474,   18,  549,
 /*   780 */   280,  309,  343,  380,  171,  160,  256,  268,    5,  268,
 /*   790 */   296,  368,   60,  301,  442,  443,  439,  439,   63,   63,
 /*   800 */    62,   62,   62,   62,  321,   64,   64,   64,   64,   65,
 /*   810 */    65,   66,   66,   66,   67,  212,  432,  438,  403,   10,
 /*   820 */   403,  310,  268,  403,  268,  485,  421,   29,  566,   22,
 /*   830 */   568,  420,  428,  425,  376,  419,  301,  442,  443,  439,
 /*   840 */   439,   63,   63,   62,   62,   62,   62,  321,   64,   64,
 /*   850 */    64,   64,   65,   65,   66,   66,   66,   67,  212,   73,
 /*   860 */   328,  485,    4,  569,  268,  570,  300,  268,  147,  421,
 /*   870 */    24,  321,  359,  321,  325,   73,  328,  491,    4,  455,
 /*   880 */   321,  342,  300,  404,  405,  404,  405,  367,  404,  405,
 /*   890 */   325,  330,  321,  421,   33,  421,   54,  321,  425,  178,
 /*   900 */   229,  458,  421,   53,  321,  227,  321,  330,  228,  478,
 /*   910 */   165,  321,  315,  119,  421,   99,  333,  458,  321,  421,
 /*   920 */    97,   76,   75,  311,  268,  519,  421,  102,  421,  103,
 /*   930 */    74,  319,  320,  421,  108,  427,  467,   76,   75,  490,
 /*   940 */   421,  110,  452,  452,  321,  520,   74,  319,  320,   73,
 /*   950 */   328,  427,    4,  210,  298,  321,  300,  321,  156,  257,
 /*   960 */   321,  210,  185,  182,  325,  284,  421,   17,  429,  429,
 /*   970 */   429,  430,  431,   12,  593,  378,  188,  421,  100,  421,
 /*   980 */    34,  330,  421,   98,  429,  429,  429,  430,  431,   12,
 /*   990 */   475,  458,  422,  162,  480,  321,  422,  306,  231,  232,
 /*  1000 */   233,  105,  484,  632,  476,  321,  486,  447,  321,   23,
 /*  1010 */   422,   76,   75,  594,  207,  178,  286,  421,   25,  254,
 /*  1020 */    74,  319,  320,  287,  321,  427,  321,  421,   55,  321,
 /*  1030 */   421,  111,  321,  471,  321,  205,  515,  557,  511,  363,
 /*  1040 */   472,  204,  321,  516,  206,  321,  421,  112,  421,  113,
 /*  1050 */   321,  421,   26,  321,  421,   37,  421,   38,  429,  429,
 /*  1060 */   429,  430,  431,   12,  421,   27,  521,  421,   39,  321,
 /*  1070 */   298,  158,  421,   40,  255,  421,   41,  321,  483,  321,
 /*  1080 */   173,  523,  321,  182,  321,  522,  321,  384,  283,  273,
 /*  1090 */   321,  421,   43,  297,  534,  321,  476,  321,  210,  421,
 /*  1100 */    44,  421,   45,  321,  421,   30,  421,   31,  421,   46,
 /*  1110 */   508,  509,  421,   47,  259,  321,  182,  421,   48,  421,
 /*  1120 */    49,  321,  358,  390,  182,  421,   32,  321,  261,  518,
 /*  1130 */   517,  553,  561,  182,  173,  412,  191,  421,   11,  562,
 /*  1140 */   573,   92,   92,  421,   51,  590,  263,  294,  265,  421,
 /*  1150 */    52,  267,  272,  371,  146,  374,  375,  275,  276,  277,
 /*  1160 */   565,  575,  285,  288,  289,  587,  470,  451,  236,  453,
 /*  1170 */   329,  244,  473,  514,  251,  524,  560,  163,  401,  572,
 /*  1180 */   426,  525,  282,  528,  409,    7,  410,  411,  385,  318,
 /*  1190 */    85,  237,  338,  526,   84,  336,  353,   58,   80,  215,
 /*  1200 */   170,  468,  121,   86,  341,  348,  305,  501,  506,  124,
 /*  1210 */   511,  222,  360,  423,  252,  186,  512,  510,  221,  223,
 /*  1220 */   238,  507,  239,  535,  240,  292,  424,  529,  536,  537,
 /*  1230 */   293,  543,  187,  189,  245,  362,  482,  488,  247,  190,
 /*  1240 */   364,   89,  545,  192,  117,  370,  132,  556,  563,  195,
 /*  1250 */   382,  383,  314,  133,  134,  571,  138,  135,  136,  584,
 /*  1260 */   589,  585,  142,  399,  101,  413,  220,  586,  270,  104,
 /*  1270 */   141,  633,  634,  166,  167,  441,  444,   72,  460,  448,
 /*  1280 */   457,  546,  143,  157,    6,  461,   14,  479,  169,  462,
 /*  1290 */    93,  466,   82,  122,   13,  174,  487,   96,  123,  161,
 /*  1300 */   494,  495,   87,  125,  126,  116,  258,   88,  127,  184,
 /*  1310 */   250,  361,  219,  107,  544,  145,  128,  193,  365,  118,
 /*  1320 */   352,  357,  173,  271,  130,    9,  316,  559,  197,   90,
 /*  1330 */   547,  131,  129,   15,  199,  551,  564,  200,  567,  201,
 /*  1340 */   139,  137,  582,   91,   16,  106,  140,  208,  574,  392,
 /*  1350 */   396,  290,  148,  596,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  140,  141,  142,  143,   21,   23,   23,   69,   70,
 /*    10 */    71,   72,  110,   74,   75,   76,   77,   78,   79,   80,
 /*    20 */    81,   82,   83,   84,    1,    2,   42,   43,   73,   74,
 /*    30 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    40 */    58,  162,  163,  164,   60,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,  148,   74,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */    88,   88,   88,   84,   92,   22,  219,  220,  221,  222,
 /*    80 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    90 */    84,  219,  183,  221,  222,   42,   43,   78,   79,   46,
 /*   100 */    78,   79,   80,   81,   82,   83,   84,  125,  126,  127,
 /*   110 */   170,  239,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,  148,   74,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    44,   80,   81,   82,   83,   84,   23,  148,  170,  171,
 /*   150 */    19,   83,   84,  156,   23,  170,   60,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   19,
 /*   170 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   16,  183,  148,  151,  148,   21,  190,  148,   58,
 /*   190 */   169,  213,  157,  158,  186,  187,  218,   23,  177,  202,
 /*   200 */   203,   78,   79,  166,  167,  208,  161,   42,   43,   78,
 /*   210 */    79,   88,   89,  177,  178,  170,  181,  182,   68,   88,
 /*   220 */   184,   98,   99,   92,   16,   60,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,   22,   74,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    42,   43,   78,    0,    1,    2,  125,  126,  127,  226,
 /*   260 */    11,  162,   88,   89,  231,  228,  229,   16,   60,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,  148,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */    82,   83,   84,   42,   43,  186,  187,   16,   49,  148,
 /*   300 */   201,   49,   18,  170,  171,  154,  142,  143,  157,  158,
 /*   310 */   182,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   320 */    69,   70,   71,   72,   91,   74,   75,   76,   77,   78,
 /*   330 */    79,   80,   81,   82,   83,   84,  168,  169,  122,   55,
 /*   340 */   132,   16,   16,  110,   16,  177,   20,   20,   99,  100,
 /*   350 */   101,   99,  100,  101,   80,   12,  223,  124,  148,  110,
 /*   360 */   182,  148,  110,   23,   19,   84,   21,   24,   42,   43,
 /*   370 */   148,   90,   91,   92,   93,   94,   95,   96,   94,  166,
 /*   380 */    37,  107,   39,  132,  103,  111,   60,   61,   62,   63,
 /*   390 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  189,
 /*   400 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   410 */    84,   16,   84,  156,   92,   20,   23,   92,  134,   91,
 /*   420 */    92,   93,   94,   95,   96,  103,  148,   22,   88,   89,
 /*   430 */   148,  103,  210,  106,  156,  108,  109,   42,   43,  144,
 /*   440 */   145,  228,  229,  219,  149,  221,  222,  190,  170,  171,
 /*   450 */   240,  156,  170,  171,  162,   60,   61,   62,   63,   64,
 /*   460 */    65,   66,   67,   68,   69,   70,   71,   72,  190,   74,
 /*   470 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   480 */    16,   88,   89,   90,   20,  190,   93,   94,   95,   23,
 /*   490 */   131,  213,  133,  201,  212,   90,  218,  104,   93,   94,
 /*   500 */    95,   42,   43,    7,    8,    9,   42,   43,  191,  104,
 /*   510 */   215,  219,  159,  221,  222,  162,  163,  164,  156,  165,
 /*   520 */   166,  167,   63,   64,   60,   61,   62,   63,   64,   65,
 /*   530 */    66,   67,   68,   69,   70,   71,   72,  242,   74,   75,
 /*   540 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*   550 */   148,   92,  190,   20,   88,   89,  148,   90,  156,  148,
 /*   560 */    93,   94,   95,   20,  187,  148,   19,   20,  148,   22,
 /*   570 */    19,  104,  170,  171,   23,   42,   43,  148,  170,  171,
 /*   580 */   114,  170,  171,  229,   99,  100,  101,  170,  171,  148,
 /*   590 */   170,  171,  190,   60,   61,   62,   63,   64,   65,   66,
 /*   600 */    67,   68,   69,   70,   71,   72,   59,   74,   75,   76,
 /*   610 */    77,   78,   79,   80,   81,   82,   83,   84,   16,  211,
 /*   620 */   212,   12,  148,   21,  213,  165,  166,  167,   21,  148,
 /*   630 */    23,  148,  148,   24,  217,   19,   20,  217,   22,   88,
 /*   640 */    89,  157,  158,  214,   42,   43,   37,  148,   39,  106,
 /*   650 */   148,  108,  109,  170,  171,   20,  146,  183,   49,  156,
 /*   660 */    14,   16,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   670 */    68,   69,   70,   71,   72,   59,   74,   75,   76,   77,
 /*   680 */    78,   79,   80,   81,   82,   83,   84,   42,   43,  229,
 /*   690 */    99,  100,  101,  190,  106,   88,  108,  109,   52,   14,
 /*   700 */    54,  148,  156,  162,   16,   60,   61,   62,   63,   64,
 /*   710 */    65,   66,   67,   68,   69,   70,   71,   72,  215,   74,
 /*   720 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   730 */    42,   43,  245,  246,  148,  148,  190,   52,  193,   54,
 /*   740 */   237,  106,  201,  108,  109,  200,  148,   16,   60,   61,
 /*   750 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   760 */    72,  215,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   770 */    82,   83,   84,   42,   43,   25,  189,   22,  232,   29,
 /*   780 */   134,  183,   16,  237,  202,  203,  148,  148,  192,  148,
 /*   790 */    16,   41,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   800 */    69,   70,   71,   72,  148,   74,   75,   76,   77,   78,
 /*   810 */    79,   80,   81,   82,   83,   84,   42,   43,   23,   19,
 /*   820 */    23,  183,  148,   23,  148,  148,  170,  171,  189,   19,
 /*   830 */   189,  107,  148,   23,  148,  111,   62,   63,   64,   65,
 /*   840 */    66,   67,   68,   69,   70,   71,   72,  148,   74,   75,
 /*   850 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*   860 */    17,  148,   19,  189,  148,  189,   23,  148,  113,  170,
 /*   870 */   171,  148,   16,  148,   31,   16,   17,   80,   19,  162,
 /*   880 */   148,  115,   23,   88,   89,   88,   89,  210,   88,   89,
 /*   890 */    31,   48,  148,  170,  171,  170,  171,  148,   88,   43,
 /*   900 */   214,   58,  170,  171,  148,  189,  148,   48,  189,  114,
 /*   910 */    19,  148,  243,  244,  170,  171,  148,   58,  148,  170,
 /*   920 */   171,   78,   79,  210,  148,   30,  170,  171,  170,  171,
 /*   930 */    87,   88,   89,  170,  171,   92,  148,   78,   79,   80,
 /*   940 */   170,  171,  125,  126,  148,   50,   87,   88,   89,   16,
 /*   950 */    17,   92,   19,  110,   98,  148,   23,  148,  156,  103,
 /*   960 */   148,  110,  156,   22,   31,  189,  170,  171,  125,  126,
 /*   970 */   127,  128,  129,  130,   20,  124,  156,  170,  171,  170,
 /*   980 */   171,   48,  170,  171,  125,  126,  127,  128,  129,  130,
 /*   990 */   204,   58,  190,    5,  148,  148,  190,  102,   10,   11,
 /*  1000 */    12,   13,  148,  112,   22,  148,  148,   20,  148,   22,
 /*  1010 */   190,   78,   79,   59,   26,   43,   28,  170,  171,  148,
 /*  1020 */    87,   88,   89,   35,  148,   92,  148,  170,  171,  148,
 /*  1030 */   170,  171,  148,   27,  148,   47,  148,   49,   97,  234,
 /*  1040 */    34,   53,  148,  179,   56,  148,  170,  171,  170,  171,
 /*  1050 */   148,  170,  171,  148,  170,  171,  170,  171,  125,  126,
 /*  1060 */   127,  128,  129,  130,  170,  171,  179,  170,  171,  148,
 /*  1070 */    98,   89,  170,  171,  148,  170,  171,  148,   20,  148,
 /*  1080 */    22,   20,  148,   22,  148,  179,  148,   99,  100,  101,
 /*  1090 */   148,  170,  171,  105,  148,  148,  114,  148,  110,  170,
 /*  1100 */   171,  170,  171,  148,  170,  171,  170,  171,  170,  171,
 /*  1110 */     7,    8,  170,  171,   20,  148,   22,  170,  171,  170,
 /*  1120 */   171,  148,   20,  135,   22,  170,  171,  148,  148,   91,
 /*  1130 */    92,   20,   20,   22,   22,  150,  233,  170,  171,   20,
 /*  1140 */    20,   22,   22,  170,  171,   20,  148,   22,  148,  170,
 /*  1150 */   171,  148,  148,  148,  192,  148,  148,  148,  148,  148,
 /*  1160 */   148,  148,  148,  148,  148,  148,  173,  230,  194,  230,
 /*  1170 */   225,  205,  173,  178,  173,  173,  195,    6,  147,  195,
 /*  1180 */   162,  162,  205,  162,  147,   22,  147,  147,  205,  155,
 /*  1190 */   122,  195,  119,  173,  120,  118,  174,  121,  131,  224,
 /*  1200 */   112,  153,  153,   98,  117,   98,   40,  172,  172,   19,
 /*  1210 */    97,   84,   15,  190,  172,  152,  172,  174,  227,  227,
 /*  1220 */   196,  180,  197,  172,  198,  175,  199,  180,  172,  172,
 /*  1230 */   175,  153,  152,  152,  206,  153,  207,  207,  206,  153,
 /*  1240 */    38,  131,  153,  152,   60,  153,   19,  185,  195,  185,
 /*  1250 */   153,   15,  153,  188,  188,  195,  185,  188,  188,   33,
 /*  1260 */   138,  153,  216,    1,  160,   20,  176,  153,  235,  176,
 /*  1270 */   216,  112,  112,  112,  112,   92,  107,   19,   11,   20,
 /*  1280 */    20,  236,   19,   19,  116,   20,  116,  114,   22,   20,
 /*  1290 */   238,   20,   22,   19,   22,  116,  115,  238,   20,  112,
 /*  1300 */    20,   20,   19,   19,   19,   32,   20,   19,   19,   96,
 /*  1310 */   103,   16,   44,  241,   17,   21,   98,   98,   36,  244,
 /*  1320 */    44,   44,   22,  134,   19,    5,  247,    1,  123,   68,
 /*  1330 */    51,  102,   45,   19,  113,   45,    1,   14,   17,  117,
 /*  1340 */   102,  113,   20,   68,   19,   14,  123,  136,  124,   57,
 /*  1350 */     3,  137,   19,    4,
};
#define YY_SHIFT_USE_DFLT (-99)
#define YY_SHIFT_MAX 396
static const short yy_shift_ofst[] = {
 /*     0 */    23,  843,  988,  -16,  843,  933,  933,  393,  123,  252,
 /*    10 */   -98,   96,  933,  933,  933,  933,  933,  -45,  249,  174,
 /*    20 */   340,  -17,   19,   19,   53,  165,  208,  251,  326,  395,
 /*    30 */   464,  533,  602,  645,  688,  645,  645,  645,  645,  645,
 /*    40 */   645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
 /*    50 */   645,  645,  645,  731,  774,  774,  859,  933,  933,  933,
 /*    60 */   933,  933,  933,  933,  933,  933,  933,  933,  933,  933,
 /*    70 */   933,  933,  933,  933,  933,  933,  933,  933,  933,  933,
 /*    80 */   933,  933,  933,  933,  933,  933,  933,  933,  933,  933,
 /*    90 */   933,  933,  933,  933,  933,  933,  933,  -61,  -61,    6,
 /*   100 */     6,  281,   22,   61,  856,  284,  340,  340,   68,  -17,
 /*   110 */   -11,  -99,  -99,  -99,  131,  328,  609,  609,  547,  616,
 /*   120 */   253,  607,  340,  607,  340,  340,  340,  340,  340,  340,
 /*   130 */   340,  340,  340,  340,  340,  340,  340,  340,  340,  340,
 /*   140 */   340,  233,  851,  -98,  -98,  -98,  -99,  -99,  -99,  -18,
 /*   150 */   -18,  405,  467,  327,  551,  543,  635,  343,  466,  795,
 /*   160 */   800,  797,  496,  340,  340,  274,  340,  340,  810,  340,
 /*   170 */   340,  982,  340,  340,  340,  588,  982,  340,  340,  895,
 /*   180 */   895,  895,  340,  340,  340,  588,  340,  340,  588,  340,
 /*   190 */   750,  485,  340,  340,  588,  340,  340,  340,  588,  340,
 /*   200 */   340,  340,  588,  588,  340,  340,  340,  340,  340,  345,
 /*   210 */   724,  755,  -17,  817,  817,  359, 1006, 1006,  766, 1006,
 /*   220 */   972, 1006,  -17, 1006,  -17,  941,  216,  766,  766,  216,
 /*   230 */  1171, 1171, 1171, 1171, 1163,  -98, 1068, 1073, 1074, 1077,
 /*   240 */  1076, 1067, 1088, 1088, 1105, 1087, 1105, 1087, 1107, 1107,
 /*   250 */  1166, 1107, 1113, 1107, 1190, 1127, 1127, 1166, 1107, 1107,
 /*   260 */  1107, 1190, 1197, 1088, 1197, 1088, 1197, 1088, 1088, 1202,
 /*   270 */  1110, 1197, 1088, 1184, 1184, 1227, 1068, 1088, 1236, 1236,
 /*   280 */  1236, 1236, 1068, 1184, 1227, 1088, 1226, 1226, 1088, 1088,
 /*   290 */  1122,  -99,  -99,  -99,  -99,  -99,  459,  646,  591,  685,
 /*   300 */   891,  325,  987, 1058,  322, 1103, 1038, 1061, 1094, 1102,
 /*   310 */  1111, 1112, 1119, 1120,  150, 1125,  954, 1262, 1245, 1159,
 /*   320 */  1160, 1161, 1162, 1183, 1169, 1258, 1259, 1260, 1263, 1267,
 /*   330 */  1264, 1265, 1266, 1269, 1271, 1270, 1168, 1272, 1170, 1270,
 /*   340 */  1173, 1274, 1179, 1181, 1278, 1187, 1280, 1281, 1273, 1268,
 /*   350 */  1283, 1276, 1284, 1286, 1285, 1288, 1277, 1289, 1213, 1207,
 /*   360 */  1295, 1297, 1294, 1218, 1282, 1279, 1287, 1300, 1290, 1189,
 /*   370 */  1219, 1305, 1320, 1326, 1229, 1261, 1275, 1205, 1314, 1221,
 /*   380 */  1335, 1323, 1222, 1321, 1228, 1238, 1223, 1325, 1224, 1322,
 /*   390 */  1331, 1292, 1211, 1214, 1333, 1347, 1349,
};
#define YY_REDUCE_USE_DFLT (-144)
#define YY_REDUCE_MAX 295
static const short yy_reduce_ofst[] = {
 /*     0 */  -139,  278,  295,  292,  402,  -22,  408,   35,   37,  546,
 /*    10 */    -3, -128,  133,  282,  411,  417,  420, -143,  503,  213,
 /*    20 */   151,  353,  354,  460,  224,  224,  224,  224,  224,  224,
 /*    30 */   224,  224,  224,  224,  224,  224,  224,  224,  224,  224,
 /*    40 */   224,  224,  224,  224,  224,  224,  224,  224,  224,  224,
 /*    50 */   224,  224,  224,  224,  224,  224,  483,  656,  699,  723,
 /*    60 */   725,  732,  744,  749,  756,  758,  763,  770,  796,  807,
 /*    70 */   809,  812,  847,  857,  860,  876,  878,  881,  884,  886,
 /*    80 */   894,  897,  902,  905,  921,  929,  931,  934,  936,  938,
 /*    90 */   942,  947,  949,  955,  967,  973,  979,  224,  224,  224,
 /*   100 */   224,  168,  224,  224,   36,   33,  210,  484,  224, -121,
 /*   110 */   224,  224,  224,  224,   45,   21,    8,  109,  487,  487,
 /*   120 */   164,   99,  222,  541,  -91,   -1,  474,  598,  587,  677,
 /*   130 */   638,  429,  713,  639,  641,  674,  676,  716,  719,  686,
 /*   140 */   776,  257,  362,  802,  806,  820,  545,  582,  669,  -60,
 /*   150 */   -15,  128,  178,  317,   40,  317,  317,  377,  441,  481,
 /*   160 */   499,  502,  510,  553,  586,  596,  502,  684,  717,  768,
 /*   170 */   788,  786,  846,  854,  858,  317,  786,  871,  888,  864,
 /*   180 */   887,  906,  926,  946,  980,  317,  998, 1000,  317, 1003,
 /*   190 */   903,  805, 1004, 1005,  317, 1007, 1008, 1009,  317, 1010,
 /*   200 */  1011, 1012,  317,  317, 1013, 1014, 1015, 1016, 1017,  985,
 /*   210 */   962,  974, 1018,  937,  939,  945,  993,  999,  966, 1001,
 /*   220 */   995, 1002, 1019, 1020, 1021, 1022,  981,  977,  983,  984,
 /*   230 */  1031, 1037, 1039, 1040, 1034, 1023,  996, 1024, 1025, 1026,
 /*   240 */  1027,  975, 1048, 1049, 1028, 1029, 1032, 1030, 1035, 1036,
 /*   250 */  1041, 1042, 1043, 1044, 1050,  991,  992, 1047, 1051, 1056,
 /*   260 */  1057, 1055, 1063, 1078, 1080, 1082, 1081, 1086, 1089, 1033,
 /*   270 */  1045, 1091, 1092, 1062, 1064, 1046, 1053, 1097, 1065, 1066,
 /*   280 */  1069, 1070, 1060, 1071, 1054, 1099, 1052, 1059, 1108, 1114,
 /*   290 */  1072, 1104, 1090, 1093, 1075, 1079,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   603,  832,  913,  719,  913,  832,  913,  913,  859,  913,
 /*    10 */   723,  888,  830,  913,  913,  913,  913,  804,  913,  859,
 /*    20 */   913,  635,  859,  859,  755,  913,  913,  913,  913,  913,
 /*    30 */   913,  913,  913,  756,  913,  834,  829,  825,  827,  826,
 /*    40 */   833,  757,  746,  753,  760,  735,  872,  762,  763,  769,
 /*    50 */   770,  889,  887,  792,  791,  810,  913,  913,  913,  913,
 /*    60 */   913,  913,  913,  913,  913,  913,  913,  913,  913,  913,
 /*    70 */   913,  913,  913,  913,  913,  913,  913,  913,  913,  913,
 /*    80 */   913,  913,  913,  913,  913,  913,  913,  913,  913,  913,
 /*    90 */   913,  913,  913,  913,  913,  913,  913,  794,  816,  793,
 /*   100 */   803,  628,  795,  796,  688,  623,  913,  913,  797,  913,
 /*   110 */   798,  811,  812,  813,  913,  913,  913,  913,  913,  913,
 /*   120 */   603,  719,  913,  719,  913,  913,  913,  913,  913,  913,
 /*   130 */   913,  913,  913,  913,  913,  913,  913,  913,  913,  913,
 /*   140 */   913,  913,  913,  913,  913,  913,  713,  723,  906,  913,
 /*   150 */   913,  679,  913,  913,  913,  913,  913,  913,  913,  913,
 /*   160 */   913,  913,  611,  609,  913,  711,  913,  913,  637,  913,
 /*   170 */   913,  721,  913,  913,  913,  726,  727,  913,  913,  913,
 /*   180 */   913,  913,  913,  913,  913,  625,  913,  913,  700,  913,
 /*   190 */   865,  913,  913,  913,  879,  913,  913,  913,  877,  913,
 /*   200 */   913,  913,  702,  765,  845,  913,  892,  894,  913,  913,
 /*   210 */   711,  720,  913,  913,  913,  828,  749,  749,  737,  749,
 /*   220 */   658,  749,  913,  749,  913,  661,  759,  737,  737,  759,
 /*   230 */   608,  608,  608,  608,  678,  913,  759,  750,  752,  742,
 /*   240 */   754,  913,  728,  728,  736,  741,  736,  741,  690,  690,
 /*   250 */   675,  690,  661,  690,  838,  842,  842,  675,  690,  690,
 /*   260 */   690,  838,  620,  728,  620,  728,  620,  728,  728,  869,
 /*   270 */   871,  620,  728,  692,  692,  771,  759,  728,  699,  699,
 /*   280 */   699,  699,  759,  692,  771,  728,  891,  891,  728,  728,
 /*   290 */   899,  645,  663,  663,  906,  911,  913,  913,  913,  913,
 /*   300 */   778,  913,  913,  913,  913,  913,  913,  913,  913,  913,
 /*   310 */   913,  913,  913,  913,  852,  913,  913,  913,  913,  783,
 /*   320 */   779,  913,  780,  913,  705,  913,  913,  913,  913,  913,
 /*   330 */   913,  913,  913,  913,  913,  831,  913,  743,  913,  751,
 /*   340 */   913,  913,  913,  913,  913,  913,  913,  913,  913,  913,
 /*   350 */   913,  913,  913,  913,  913,  913,  913,  913,  913,  913,
 /*   360 */   913,  913,  913,  913,  913,  913,  867,  868,  913,  913,
 /*   370 */   913,  913,  913,  913,  913,  913,  913,  913,  913,  913,
 /*   380 */   913,  913,  913,  913,  913,  913,  913,  913,  913,  913,
 /*   390 */   913,  898,  913,  913,  901,  604,  913,  599,  601,  602,
 /*   400 */   606,  607,  610,  632,  633,  634,  612,  613,  614,  615,
 /*   410 */   616,  617,  618,  624,  626,  644,  646,  630,  648,  709,
 /*   420 */   710,  775,  703,  704,  708,  631,  786,  777,  781,  782,
 /*   430 */   784,  785,  799,  800,  802,  808,  815,  818,  801,  806,
 /*   440 */   807,  809,  814,  817,  706,  707,  821,  638,  639,  642,
 /*   450 */   643,  855,  857,  856,  858,  641,  640,  787,  790,  823,
 /*   460 */   824,  880,  881,  882,  883,  884,  819,  729,  822,  805,
 /*   470 */   744,  747,  748,  745,  712,  722,  731,  732,  733,  734,
 /*   480 */   717,  718,  724,  740,  773,  774,  738,  739,  725,  714,
 /*   490 */   715,  716,  820,  776,  788,  789,  649,  650,  783,  651,
 /*   500 */   652,  653,  691,  694,  695,  696,  654,  673,  676,  677,
 /*   510 */   655,  662,  656,  657,  664,  665,  666,  669,  670,  671,
 /*   520 */   672,  667,  668,  839,  840,  843,  841,  659,  660,  674,
 /*   530 */   647,  636,  629,  680,  683,  684,  685,  686,  687,  689,
 /*   540 */   681,  682,  627,  619,  621,  730,  861,  870,  866,  862,
 /*   550 */   863,  864,  622,  835,  836,  693,  767,  768,  860,  873,
 /*   560 */   875,  772,  876,  878,  874,  903,  697,  698,  701,  844,
 /*   570 */   885,  758,  761,  764,  766,  846,  847,  848,  849,  850,
 /*   580 */   853,  854,  851,  886,  890,  893,  895,  896,  897,  900,
 /*   590 */   902,  907,  908,  909,  912,  910,  605,  600,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*    INDEXED => nothing */
    0,  /*         BY => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "TRIGGER",       "VACUUM",        "VIEW",          "VIRTUAL",     
  "REINDEX",       "RENAME",        "CTIME_KW",      "ANY",         
  "OR",            "AND",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "AUTOINCR",      "ON",            "DELETE",      
  "UPDATE",        "INSERT",        "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "SELECT",        "DISTINCT",    
  "DOT",           "FROM",          "JOIN",          "INDEXED",     
  "BY",            "USING",         "ORDER",         "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "ALTER",       
  "TO",            "ADD",           "COLUMNKW",      "error",       
  "input",         "cmdlist",       "ecmd",          "explain",     
  "cmdx",          "cmd",           "transtype",     "trans_opt",   
  "nm",            "create_table",  "create_table_args",  "temp",        
  "ifnotexists",   "dbnm",          "columnlist",    "conslist_opt",
  "select",        "column",        "columnid",      "type",        
  "carglist",      "id",            "ids",           "typetoken",   
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "expr",        
  "onconf",        "sortorder",     "autoinc",       "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "ifexists",      "fullname",      "oneselect",     "multiselect_op",
  "distinct",      "selcollist",    "from",          "where_opt",   
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sclp",          "as",            "seltablist",    "stl_prefix",  
  "joinop",        "indexed_opt",   "on_opt",        "using_opt",   
  "seltablist_paren",  "joinop2",       "inscollist",    "sortlist",    
  "sortitem",      "nexprlist",     "setlist",       "insert_cmd",  
  "inscollist_opt",  "itemlist",      "exprlist",      "likeop",      
  "escape",        "between_op",    "in_op",         "case_operand",
  "case_exprlist",  "case_else",     "uniqueflag",    "collate",     
  "nmnum",         "plus_opt",      "number",        "trigger_decl",
  "trigger_cmd_list",  "trigger_time",  "trigger_event",  "foreach_clause",
  "when_clause",   "trigger_cmd",   "database_kw_opt",  "key_opt",     
  "add_column_fullname",  "kwcolumn_opt",  "create_vtab",   "vtabarglist", 
  "vtabarg",       "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   8 */ "cmdx ::= cmd",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "ccons ::= DEFAULT term",
 /*  51 */ "ccons ::= DEFAULT LP expr RP",
 /*  52 */ "ccons ::= DEFAULT PLUS term",
 /*  53 */ "ccons ::= DEFAULT MINUS term",
 /*  54 */ "ccons ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE ids",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as indexed_opt on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "indexed_opt ::=",
 /* 140 */ "indexed_opt ::= INDEXED BY nm",
 /* 141 */ "indexed_opt ::= NOT INDEXED",
 /* 142 */ "using_opt ::= USING LP inscollist RP",
 /* 143 */ "using_opt ::=",
 /* 144 */ "orderby_opt ::=",
 /* 145 */ "orderby_opt ::= ORDER BY sortlist",
 /* 146 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 147 */ "sortlist ::= sortitem sortorder",
 /* 148 */ "sortitem ::= expr",
 /* 149 */ "sortorder ::= ASC",
 /* 150 */ "sortorder ::= DESC",
 /* 151 */ "sortorder ::=",
 /* 152 */ "groupby_opt ::=",
 /* 153 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 154 */ "having_opt ::=",
 /* 155 */ "having_opt ::= HAVING expr",
 /* 156 */ "limit_opt ::=",
 /* 157 */ "limit_opt ::= LIMIT expr",
 /* 158 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 159 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 160 */ "cmd ::= DELETE FROM fullname indexed_opt where_opt",
 /* 161 */ "where_opt ::=",
 /* 162 */ "where_opt ::= WHERE expr",
 /* 163 */ "cmd ::= UPDATE orconf fullname indexed_opt SET setlist where_opt",
 /* 164 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 165 */ "setlist ::= nm EQ expr",
 /* 166 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 167 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 168 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 169 */ "insert_cmd ::= INSERT orconf",
 /* 170 */ "insert_cmd ::= REPLACE",
 /* 171 */ "itemlist ::= itemlist COMMA expr",
 /* 172 */ "itemlist ::= expr",
 /* 173 */ "inscollist_opt ::=",
 /* 174 */ "inscollist_opt ::= LP inscollist RP",
 /* 175 */ "inscollist ::= inscollist COMMA nm",
 /* 176 */ "inscollist ::= nm",
 /* 177 */ "expr ::= term",
 /* 178 */ "expr ::= LP expr RP",
 /* 179 */ "term ::= NULL",
 /* 180 */ "expr ::= ID",
 /* 181 */ "expr ::= JOIN_KW",
 /* 182 */ "expr ::= nm DOT nm",
 /* 183 */ "expr ::= nm DOT nm DOT nm",
 /* 184 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 185 */ "term ::= STRING",
 /* 186 */ "expr ::= REGISTER",
 /* 187 */ "expr ::= VARIABLE",
 /* 188 */ "expr ::= expr COLLATE ids",
 /* 189 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 190 */ "expr ::= ID LP distinct exprlist RP",
 /* 191 */ "expr ::= ID LP STAR RP",
 /* 192 */ "term ::= CTIME_KW",
 /* 193 */ "expr ::= expr AND expr",
 /* 194 */ "expr ::= expr OR expr",
 /* 195 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 196 */ "expr ::= expr EQ|NE expr",
 /* 197 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 198 */ "expr ::= expr PLUS|MINUS expr",
 /* 199 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 200 */ "expr ::= expr CONCAT expr",
 /* 201 */ "likeop ::= LIKE_KW",
 /* 202 */ "likeop ::= NOT LIKE_KW",
 /* 203 */ "likeop ::= MATCH",
 /* 204 */ "likeop ::= NOT MATCH",
 /* 205 */ "escape ::= ESCAPE expr",
 /* 206 */ "escape ::=",
 /* 207 */ "expr ::= expr likeop expr escape",
 /* 208 */ "expr ::= expr ISNULL|NOTNULL",
 /* 209 */ "expr ::= expr IS NULL",
 /* 210 */ "expr ::= expr NOT NULL",
 /* 211 */ "expr ::= expr IS NOT NULL",
 /* 212 */ "expr ::= NOT expr",
 /* 213 */ "expr ::= BITNOT expr",
 /* 214 */ "expr ::= MINUS expr",
 /* 215 */ "expr ::= PLUS expr",
 /* 216 */ "between_op ::= BETWEEN",
 /* 217 */ "between_op ::= NOT BETWEEN",
 /* 218 */ "expr ::= expr between_op expr AND expr",
 /* 219 */ "in_op ::= IN",
 /* 220 */ "in_op ::= NOT IN",
 /* 221 */ "expr ::= expr in_op LP exprlist RP",
 /* 222 */ "expr ::= LP select RP",
 /* 223 */ "expr ::= expr in_op LP select RP",
 /* 224 */ "expr ::= expr in_op nm dbnm",
 /* 225 */ "expr ::= EXISTS LP select RP",
 /* 226 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 227 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 228 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 229 */ "case_else ::= ELSE expr",
 /* 230 */ "case_else ::=",
 /* 231 */ "case_operand ::= expr",
 /* 232 */ "case_operand ::=",
 /* 233 */ "exprlist ::= nexprlist",
 /* 234 */ "exprlist ::=",
 /* 235 */ "nexprlist ::= nexprlist COMMA expr",
 /* 236 */ "nexprlist ::= expr",
 /* 237 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 238 */ "uniqueflag ::= UNIQUE",
 /* 239 */ "uniqueflag ::=",
 /* 240 */ "idxlist_opt ::=",
 /* 241 */ "idxlist_opt ::= LP idxlist RP",
 /* 242 */ "idxlist ::= idxlist COMMA nm collate sortorder",
 /* 243 */ "idxlist ::= nm collate sortorder",
 /* 244 */ "collate ::=",
 /* 245 */ "collate ::= COLLATE ids",
 /* 246 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 247 */ "cmd ::= VACUUM",
 /* 248 */ "cmd ::= VACUUM nm",
 /* 249 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 250 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 251 */ "cmd ::= PRAGMA nm dbnm EQ DELETE",
 /* 252 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 253 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 254 */ "cmd ::= PRAGMA nm dbnm",
 /* 255 */ "nmnum ::= plus_num",
 /* 256 */ "nmnum ::= nm",
 /* 257 */ "plus_num ::= plus_opt number",
 /* 258 */ "minus_num ::= MINUS number",
 /* 259 */ "number ::= INTEGER|FLOAT",
 /* 260 */ "plus_opt ::= PLUS",
 /* 261 */ "plus_opt ::=",
 /* 262 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 263 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 264 */ "trigger_time ::= BEFORE",
 /* 265 */ "trigger_time ::= AFTER",
 /* 266 */ "trigger_time ::= INSTEAD OF",
 /* 267 */ "trigger_time ::=",
 /* 268 */ "trigger_event ::= DELETE|INSERT",
 /* 269 */ "trigger_event ::= UPDATE",
 /* 270 */ "trigger_event ::= UPDATE OF inscollist",
 /* 271 */ "foreach_clause ::=",
 /* 272 */ "foreach_clause ::= FOR EACH ROW",
 /* 273 */ "when_clause ::=",
 /* 274 */ "when_clause ::= WHEN expr",
 /* 275 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 276 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 277 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 278 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 279 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 280 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 281 */ "trigger_cmd ::= select",
 /* 282 */ "expr ::= RAISE LP IGNORE RP",
 /* 283 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 284 */ "raisetype ::= ROLLBACK",
 /* 285 */ "raisetype ::= ABORT",
 /* 286 */ "raisetype ::= FAIL",
 /* 287 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 288 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 289 */ "cmd ::= DETACH database_kw_opt expr",
 /* 290 */ "key_opt ::=",
 /* 291 */ "key_opt ::= KEY expr",
 /* 292 */ "database_kw_opt ::= DATABASE",
 /* 293 */ "database_kw_opt ::=",
 /* 294 */ "cmd ::= REINDEX",
 /* 295 */ "cmd ::= REINDEX nm dbnm",
 /* 296 */ "cmd ::= ANALYZE",
 /* 297 */ "cmd ::= ANALYZE nm dbnm",
 /* 298 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 299 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 300 */ "add_column_fullname ::= fullname",
 /* 301 */ "kwcolumn_opt ::=",
 /* 302 */ "kwcolumn_opt ::= COLUMNKW",
 /* 303 */ "cmd ::= create_vtab",
 /* 304 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 305 */ "create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm",
 /* 306 */ "vtabarglist ::= vtabarg",
 /* 307 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 308 */ "vtabarg ::=",
 /* 309 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 310 */ "vtabargtoken ::= ANY",
 /* 311 */ "vtabargtoken ::= lp anylist RP",
 /* 312 */ "lp ::= LP",
 /* 313 */ "anylist ::=",
 /* 314 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3ParserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 156: /* select */
    case 190: /* oneselect */
    case 208: /* seltablist_paren */
{
#line 369 "parse.y"
sqlite3SelectDelete(pParse->db, (yypminor->yy43));
#line 1300 "parse.c"
}
      break;
    case 170: /* term */
    case 171: /* expr */
    case 195: /* where_opt */
    case 197: /* having_opt */
    case 206: /* on_opt */
    case 212: /* sortitem */
    case 220: /* escape */
    case 223: /* case_operand */
    case 225: /* case_else */
    case 236: /* when_clause */
    case 239: /* key_opt */
{
#line 669 "parse.y"
sqlite3ExprDelete(pParse->db, (yypminor->yy450));
#line 1317 "parse.c"
}
      break;
    case 175: /* idxlist_opt */
    case 183: /* idxlist */
    case 193: /* selcollist */
    case 196: /* groupby_opt */
    case 198: /* orderby_opt */
    case 200: /* sclp */
    case 211: /* sortlist */
    case 213: /* nexprlist */
    case 214: /* setlist */
    case 217: /* itemlist */
    case 218: /* exprlist */
    case 224: /* case_exprlist */
{
#line 927 "parse.y"
sqlite3ExprListDelete(pParse->db, (yypminor->yy242));
#line 1335 "parse.c"
}
      break;
    case 189: /* fullname */
    case 194: /* from */
    case 202: /* seltablist */
    case 203: /* stl_prefix */
{
#line 487 "parse.y"
sqlite3SrcListDelete(pParse->db, (yypminor->yy419));
#line 1345 "parse.c"
}
      break;
    case 207: /* using_opt */
    case 210: /* inscollist */
    case 216: /* inscollist_opt */
{
#line 519 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy352));
#line 1354 "parse.c"
}
      break;
    case 232: /* trigger_cmd_list */
    case 237: /* trigger_cmd */
{
#line 1031 "parse.y"
sqlite3DeleteTriggerStep(pParse->db, (yypminor->yy75));
#line 1362 "parse.c"
}
      break;
    case 234: /* trigger_event */
{
#line 1017 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy354).b);
#line 1369 "parse.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3ParserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_MAX ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_MAX );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_SZ_ACTTAB );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3ParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 39 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1547 "parse.c"
   sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 140, 1 },
  { 141, 2 },
  { 141, 1 },
  { 142, 1 },
  { 142, 3 },
  { 143, 0 },
  { 143, 1 },
  { 143, 3 },
  { 144, 1 },
  { 145, 3 },
  { 147, 0 },
  { 147, 1 },
  { 147, 2 },
  { 146, 0 },
  { 146, 1 },
  { 146, 1 },
  { 146, 1 },
  { 145, 2 },
  { 145, 2 },
  { 145, 2 },
  { 145, 2 },
  { 149, 6 },
  { 152, 0 },
  { 152, 3 },
  { 151, 1 },
  { 151, 0 },
  { 150, 4 },
  { 150, 2 },
  { 154, 3 },
  { 154, 1 },
  { 157, 3 },
  { 158, 1 },
  { 161, 1 },
  { 162, 1 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 159, 0 },
  { 159, 1 },
  { 163, 1 },
  { 163, 4 },
  { 163, 6 },
  { 164, 1 },
  { 164, 2 },
  { 165, 1 },
  { 165, 1 },
  { 160, 2 },
  { 160, 0 },
  { 168, 3 },
  { 168, 1 },
  { 169, 2 },
  { 169, 4 },
  { 169, 3 },
  { 169, 3 },
  { 169, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 4 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 174, 0 },
  { 174, 1 },
  { 176, 0 },
  { 176, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 179, 2 },
  { 179, 2 },
  { 179, 1 },
  { 179, 1 },
  { 177, 3 },
  { 177, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 2 },
  { 155, 0 },
  { 155, 2 },
  { 181, 3 },
  { 181, 2 },
  { 181, 1 },
  { 182, 2 },
  { 182, 7 },
  { 182, 5 },
  { 182, 5 },
  { 182, 10 },
  { 184, 0 },
  { 184, 1 },
  { 172, 0 },
  { 172, 3 },
  { 185, 0 },
  { 185, 2 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 145, 4 },
  { 188, 2 },
  { 188, 0 },
  { 145, 8 },
  { 145, 4 },
  { 145, 1 },
  { 156, 1 },
  { 156, 3 },
  { 191, 1 },
  { 191, 2 },
  { 191, 1 },
  { 190, 9 },
  { 192, 1 },
  { 192, 1 },
  { 192, 0 },
  { 200, 2 },
  { 200, 0 },
  { 193, 3 },
  { 193, 2 },
  { 193, 4 },
  { 201, 2 },
  { 201, 1 },
  { 201, 0 },
  { 194, 0 },
  { 194, 2 },
  { 203, 2 },
  { 203, 0 },
  { 202, 7 },
  { 202, 7 },
  { 208, 1 },
  { 208, 1 },
  { 153, 0 },
  { 153, 2 },
  { 189, 2 },
  { 204, 1 },
  { 204, 2 },
  { 204, 3 },
  { 204, 4 },
  { 206, 2 },
  { 206, 0 },
  { 205, 0 },
  { 205, 3 },
  { 205, 2 },
  { 207, 4 },
  { 207, 0 },
  { 198, 0 },
  { 198, 3 },
  { 211, 4 },
  { 211, 2 },
  { 212, 1 },
  { 173, 1 },
  { 173, 1 },
  { 173, 0 },
  { 196, 0 },
  { 196, 3 },
  { 197, 0 },
  { 197, 2 },
  { 199, 0 },
  { 199, 2 },
  { 199, 4 },
  { 199, 4 },
  { 145, 5 },
  { 195, 0 },
  { 195, 2 },
  { 145, 7 },
  { 214, 5 },
  { 214, 3 },
  { 145, 8 },
  { 145, 5 },
  { 145, 6 },
  { 215, 2 },
  { 215, 1 },
  { 217, 3 },
  { 217, 1 },
  { 216, 0 },
  { 216, 3 },
  { 210, 3 },
  { 210, 1 },
  { 171, 1 },
  { 171, 3 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 5 },
  { 170, 1 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 6 },
  { 171, 5 },
  { 171, 4 },
  { 170, 1 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 219, 1 },
  { 219, 2 },
  { 219, 1 },
  { 219, 2 },
  { 220, 2 },
  { 220, 0 },
  { 171, 4 },
  { 171, 2 },
  { 171, 3 },
  { 171, 3 },
  { 171, 4 },
  { 171, 2 },
  { 171, 2 },
  { 171, 2 },
  { 171, 2 },
  { 221, 1 },
  { 221, 2 },
  { 171, 5 },
  { 222, 1 },
  { 222, 2 },
  { 171, 5 },
  { 171, 3 },
  { 171, 5 },
  { 171, 4 },
  { 171, 4 },
  { 171, 5 },
  { 224, 5 },
  { 224, 4 },
  { 225, 2 },
  { 225, 0 },
  { 223, 1 },
  { 223, 0 },
  { 218, 1 },
  { 218, 0 },
  { 213, 3 },
  { 213, 1 },
  { 145, 11 },
  { 226, 1 },
  { 226, 0 },
  { 175, 0 },
  { 175, 3 },
  { 183, 5 },
  { 183, 3 },
  { 227, 0 },
  { 227, 2 },
  { 145, 4 },
  { 145, 1 },
  { 145, 2 },
  { 145, 5 },
  { 145, 5 },
  { 145, 5 },
  { 145, 5 },
  { 145, 6 },
  { 145, 3 },
  { 228, 1 },
  { 228, 1 },
  { 166, 2 },
  { 167, 2 },
  { 230, 1 },
  { 229, 1 },
  { 229, 0 },
  { 145, 5 },
  { 231, 11 },
  { 233, 1 },
  { 233, 1 },
  { 233, 2 },
  { 233, 0 },
  { 234, 1 },
  { 234, 1 },
  { 234, 3 },
  { 235, 0 },
  { 235, 3 },
  { 236, 0 },
  { 236, 2 },
  { 232, 3 },
  { 232, 2 },
  { 237, 6 },
  { 237, 8 },
  { 237, 5 },
  { 237, 4 },
  { 237, 1 },
  { 171, 4 },
  { 171, 6 },
  { 187, 1 },
  { 187, 1 },
  { 187, 1 },
  { 145, 4 },
  { 145, 6 },
  { 145, 3 },
  { 239, 0 },
  { 239, 2 },
  { 238, 1 },
  { 238, 0 },
  { 145, 1 },
  { 145, 3 },
  { 145, 1 },
  { 145, 3 },
  { 145, 6 },
  { 145, 6 },
  { 240, 1 },
  { 241, 0 },
  { 241, 1 },
  { 145, 1 },
  { 145, 4 },
  { 242, 7 },
  { 243, 1 },
  { 243, 3 },
  { 244, 0 },
  { 244, 2 },
  { 245, 1 },
  { 245, 3 },
  { 246, 1 },
  { 247, 0 },
  { 247, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* input ::= cmdlist */
      case 1: /* cmdlist ::= cmdlist ecmd */
      case 2: /* cmdlist ::= ecmd */
      case 3: /* ecmd ::= SEMI */
      case 4: /* ecmd ::= explain cmdx SEMI */
      case 10: /* trans_opt ::= */
      case 11: /* trans_opt ::= TRANSACTION */
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 20: /* cmd ::= create_table create_table_args */
      case 28: /* columnlist ::= columnlist COMMA column */
      case 29: /* columnlist ::= column */
      case 37: /* type ::= */
      case 44: /* signed ::= plus_num */
      case 45: /* signed ::= minus_num */
      case 46: /* carglist ::= carglist carg */
      case 47: /* carglist ::= */
      case 48: /* carg ::= CONSTRAINT nm ccons */
      case 49: /* carg ::= ccons */
      case 55: /* ccons ::= NULL onconf */
      case 82: /* conslist ::= conslist COMMA tcons */
      case 83: /* conslist ::= conslist tcons */
      case 84: /* conslist ::= tcons */
      case 85: /* tcons ::= CONSTRAINT nm */
      case 260: /* plus_opt ::= PLUS */
      case 261: /* plus_opt ::= */
      case 271: /* foreach_clause ::= */
      case 272: /* foreach_clause ::= FOR EACH ROW */
      case 292: /* database_kw_opt ::= DATABASE */
      case 293: /* database_kw_opt ::= */
      case 301: /* kwcolumn_opt ::= */
      case 302: /* kwcolumn_opt ::= COLUMNKW */
      case 306: /* vtabarglist ::= vtabarg */
      case 307: /* vtabarglist ::= vtabarglist COMMA vtabarg */
      case 309: /* vtabarg ::= vtabarg vtabargtoken */
      case 313: /* anylist ::= */
#line 91 "parse.y"
{
}
#line 2011 "parse.c"
        break;
      case 5: /* explain ::= */
#line 96 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 2016 "parse.c"
        break;
      case 6: /* explain ::= EXPLAIN */
#line 98 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 2021 "parse.c"
        break;
      case 7: /* explain ::= EXPLAIN QUERY PLAN */
#line 99 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 2026 "parse.c"
        break;
      case 8: /* cmdx ::= cmd */
#line 101 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 2031 "parse.c"
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
#line 106 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy316);}
#line 2036 "parse.c"
        break;
      case 13: /* transtype ::= */
#line 111 "parse.y"
{yygotominor.yy316 = TK_DEFERRED;}
#line 2041 "parse.c"
        break;
      case 14: /* transtype ::= DEFERRED */
      case 15: /* transtype ::= IMMEDIATE */
      case 16: /* transtype ::= EXCLUSIVE */
      case 107: /* multiselect_op ::= UNION */
      case 109: /* multiselect_op ::= EXCEPT|INTERSECT */
#line 112 "parse.y"
{yygotominor.yy316 = yymsp[0].major;}
#line 2050 "parse.c"
        break;
      case 17: /* cmd ::= COMMIT trans_opt */
      case 18: /* cmd ::= END trans_opt */
#line 115 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 2056 "parse.c"
        break;
      case 19: /* cmd ::= ROLLBACK trans_opt */
#line 117 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 2061 "parse.c"
        break;
      case 21: /* create_table ::= CREATE temp TABLE ifnotexists nm dbnm */
#line 122 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,yymsp[-4].minor.yy316,0,0,yymsp[-2].minor.yy316);
}
#line 2068 "parse.c"
        break;
      case 22: /* ifnotexists ::= */
      case 25: /* temp ::= */
      case 63: /* autoinc ::= */
      case 77: /* init_deferred_pred_opt ::= */
      case 79: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
      case 90: /* defer_subclause_opt ::= */
      case 101: /* ifexists ::= */
      case 112: /* distinct ::= ALL */
      case 113: /* distinct ::= */
      case 216: /* between_op ::= BETWEEN */
      case 219: /* in_op ::= IN */
#line 126 "parse.y"
{yygotominor.yy316 = 0;}
#line 2083 "parse.c"
        break;
      case 23: /* ifnotexists ::= IF NOT EXISTS */
      case 24: /* temp ::= TEMP */
      case 64: /* autoinc ::= AUTOINCR */
      case 78: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
      case 100: /* ifexists ::= IF EXISTS */
      case 111: /* distinct ::= DISTINCT */
      case 217: /* between_op ::= NOT BETWEEN */
      case 220: /* in_op ::= NOT IN */
#line 127 "parse.y"
{yygotominor.yy316 = 1;}
#line 2095 "parse.c"
        break;
      case 26: /* create_table_args ::= LP columnlist conslist_opt RP */
#line 133 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0);
}
#line 2102 "parse.c"
        break;
      case 27: /* create_table_args ::= AS select */
#line 136 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy43);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy43);
}
#line 2110 "parse.c"
        break;
      case 30: /* column ::= columnid type carglist */
#line 148 "parse.y"
{
  yygotominor.yy0.z = yymsp[-2].minor.yy0.z;
  yygotominor.yy0.n = (pParse->sLastToken.z-yymsp[-2].minor.yy0.z) + pParse->sLastToken.n;
}
#line 2118 "parse.c"
        break;
      case 31: /* columnid ::= nm */
#line 152 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy0);
  yygotominor.yy0 = yymsp[0].minor.yy0;
}
#line 2126 "parse.c"
        break;
      case 32: /* id ::= ID */
      case 33: /* ids ::= ID|STRING */
      case 34: /* nm ::= ID */
      case 35: /* nm ::= STRING */
      case 36: /* nm ::= JOIN_KW */
      case 39: /* typetoken ::= typename */
      case 42: /* typename ::= ids */
      case 119: /* as ::= AS nm */
      case 120: /* as ::= ids */
      case 131: /* dbnm ::= DOT nm */
      case 140: /* indexed_opt ::= INDEXED BY nm */
      case 245: /* collate ::= COLLATE ids */
      case 255: /* nmnum ::= plus_num */
      case 256: /* nmnum ::= nm */
      case 257: /* plus_num ::= plus_opt number */
      case 258: /* minus_num ::= MINUS number */
      case 259: /* number ::= INTEGER|FLOAT */
#line 162 "parse.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;}
#line 2147 "parse.c"
        break;
      case 38: /* type ::= typetoken */
#line 223 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy0);}
#line 2152 "parse.c"
        break;
      case 40: /* typetoken ::= typename LP signed RP */
#line 225 "parse.y"
{
  yygotominor.yy0.z = yymsp[-3].minor.yy0.z;
  yygotominor.yy0.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy0.z;
}
#line 2160 "parse.c"
        break;
      case 41: /* typetoken ::= typename LP signed COMMA signed RP */
#line 229 "parse.y"
{
  yygotominor.yy0.z = yymsp[-5].minor.yy0.z;
  yygotominor.yy0.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy0.z;
}
#line 2168 "parse.c"
        break;
      case 43: /* typename ::= typename ids */
#line 235 "parse.y"
{yygotominor.yy0.z=yymsp[-1].minor.yy0.z; yygotominor.yy0.n=yymsp[0].minor.yy0.n+(yymsp[0].minor.yy0.z-yymsp[-1].minor.yy0.z);}
#line 2173 "parse.c"
        break;
      case 50: /* ccons ::= DEFAULT term */
      case 52: /* ccons ::= DEFAULT PLUS term */
#line 246 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy450);}
#line 2179 "parse.c"
        break;
      case 51: /* ccons ::= DEFAULT LP expr RP */
#line 247 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy450);}
#line 2184 "parse.c"
        break;
      case 53: /* ccons ::= DEFAULT MINUS term */
#line 249 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy450, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2192 "parse.c"
        break;
      case 54: /* ccons ::= DEFAULT id */
#line 253 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_STRING, 0, 0, &yymsp[0].minor.yy0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2200 "parse.c"
        break;
      case 56: /* ccons ::= NOT NULL onconf */
#line 262 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy316);}
#line 2205 "parse.c"
        break;
      case 57: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
#line 264 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy316,yymsp[0].minor.yy316,yymsp[-2].minor.yy316);}
#line 2210 "parse.c"
        break;
      case 58: /* ccons ::= UNIQUE onconf */
#line 265 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy316,0,0,0,0);}
#line 2215 "parse.c"
        break;
      case 59: /* ccons ::= CHECK LP expr RP */
#line 266 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy450);}
#line 2220 "parse.c"
        break;
      case 60: /* ccons ::= REFERENCES nm idxlist_opt refargs */
#line 268 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy0,yymsp[-1].minor.yy242,yymsp[0].minor.yy316);}
#line 2225 "parse.c"
        break;
      case 61: /* ccons ::= defer_subclause */
#line 269 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy316);}
#line 2230 "parse.c"
        break;
      case 62: /* ccons ::= COLLATE ids */
#line 270 "parse.y"
{sqlite3AddCollateType(pParse, &yymsp[0].minor.yy0);}
#line 2235 "parse.c"
        break;
      case 65: /* refargs ::= */
#line 283 "parse.y"
{ yygotominor.yy316 = OE_Restrict * 0x010101; }
#line 2240 "parse.c"
        break;
      case 66: /* refargs ::= refargs refarg */
#line 284 "parse.y"
{ yygotominor.yy316 = (yymsp[-1].minor.yy316 & ~yymsp[0].minor.yy207.mask) | yymsp[0].minor.yy207.value; }
#line 2245 "parse.c"
        break;
      case 67: /* refarg ::= MATCH nm */
#line 286 "parse.y"
{ yygotominor.yy207.value = 0;     yygotominor.yy207.mask = 0x000000; }
#line 2250 "parse.c"
        break;
      case 68: /* refarg ::= ON DELETE refact */
#line 287 "parse.y"
{ yygotominor.yy207.value = yymsp[0].minor.yy316;     yygotominor.yy207.mask = 0x0000ff; }
#line 2255 "parse.c"
        break;
      case 69: /* refarg ::= ON UPDATE refact */
#line 288 "parse.y"
{ yygotominor.yy207.value = yymsp[0].minor.yy316<<8;  yygotominor.yy207.mask = 0x00ff00; }
#line 2260 "parse.c"
        break;
      case 70: /* refarg ::= ON INSERT refact */
#line 289 "parse.y"
{ yygotominor.yy207.value = yymsp[0].minor.yy316<<16; yygotominor.yy207.mask = 0xff0000; }
#line 2265 "parse.c"
        break;
      case 71: /* refact ::= SET NULL */
#line 291 "parse.y"
{ yygotominor.yy316 = OE_SetNull; }
#line 2270 "parse.c"
        break;
      case 72: /* refact ::= SET DEFAULT */
#line 292 "parse.y"
{ yygotominor.yy316 = OE_SetDflt; }
#line 2275 "parse.c"
        break;
      case 73: /* refact ::= CASCADE */
#line 293 "parse.y"
{ yygotominor.yy316 = OE_Cascade; }
#line 2280 "parse.c"
        break;
      case 74: /* refact ::= RESTRICT */
#line 294 "parse.y"
{ yygotominor.yy316 = OE_Restrict; }
#line 2285 "parse.c"
        break;
      case 75: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
      case 76: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
      case 91: /* defer_subclause_opt ::= defer_subclause */
      case 93: /* onconf ::= ON CONFLICT resolvetype */
      case 95: /* orconf ::= OR resolvetype */
      case 96: /* resolvetype ::= raisetype */
      case 169: /* insert_cmd ::= INSERT orconf */
#line 296 "parse.y"
{yygotominor.yy316 = yymsp[0].minor.yy316;}
#line 2296 "parse.c"
        break;
      case 80: /* conslist_opt ::= */
#line 306 "parse.y"
{yygotominor.yy0.n = 0; yygotominor.yy0.z = 0;}
#line 2301 "parse.c"
        break;
      case 81: /* conslist_opt ::= COMMA conslist */
#line 307 "parse.y"
{yygotominor.yy0 = yymsp[-1].minor.yy0;}
#line 2306 "parse.c"
        break;
      case 86: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
#line 313 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy242,yymsp[0].minor.yy316,yymsp[-2].minor.yy316,0);}
#line 2311 "parse.c"
        break;
      case 87: /* tcons ::= UNIQUE LP idxlist RP onconf */
#line 315 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy242,yymsp[0].minor.yy316,0,0,0,0);}
#line 2316 "parse.c"
        break;
      case 88: /* tcons ::= CHECK LP expr RP onconf */
#line 316 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy450);}
#line 2321 "parse.c"
        break;
      case 89: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
#line 318 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy242, &yymsp[-3].minor.yy0, yymsp[-2].minor.yy242, yymsp[-1].minor.yy316);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy316);
}
#line 2329 "parse.c"
        break;
      case 92: /* onconf ::= */
      case 94: /* orconf ::= */
#line 332 "parse.y"
{yygotominor.yy316 = OE_Default;}
#line 2335 "parse.c"
        break;
      case 97: /* resolvetype ::= IGNORE */
#line 337 "parse.y"
{yygotominor.yy316 = OE_Ignore;}
#line 2340 "parse.c"
        break;
      case 98: /* resolvetype ::= REPLACE */
      case 170: /* insert_cmd ::= REPLACE */
#line 338 "parse.y"
{yygotominor.yy316 = OE_Replace;}
#line 2346 "parse.c"
        break;
      case 99: /* cmd ::= DROP TABLE ifexists fullname */
#line 342 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy419, 0, yymsp[-1].minor.yy316);
}
#line 2353 "parse.c"
        break;
      case 102: /* cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select */
#line 352 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy0, &yymsp[-2].minor.yy0, yymsp[0].minor.yy43, yymsp[-6].minor.yy316, yymsp[-4].minor.yy316);
}
#line 2360 "parse.c"
        break;
      case 103: /* cmd ::= DROP VIEW ifexists fullname */
#line 355 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy419, 1, yymsp[-1].minor.yy316);
}
#line 2367 "parse.c"
        break;
      case 104: /* cmd ::= select */
#line 362 "parse.y"
{
  SelectDest dest = {SRT_Output, 0, 0, 0, 0};
  sqlite3Select(pParse, yymsp[0].minor.yy43, &dest);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy43);
}
#line 2376 "parse.c"
        break;
      case 105: /* select ::= oneselect */
      case 128: /* seltablist_paren ::= select */
#line 373 "parse.y"
{yygotominor.yy43 = yymsp[0].minor.yy43;}
#line 2382 "parse.c"
        break;
      case 106: /* select ::= select multiselect_op oneselect */
#line 375 "parse.y"
{
  if( yymsp[0].minor.yy43 ){
    yymsp[0].minor.yy43->op = yymsp[-1].minor.yy316;
    yymsp[0].minor.yy43->pPrior = yymsp[-2].minor.yy43;
  }else{
    sqlite3SelectDelete(pParse->db, yymsp[-2].minor.yy43);
  }
  yygotominor.yy43 = yymsp[0].minor.yy43;
}
#line 2395 "parse.c"
        break;
      case 108: /* multiselect_op ::= UNION ALL */
#line 386 "parse.y"
{yygotominor.yy316 = TK_ALL;}
#line 2400 "parse.c"
        break;
      case 110: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 390 "parse.y"
{
  yygotominor.yy43 = sqlite3SelectNew(pParse,yymsp[-6].minor.yy242,yymsp[-5].minor.yy419,yymsp[-4].minor.yy450,yymsp[-3].minor.yy242,yymsp[-2].minor.yy450,yymsp[-1].minor.yy242,yymsp[-7].minor.yy316,yymsp[0].minor.yy84.pLimit,yymsp[0].minor.yy84.pOffset);
}
#line 2407 "parse.c"
        break;
      case 114: /* sclp ::= selcollist COMMA */
      case 241: /* idxlist_opt ::= LP idxlist RP */
#line 411 "parse.y"
{yygotominor.yy242 = yymsp[-1].minor.yy242;}
#line 2413 "parse.c"
        break;
      case 115: /* sclp ::= */
      case 144: /* orderby_opt ::= */
      case 152: /* groupby_opt ::= */
      case 234: /* exprlist ::= */
      case 240: /* idxlist_opt ::= */
#line 412 "parse.y"
{yygotominor.yy242 = 0;}
#line 2422 "parse.c"
        break;
      case 116: /* selcollist ::= sclp expr as */
#line 413 "parse.y"
{
   yygotominor.yy242 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy242,yymsp[-1].minor.yy450,yymsp[0].minor.yy0.n?&yymsp[0].minor.yy0:0);
}
#line 2429 "parse.c"
        break;
      case 117: /* selcollist ::= sclp STAR */
#line 416 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_ALL, 0, 0, 0);
  yygotominor.yy242 = sqlite3ExprListAppend(pParse, yymsp[-1].minor.yy242, p, 0);
}
#line 2437 "parse.c"
        break;
      case 118: /* selcollist ::= sclp nm DOT STAR */
#line 420 "parse.y"
{
  Expr *pRight = sqlite3PExpr(pParse, TK_ALL, 0, 0, &yymsp[0].minor.yy0);
  Expr *pLeft = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *pDot = sqlite3PExpr(pParse, TK_DOT, pLeft, pRight, 0);
  yygotominor.yy242 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy242, pDot, 0);
}
#line 2447 "parse.c"
        break;
      case 121: /* as ::= */
#line 433 "parse.y"
{yygotominor.yy0.n = 0;}
#line 2452 "parse.c"
        break;
      case 122: /* from ::= */
#line 445 "parse.y"
{yygotominor.yy419 = sqlite3DbMallocZero(pParse->db, sizeof(*yygotominor.yy419));}
#line 2457 "parse.c"
        break;
      case 123: /* from ::= FROM seltablist */
#line 446 "parse.y"
{
  yygotominor.yy419 = yymsp[0].minor.yy419;
  sqlite3SrcListShiftJoinType(yygotominor.yy419);
}
#line 2465 "parse.c"
        break;
      case 124: /* stl_prefix ::= seltablist joinop */
#line 454 "parse.y"
{
   yygotominor.yy419 = yymsp[-1].minor.yy419;
   if( yygotominor.yy419 && yygotominor.yy419->nSrc>0 ) yygotominor.yy419->a[yygotominor.yy419->nSrc-1].jointype = yymsp[0].minor.yy316;
}
#line 2473 "parse.c"
        break;
      case 125: /* stl_prefix ::= */
#line 458 "parse.y"
{yygotominor.yy419 = 0;}
#line 2478 "parse.c"
        break;
      case 126: /* seltablist ::= stl_prefix nm dbnm as indexed_opt on_opt using_opt */
#line 459 "parse.y"
{
  yygotominor.yy419 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy419,&yymsp[-5].minor.yy0,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,0,yymsp[-1].minor.yy450,yymsp[0].minor.yy352);
  sqlite3SrcListIndexedBy(pParse, yygotominor.yy419, &yymsp[-2].minor.yy0);
}
#line 2486 "parse.c"
        break;
      case 127: /* seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt */
#line 465 "parse.y"
{
    yygotominor.yy419 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy419,0,0,&yymsp[-2].minor.yy0,yymsp[-4].minor.yy43,yymsp[-1].minor.yy450,yymsp[0].minor.yy352);
  }
#line 2493 "parse.c"
        break;
      case 129: /* seltablist_paren ::= seltablist */
#line 476 "parse.y"
{
     sqlite3SrcListShiftJoinType(yymsp[0].minor.yy419);
     yygotominor.yy43 = sqlite3SelectNew(pParse,0,yymsp[0].minor.yy419,0,0,0,0,0,0,0);
  }
#line 2501 "parse.c"
        break;
      case 130: /* dbnm ::= */
      case 139: /* indexed_opt ::= */
#line 483 "parse.y"
{yygotominor.yy0.z=0; yygotominor.yy0.n=0;}
#line 2507 "parse.c"
        break;
      case 132: /* fullname ::= nm dbnm */
#line 488 "parse.y"
{yygotominor.yy419 = sqlite3SrcListAppend(pParse->db,0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);}
#line 2512 "parse.c"
        break;
      case 133: /* joinop ::= COMMA|JOIN */
#line 492 "parse.y"
{ yygotominor.yy316 = JT_INNER; }
#line 2517 "parse.c"
        break;
      case 134: /* joinop ::= JOIN_KW JOIN */
#line 493 "parse.y"
{ yygotominor.yy316 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2522 "parse.c"
        break;
      case 135: /* joinop ::= JOIN_KW nm JOIN */
#line 494 "parse.y"
{ yygotominor.yy316 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0,0); }
#line 2527 "parse.c"
        break;
      case 136: /* joinop ::= JOIN_KW nm nm JOIN */
#line 496 "parse.y"
{ yygotominor.yy316 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0); }
#line 2532 "parse.c"
        break;
      case 137: /* on_opt ::= ON expr */
      case 148: /* sortitem ::= expr */
      case 155: /* having_opt ::= HAVING expr */
      case 162: /* where_opt ::= WHERE expr */
      case 177: /* expr ::= term */
      case 205: /* escape ::= ESCAPE expr */
      case 229: /* case_else ::= ELSE expr */
      case 231: /* case_operand ::= expr */
#line 500 "parse.y"
{yygotominor.yy450 = yymsp[0].minor.yy450;}
#line 2544 "parse.c"
        break;
      case 138: /* on_opt ::= */
      case 154: /* having_opt ::= */
      case 161: /* where_opt ::= */
      case 206: /* escape ::= */
      case 230: /* case_else ::= */
      case 232: /* case_operand ::= */
#line 501 "parse.y"
{yygotominor.yy450 = 0;}
#line 2554 "parse.c"
        break;
      case 141: /* indexed_opt ::= NOT INDEXED */
#line 516 "parse.y"
{yygotominor.yy0.z=0; yygotominor.yy0.n=1;}
#line 2559 "parse.c"
        break;
      case 142: /* using_opt ::= USING LP inscollist RP */
      case 174: /* inscollist_opt ::= LP inscollist RP */
#line 520 "parse.y"
{yygotominor.yy352 = yymsp[-1].minor.yy352;}
#line 2565 "parse.c"
        break;
      case 143: /* using_opt ::= */
      case 173: /* inscollist_opt ::= */
#line 521 "parse.y"
{yygotominor.yy352 = 0;}
#line 2571 "parse.c"
        break;
      case 145: /* orderby_opt ::= ORDER BY sortlist */
      case 153: /* groupby_opt ::= GROUP BY nexprlist */
      case 233: /* exprlist ::= nexprlist */
#line 532 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 2578 "parse.c"
        break;
      case 146: /* sortlist ::= sortlist COMMA sortitem sortorder */
#line 533 "parse.y"
{
  yygotominor.yy242 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy242,yymsp[-1].minor.yy450,0);
  if( yygotominor.yy242 ) yygotominor.yy242->a[yygotominor.yy242->nExpr-1].sortOrder = yymsp[0].minor.yy316;
}
#line 2586 "parse.c"
        break;
      case 147: /* sortlist ::= sortitem sortorder */
#line 537 "parse.y"
{
  yygotominor.yy242 = sqlite3ExprListAppend(pParse,0,yymsp[-1].minor.yy450,0);
  if( yygotominor.yy242 && yygotominor.yy242->a ) yygotominor.yy242->a[0].sortOrder = yymsp[0].minor.yy316;
}
#line 2594 "parse.c"
        break;
      case 149: /* sortorder ::= ASC */
      case 151: /* sortorder ::= */
#line 545 "parse.y"
{yygotominor.yy316 = SQLITE_SO_ASC;}
#line 2600 "parse.c"
        break;
      case 150: /* sortorder ::= DESC */
#line 546 "parse.y"
{yygotominor.yy316 = SQLITE_SO_DESC;}
#line 2605 "parse.c"
        break;
      case 156: /* limit_opt ::= */
#line 572 "parse.y"
{yygotominor.yy84.pLimit = 0; yygotominor.yy84.pOffset = 0;}
#line 2610 "parse.c"
        break;
      case 157: /* limit_opt ::= LIMIT expr */
#line 573 "parse.y"
{yygotominor.yy84.pLimit = yymsp[0].minor.yy450; yygotominor.yy84.pOffset = 0;}
#line 2615 "parse.c"
        break;
      case 158: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 575 "parse.y"
{yygotominor.yy84.pLimit = yymsp[-2].minor.yy450; yygotominor.yy84.pOffset = yymsp[0].minor.yy450;}
#line 2620 "parse.c"
        break;
      case 159: /* limit_opt ::= LIMIT expr COMMA expr */
#line 577 "parse.y"
{yygotominor.yy84.pOffset = yymsp[-2].minor.yy450; yygotominor.yy84.pLimit = yymsp[0].minor.yy450;}
#line 2625 "parse.c"
        break;
      case 160: /* cmd ::= DELETE FROM fullname indexed_opt where_opt */
#line 590 "parse.y"
{
  sqlite3SrcListIndexedBy(pParse, yymsp[-2].minor.yy419, &yymsp[-1].minor.yy0);
  sqlite3DeleteFrom(pParse,yymsp[-2].minor.yy419,yymsp[0].minor.yy450);
}
#line 2633 "parse.c"
        break;
      case 163: /* cmd ::= UPDATE orconf fullname indexed_opt SET setlist where_opt */
#line 613 "parse.y"
{
  sqlite3SrcListIndexedBy(pParse, yymsp[-4].minor.yy419, &yymsp[-3].minor.yy0);
  sqlite3ExprListCheckLength(pParse,yymsp[-1].minor.yy242,"set list"); 
  sqlite3Update(pParse,yymsp[-4].minor.yy419,yymsp[-1].minor.yy242,yymsp[0].minor.yy450,yymsp[-5].minor.yy316);
}
#line 2642 "parse.c"
        break;
      case 164: /* setlist ::= setlist COMMA nm EQ expr */
#line 624 "parse.y"
{yygotominor.yy242 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy242,yymsp[0].minor.yy450,&yymsp[-2].minor.yy0);}
#line 2647 "parse.c"
        break;
      case 165: /* setlist ::= nm EQ expr */
#line 626 "parse.y"
{yygotominor.yy242 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy450,&yymsp[-2].minor.yy0);}
#line 2652 "parse.c"
        break;
      case 166: /* cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP */
#line 632 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy419, yymsp[-1].minor.yy242, 0, yymsp[-4].minor.yy352, yymsp[-7].minor.yy316);}
#line 2657 "parse.c"
        break;
      case 167: /* cmd ::= insert_cmd INTO fullname inscollist_opt select */
#line 634 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy419, 0, yymsp[0].minor.yy43, yymsp[-1].minor.yy352, yymsp[-4].minor.yy316);}
#line 2662 "parse.c"
        break;
      case 168: /* cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES */
#line 636 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy419, 0, 0, yymsp[-2].minor.yy352, yymsp[-5].minor.yy316);}
#line 2667 "parse.c"
        break;
      case 171: /* itemlist ::= itemlist COMMA expr */
      case 235: /* nexprlist ::= nexprlist COMMA expr */
#line 647 "parse.y"
{yygotominor.yy242 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy242,yymsp[0].minor.yy450,0);}
#line 2673 "parse.c"
        break;
      case 172: /* itemlist ::= expr */
      case 236: /* nexprlist ::= expr */
#line 649 "parse.y"
{yygotominor.yy242 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy450,0);}
#line 2679 "parse.c"
        break;
      case 175: /* inscollist ::= inscollist COMMA nm */
#line 659 "parse.y"
{yygotominor.yy352 = sqlite3IdListAppend(pParse->db,yymsp[-2].minor.yy352,&yymsp[0].minor.yy0);}
#line 2684 "parse.c"
        break;
      case 176: /* inscollist ::= nm */
#line 661 "parse.y"
{yygotominor.yy352 = sqlite3IdListAppend(pParse->db,0,&yymsp[0].minor.yy0);}
#line 2689 "parse.c"
        break;
      case 178: /* expr ::= LP expr RP */
#line 672 "parse.y"
{yygotominor.yy450 = yymsp[-1].minor.yy450; sqlite3ExprSpan(yygotominor.yy450,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2694 "parse.c"
        break;
      case 179: /* term ::= NULL */
      case 184: /* term ::= INTEGER|FLOAT|BLOB */
      case 185: /* term ::= STRING */
#line 673 "parse.y"
{yygotominor.yy450 = sqlite3PExpr(pParse, yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2701 "parse.c"
        break;
      case 180: /* expr ::= ID */
      case 181: /* expr ::= JOIN_KW */
#line 674 "parse.y"
{yygotominor.yy450 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2707 "parse.c"
        break;
      case 182: /* expr ::= nm DOT nm */
#line 676 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  yygotominor.yy450 = sqlite3PExpr(pParse, TK_DOT, temp1, temp2, 0);
}
#line 2716 "parse.c"
        break;
      case 183: /* expr ::= nm DOT nm DOT nm */
#line 681 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-4].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp3 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  Expr *temp4 = sqlite3PExpr(pParse, TK_DOT, temp2, temp3, 0);
  yygotominor.yy450 = sqlite3PExpr(pParse, TK_DOT, temp1, temp4, 0);
}
#line 2727 "parse.c"
        break;
      case 186: /* expr ::= REGISTER */
#line 690 "parse.y"
{yygotominor.yy450 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2732 "parse.c"
        break;
      case 187: /* expr ::= VARIABLE */
#line 691 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy450 = sqlite3PExpr(pParse, TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2741 "parse.c"
        break;
      case 188: /* expr ::= expr COLLATE ids */
#line 696 "parse.y"
{
  yygotominor.yy450 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy450, &yymsp[0].minor.yy0);
}
#line 2748 "parse.c"
        break;
      case 189: /* expr ::= CAST LP expr AS typetoken RP */
#line 700 "parse.y"
{
  yygotominor.yy450 = sqlite3PExpr(pParse, TK_CAST, yymsp[-3].minor.yy450, 0, &yymsp[-1].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2756 "parse.c"
        break;
      case 190: /* expr ::= ID LP distinct exprlist RP */
#line 705 "parse.y"
{
  if( yymsp[-1].minor.yy242 && yymsp[-1].minor.yy242->nExpr>SQLITE_MAX_FUNCTION_ARG ){
    sqlite3ErrorMsg(pParse, "too many arguments on function %T", &yymsp[-4].minor.yy0);
  }
  yygotominor.yy450 = sqlite3ExprFunction(pParse, yymsp[-1].minor.yy242, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy316 && yygotominor.yy450 ){
    yygotominor.yy450->flags |= EP_Distinct;
  }
}
#line 2770 "parse.c"
        break;
      case 191: /* expr ::= ID LP STAR RP */
#line 715 "parse.y"
{
  yygotominor.yy450 = sqlite3ExprFunction(pParse, 0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2778 "parse.c"
        break;
      case 192: /* term ::= CTIME_KW */
#line 719 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy450 = sqlite3ExprFunction(pParse, 0,&yymsp[0].minor.yy0);
  if( yygotominor.yy450 ){
    yygotominor.yy450->op = TK_CONST_FUNC;  
    yygotominor.yy450->span = yymsp[0].minor.yy0;
  }
}
#line 2791 "parse.c"
        break;
      case 193: /* expr ::= expr AND expr */
      case 194: /* expr ::= expr OR expr */
      case 195: /* expr ::= expr LT|GT|GE|LE expr */
      case 196: /* expr ::= expr EQ|NE expr */
      case 197: /* expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */
      case 198: /* expr ::= expr PLUS|MINUS expr */
      case 199: /* expr ::= expr STAR|SLASH|REM expr */
      case 200: /* expr ::= expr CONCAT expr */
#line 728 "parse.y"
{yygotominor.yy450 = sqlite3PExpr(pParse,yymsp[-1].major,yymsp[-2].minor.yy450,yymsp[0].minor.yy450,0);}
#line 2803 "parse.c"
        break;
      case 201: /* likeop ::= LIKE_KW */
      case 203: /* likeop ::= MATCH */
#line 740 "parse.y"
{yygotominor.yy86.eOperator = yymsp[0].minor.yy0; yygotominor.yy86.not = 0;}
#line 2809 "parse.c"
        break;
      case 202: /* likeop ::= NOT LIKE_KW */
      case 204: /* likeop ::= NOT MATCH */
#line 741 "parse.y"
{yygotominor.yy86.eOperator = yymsp[0].minor.yy0; yygotominor.yy86.not = 1;}
#line 2815 "parse.c"
        break;
      case 207: /* expr ::= expr likeop expr escape */
#line 748 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(pParse,0, yymsp[-1].minor.yy450, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[-3].minor.yy450, 0);
  if( yymsp[0].minor.yy450 ){
    pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy450, 0);
  }
  yygotominor.yy450 = sqlite3ExprFunction(pParse, pList, &yymsp[-2].minor.yy86.eOperator);
  if( yymsp[-2].minor.yy86.not ) yygotominor.yy450 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450, &yymsp[-3].minor.yy450->span, &yymsp[-1].minor.yy450->span);
  if( yygotominor.yy450 ) yygotominor.yy450->flags |= EP_InfixFunc;
}
#line 2831 "parse.c"
        break;
      case 208: /* expr ::= expr ISNULL|NOTNULL */
#line 761 "parse.y"
{
  yygotominor.yy450 = sqlite3PExpr(pParse, yymsp[0].major, yymsp[-1].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-1].minor.yy450->span,&yymsp[0].minor.yy0);
}
#line 2839 "parse.c"
        break;
      case 209: /* expr ::= expr IS NULL */
#line 765 "parse.y"
{
  yygotominor.yy450 = sqlite3PExpr(pParse, TK_ISNULL, yymsp[-2].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-2].minor.yy450->span,&yymsp[0].minor.yy0);
}
#line 2847 "parse.c"
        break;
      case 210: /* expr ::= expr NOT NULL */
#line 769 "parse.y"
{
  yygotominor.yy450 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-2].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-2].minor.yy450->span,&yymsp[0].minor.yy0);
}
#line 2855 "parse.c"
        break;
      case 211: /* expr ::= expr IS NOT NULL */
#line 773 "parse.y"
{
  yygotominor.yy450 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-3].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-3].minor.yy450->span,&yymsp[0].minor.yy0);
}
#line 2863 "parse.c"
        break;
      case 212: /* expr ::= NOT expr */
      case 213: /* expr ::= BITNOT expr */
#line 777 "parse.y"
{
  yygotominor.yy450 = sqlite3PExpr(pParse, yymsp[-1].major, yymsp[0].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy450->span);
}
#line 2872 "parse.c"
        break;
      case 214: /* expr ::= MINUS expr */
#line 785 "parse.y"
{
  yygotominor.yy450 = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy450->span);
}
#line 2880 "parse.c"
        break;
      case 215: /* expr ::= PLUS expr */
#line 789 "parse.y"
{
  yygotominor.yy450 = sqlite3PExpr(pParse, TK_UPLUS, yymsp[0].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy450->span);
}
#line 2888 "parse.c"
        break;
      case 218: /* expr ::= expr between_op expr AND expr */
#line 796 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy450, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy450, 0);
  yygotominor.yy450 = sqlite3PExpr(pParse, TK_BETWEEN, yymsp[-4].minor.yy450, 0, 0);
  if( yygotominor.yy450 ){
    yygotominor.yy450->pList = pList;
  }else{
    sqlite3ExprListDelete(pParse->db, pList);
  } 
  if( yymsp[-3].minor.yy316 ) yygotominor.yy450 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-4].minor.yy450->span,&yymsp[0].minor.yy450->span);
}
#line 2904 "parse.c"
        break;
      case 221: /* expr ::= expr in_op LP exprlist RP */
#line 812 "parse.y"
{
    yygotominor.yy450 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy450, 0, 0);
    if( yygotominor.yy450 ){
      yygotominor.yy450->pList = yymsp[-1].minor.yy242;
      sqlite3ExprSetHeight(pParse, yygotominor.yy450);
    }else{
      sqlite3ExprListDelete(pParse->db, yymsp[-1].minor.yy242);
    }
    if( yymsp[-3].minor.yy316 ) yygotominor.yy450 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy450, 0, 0);
    sqlite3ExprSpan(yygotominor.yy450,&yymsp[-4].minor.yy450->span,&yymsp[0].minor.yy0);
  }
#line 2919 "parse.c"
        break;
      case 222: /* expr ::= LP select RP */
#line 823 "parse.y"
{
    yygotominor.yy450 = sqlite3PExpr(pParse, TK_SELECT, 0, 0, 0);
    if( yygotominor.yy450 ){
      yygotominor.yy450->pSelect = yymsp[-1].minor.yy43;
      sqlite3ExprSetHeight(pParse, yygotominor.yy450);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy43);
    }
    sqlite3ExprSpan(yygotominor.yy450,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2933 "parse.c"
        break;
      case 223: /* expr ::= expr in_op LP select RP */
#line 833 "parse.y"
{
    yygotominor.yy450 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy450, 0, 0);
    if( yygotominor.yy450 ){
      yygotominor.yy450->pSelect = yymsp[-1].minor.yy43;
      sqlite3ExprSetHeight(pParse, yygotominor.yy450);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy43);
    }
    if( yymsp[-3].minor.yy316 ) yygotominor.yy450 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy450, 0, 0);
    sqlite3ExprSpan(yygotominor.yy450,&yymsp[-4].minor.yy450->span,&yymsp[0].minor.yy0);
  }
#line 2948 "parse.c"
        break;
      case 224: /* expr ::= expr in_op nm dbnm */
#line 844 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(pParse->db, 0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);
    yygotominor.yy450 = sqlite3PExpr(pParse, TK_IN, yymsp[-3].minor.yy450, 0, 0);
    if( yygotominor.yy450 ){
      yygotominor.yy450->pSelect = sqlite3SelectNew(pParse, 0,pSrc,0,0,0,0,0,0,0);
      sqlite3ExprSetHeight(pParse, yygotominor.yy450);
    }else{
      sqlite3SrcListDelete(pParse->db, pSrc);
    }
    if( yymsp[-2].minor.yy316 ) yygotominor.yy450 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy450, 0, 0);
    sqlite3ExprSpan(yygotominor.yy450,&yymsp[-3].minor.yy450->span,yymsp[0].minor.yy0.z?&yymsp[0].minor.yy0:&yymsp[-1].minor.yy0);
  }
#line 2964 "parse.c"
        break;
      case 225: /* expr ::= EXISTS LP select RP */
#line 856 "parse.y"
{
    Expr *p = yygotominor.yy450 = sqlite3PExpr(pParse, TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy43;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
      sqlite3ExprSetHeight(pParse, yygotominor.yy450);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy43);
    }
  }
#line 2978 "parse.c"
        break;
      case 226: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 869 "parse.y"
{
  yygotominor.yy450 = sqlite3PExpr(pParse, TK_CASE, yymsp[-3].minor.yy450, yymsp[-1].minor.yy450, 0);
  if( yygotominor.yy450 ){
    yygotominor.yy450->pList = yymsp[-2].minor.yy242;
    sqlite3ExprSetHeight(pParse, yygotominor.yy450);
  }else{
    sqlite3ExprListDelete(pParse->db, yymsp[-2].minor.yy242);
  }
  sqlite3ExprSpan(yygotominor.yy450, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2992 "parse.c"
        break;
      case 227: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 881 "parse.y"
{
  yygotominor.yy242 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy242, yymsp[-2].minor.yy450, 0);
  yygotominor.yy242 = sqlite3ExprListAppend(pParse,yygotominor.yy242, yymsp[0].minor.yy450, 0);
}
#line 3000 "parse.c"
        break;
      case 228: /* case_exprlist ::= WHEN expr THEN expr */
#line 885 "parse.y"
{
  yygotominor.yy242 = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy450, 0);
  yygotominor.yy242 = sqlite3ExprListAppend(pParse,yygotominor.yy242, yymsp[0].minor.yy450, 0);
}
#line 3008 "parse.c"
        break;
      case 237: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP */
#line 914 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy0, &yymsp[-5].minor.yy0, 
                     sqlite3SrcListAppend(pParse->db,0,&yymsp[-3].minor.yy0,0), yymsp[-1].minor.yy242, yymsp[-9].minor.yy316,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy316);
}
#line 3017 "parse.c"
        break;
      case 238: /* uniqueflag ::= UNIQUE */
      case 285: /* raisetype ::= ABORT */
#line 921 "parse.y"
{yygotominor.yy316 = OE_Abort;}
#line 3023 "parse.c"
        break;
      case 239: /* uniqueflag ::= */
#line 922 "parse.y"
{yygotominor.yy316 = OE_None;}
#line 3028 "parse.c"
        break;
      case 242: /* idxlist ::= idxlist COMMA nm collate sortorder */
#line 931 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy242 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy242, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy242, "index");
  if( yygotominor.yy242 ) yygotominor.yy242->a[yygotominor.yy242->nExpr-1].sortOrder = yymsp[0].minor.yy316;
}
#line 3042 "parse.c"
        break;
      case 243: /* idxlist ::= nm collate sortorder */
#line 941 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy242 = sqlite3ExprListAppend(pParse,0, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy242, "index");
  if( yygotominor.yy242 ) yygotominor.yy242->a[yygotominor.yy242->nExpr-1].sortOrder = yymsp[0].minor.yy316;
}
#line 3056 "parse.c"
        break;
      case 244: /* collate ::= */
#line 953 "parse.y"
{yygotominor.yy0.z = 0; yygotominor.yy0.n = 0;}
#line 3061 "parse.c"
        break;
      case 246: /* cmd ::= DROP INDEX ifexists fullname */
#line 959 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy419, yymsp[-1].minor.yy316);}
#line 3066 "parse.c"
        break;
      case 247: /* cmd ::= VACUUM */
      case 248: /* cmd ::= VACUUM nm */
#line 965 "parse.y"
{sqlite3Vacuum(pParse);}
#line 3072 "parse.c"
        break;
      case 249: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 250: /* cmd ::= PRAGMA nm dbnm EQ ON */
      case 251: /* cmd ::= PRAGMA nm dbnm EQ DELETE */
#line 974 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,0);}
#line 3079 "parse.c"
        break;
      case 252: /* cmd ::= PRAGMA nm dbnm EQ minus_num */
#line 977 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,1);
}
#line 3086 "parse.c"
        break;
      case 253: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
#line 980 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,&yymsp[-1].minor.yy0,0);}
#line 3091 "parse.c"
        break;
      case 254: /* cmd ::= PRAGMA nm dbnm */
#line 981 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0,0);}
#line 3096 "parse.c"
        break;
      case 262: /* cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END */
#line 996 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy0.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy0.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy75, &all);
}
#line 3106 "parse.c"
        break;
      case 263: /* trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause */
#line 1005 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy0, &yymsp[-6].minor.yy0, yymsp[-5].minor.yy316, yymsp[-4].minor.yy354.a, yymsp[-4].minor.yy354.b, yymsp[-2].minor.yy419, yymsp[0].minor.yy450, yymsp[-10].minor.yy316, yymsp[-8].minor.yy316);
  yygotominor.yy0 = (yymsp[-6].minor.yy0.n==0?yymsp[-7].minor.yy0:yymsp[-6].minor.yy0);
}
#line 3114 "parse.c"
        break;
      case 264: /* trigger_time ::= BEFORE */
      case 267: /* trigger_time ::= */
#line 1011 "parse.y"
{ yygotominor.yy316 = TK_BEFORE; }
#line 3120 "parse.c"
        break;
      case 265: /* trigger_time ::= AFTER */
#line 1012 "parse.y"
{ yygotominor.yy316 = TK_AFTER;  }
#line 3125 "parse.c"
        break;
      case 266: /* trigger_time ::= INSTEAD OF */
#line 1013 "parse.y"
{ yygotominor.yy316 = TK_INSTEAD;}
#line 3130 "parse.c"
        break;
      case 268: /* trigger_event ::= DELETE|INSERT */
      case 269: /* trigger_event ::= UPDATE */
#line 1018 "parse.y"
{yygotominor.yy354.a = yymsp[0].major; yygotominor.yy354.b = 0;}
#line 3136 "parse.c"
        break;
      case 270: /* trigger_event ::= UPDATE OF inscollist */
#line 1020 "parse.y"
{yygotominor.yy354.a = TK_UPDATE; yygotominor.yy354.b = yymsp[0].minor.yy352;}
#line 3141 "parse.c"
        break;
      case 273: /* when_clause ::= */
      case 290: /* key_opt ::= */
#line 1027 "parse.y"
{ yygotominor.yy450 = 0; }
#line 3147 "parse.c"
        break;
      case 274: /* when_clause ::= WHEN expr */
      case 291: /* key_opt ::= KEY expr */
#line 1028 "parse.y"
{ yygotominor.yy450 = yymsp[0].minor.yy450; }
#line 3153 "parse.c"
        break;
      case 275: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
#line 1032 "parse.y"
{
/*
  if( yymsp[-2].minor.yy75 ){
    yymsp[-2].minor.yy75->pLast->pNext = yymsp[-1].minor.yy75;
  }else{
    yymsp[-2].minor.yy75 = yymsp[-1].minor.yy75;
  }
*/
  assert( yymsp[-2].minor.yy75!=0 );
  yymsp[-2].minor.yy75->pLast->pNext = yymsp[-1].minor.yy75;
  yymsp[-2].minor.yy75->pLast = yymsp[-1].minor.yy75;
  yygotominor.yy75 = yymsp[-2].minor.yy75;
}
#line 3170 "parse.c"
        break;
      case 276: /* trigger_cmd_list ::= trigger_cmd SEMI */
#line 1045 "parse.y"
{ 
  /* if( yymsp[-1].minor.yy75 ) */
  assert( yymsp[-1].minor.yy75!=0 );
  yymsp[-1].minor.yy75->pLast = yymsp[-1].minor.yy75;
  yygotominor.yy75 = yymsp[-1].minor.yy75;
}
#line 3180 "parse.c"
        break;
      case 277: /* trigger_cmd ::= UPDATE orconf nm SET setlist where_opt */
#line 1056 "parse.y"
{ yygotominor.yy75 = sqlite3TriggerUpdateStep(pParse->db, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy242, yymsp[0].minor.yy450, yymsp[-4].minor.yy316); }
#line 3185 "parse.c"
        break;
      case 278: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP */
#line 1061 "parse.y"
{yygotominor.yy75 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-5].minor.yy0, yymsp[-4].minor.yy352, yymsp[-1].minor.yy242, 0, yymsp[-7].minor.yy316);}
#line 3190 "parse.c"
        break;
      case 279: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt select */
#line 1064 "parse.y"
{yygotominor.yy75 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-2].minor.yy0, yymsp[-1].minor.yy352, 0, yymsp[0].minor.yy43, yymsp[-4].minor.yy316);}
#line 3195 "parse.c"
        break;
      case 280: /* trigger_cmd ::= DELETE FROM nm where_opt */
#line 1068 "parse.y"
{yygotominor.yy75 = sqlite3TriggerDeleteStep(pParse->db, &yymsp[-1].minor.yy0, yymsp[0].minor.yy450);}
#line 3200 "parse.c"
        break;
      case 281: /* trigger_cmd ::= select */
#line 1071 "parse.y"
{yygotominor.yy75 = sqlite3TriggerSelectStep(pParse->db, yymsp[0].minor.yy43); }
#line 3205 "parse.c"
        break;
      case 282: /* expr ::= RAISE LP IGNORE RP */
#line 1074 "parse.y"
{
  yygotominor.yy450 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy450 ){
    yygotominor.yy450->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy450, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3216 "parse.c"
        break;
      case 283: /* expr ::= RAISE LP raisetype COMMA nm RP */
#line 1081 "parse.y"
{
  yygotominor.yy450 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, &yymsp[-1].minor.yy0); 
  if( yygotominor.yy450 ) {
    yygotominor.yy450->iColumn = yymsp[-3].minor.yy316;
    sqlite3ExprSpan(yygotominor.yy450, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3227 "parse.c"
        break;
      case 284: /* raisetype ::= ROLLBACK */
#line 1091 "parse.y"
{yygotominor.yy316 = OE_Rollback;}
#line 3232 "parse.c"
        break;
      case 286: /* raisetype ::= FAIL */
#line 1093 "parse.y"
{yygotominor.yy316 = OE_Fail;}
#line 3237 "parse.c"
        break;
      case 287: /* cmd ::= DROP TRIGGER ifexists fullname */
#line 1098 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy419,yymsp[-1].minor.yy316);
}
#line 3244 "parse.c"
        break;
      case 288: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
#line 1105 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy450, yymsp[-1].minor.yy450, yymsp[0].minor.yy450);
}
#line 3251 "parse.c"
        break;
      case 289: /* cmd ::= DETACH database_kw_opt expr */
#line 1108 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy450);
}
#line 3258 "parse.c"
        break;
      case 294: /* cmd ::= REINDEX */
#line 1123 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3263 "parse.c"
        break;
      case 295: /* cmd ::= REINDEX nm dbnm */
#line 1124 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3268 "parse.c"
        break;
      case 296: /* cmd ::= ANALYZE */
#line 1129 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3273 "parse.c"
        break;
      case 297: /* cmd ::= ANALYZE nm dbnm */
#line 1130 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3278 "parse.c"
        break;
      case 298: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
#line 1135 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy419,&yymsp[0].minor.yy0);
}
#line 3285 "parse.c"
        break;
      case 299: /* cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column */
#line 1138 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy0);
}
#line 3292 "parse.c"
        break;
      case 300: /* add_column_fullname ::= fullname */
#line 1141 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy419);
}
#line 3299 "parse.c"
        break;
      case 303: /* cmd ::= create_vtab */
#line 1150 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3304 "parse.c"
        break;
      case 304: /* cmd ::= create_vtab LP vtabarglist RP */
#line 1151 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3309 "parse.c"
        break;
      case 305: /* create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm */
#line 1152 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy0, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3316 "parse.c"
        break;
      case 308: /* vtabarg ::= */
#line 1157 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3321 "parse.c"
        break;
      case 310: /* vtabargtoken ::= ANY */
      case 311: /* vtabargtoken ::= lp anylist RP */
      case 312: /* lp ::= LP */
      case 314: /* anylist ::= anylist ANY */
#line 1159 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3329 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  assert( TOKEN.z[0] );  /* The tokenizer always gives us a token */
  sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
  pParse->parseError = 1;
#line 3394 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
