#ifndef _WB_OVERVIEW_LIVE_PHYSICAL_SCHEMA_H_
#define _WB_OVERVIEW_LIVE_PHYSICAL_SCHEMA_H_

#include "workbench/wb_overview.h"
#include "model/wb_overview_physical_schema.h"
#include "workbench/wb_context.h"


namespace wb { namespace internal {

  class PhysicalSchemaContentNode;

  class LivePhysicalSchemaNode : public PhysicalSchemaNode
  {
    virtual bool add_new_db_table(WBContext *wb);
    virtual bool add_new_db_view(WBContext *wb);
    virtual bool add_new_db_routine_group(WBContext *wb);
    virtual bool add_new_db_routine(WBContext *wb);
    
  public:
    LivePhysicalSchemaNode(db_SchemaRef schema);
    virtual void paste_object(WBContext *wb, bec::Clipboard *clip);
    virtual bool is_pasteable(bec::Clipboard *clip);
    virtual bool is_deletable();
    virtual void delete_object(WBContext *wb);
    virtual bool activate(WBContext *wb);
    virtual void focus(OverviewBE *sender);

  public:
    virtual SchemaObjectNode * create_table_node(const db_DatabaseObjectRef &dbobject);
    virtual SchemaObjectNode * create_view_node(const db_DatabaseObjectRef &dbobject);
    virtual SchemaObjectNode * create_routine_node(const db_DatabaseObjectRef &dbobject);
    virtual SchemaObjectNode * create_routine_group_node(const db_DatabaseObjectRef &dbobject);
  };

  class LiveSchemaTableNode : public SchemaTableNode
  {
  public:
    LiveSchemaTableNode(const db_DatabaseObjectRef &dbobject) : SchemaTableNode(dbobject) {}
    virtual bool activate(WBContext *wb) { return wb->activate_live_object(object); }
    virtual bool is_renameable() { return false; }
  };

  class LiveSchemaViewNode : public SchemaViewNode
  {
  public:
    LiveSchemaViewNode(const db_DatabaseObjectRef &dbobject) : SchemaViewNode(dbobject) {}
    virtual bool activate(WBContext *wb) { return wb->activate_live_object(object); }
  };

  class LiveSchemaRoutineGroupNode : public SchemaRoutineGroupNode
  {
  public:
    LiveSchemaRoutineGroupNode(const db_DatabaseObjectRef &dbobject) : SchemaRoutineGroupNode(dbobject) {}
    virtual bool activate(WBContext *wb) { return wb->activate_live_object(object); }
  };

  class LiveSchemaRoutineNode : public SchemaRoutineNode
  {
  public:
    LiveSchemaRoutineNode(const db_DatabaseObjectRef &dbobject) : SchemaRoutineNode(dbobject) {}
    virtual bool activate(WBContext *wb) { return wb->activate_live_object(object); }
  };

}; };

#endif /* _WB_OVERVIEW_LIVE_PHYSICAL_SCHEMA_H_ */
