
// test model file 

#include "stdafx.h"


#include "test.h"

#include "workbench/wb_model_file.h"

#include "wb_helpers.h"
#include "grt_test_utility.h"


using namespace wb;



BEGIN_TEST_DATA_CLASS(wb_model_file)
public:
  WBTester tester;
  bec::GRTManager *grtm;
END_TEST_DATA_CLASS;





TEST_MODULE(wb_model_file, "tests for WB model file");


TEST_FUNCTION(1)
{
  grt::GRT *grt= tester.wb->get_grt();
  grtm= bec::GRTManager::get_instance_for(grt);

  {
    ModelFile mf;

    workbench_DocumentRef doc(grt);

    // create a test file, change it and then save_as
    
    mf.create(grtm);

    doc->name("t1");
    mf.store_document(grt, doc);
    mf.save_to("t1.mwb");

    doc->name("t2");
    mf.store_document(grt, doc);
    mf.save_to("t2.mwb");
  }

  {
    ModelFile mf1;
    ModelFile mf2;

    mf1.open("t1.mwb", grtm);
    mf2.open("t2.mwb", grtm);

    workbench_DocumentRef d1, d2;

    d1= mf1.retrieve_document(grt);
    d2= mf2.retrieve_document(grt);

    ensure_equals("document 1 content", *d1->name(), "t1");
    ensure_equals("document 2 content", *d2->name(), "t2");
  }
}


TEST_FUNCTION(2)
{
  // load sakile a bunch of times

  ModelFile m;

  for (int i= 0; i < 10; i++)
    m.open("data/workbench/sakila.mwb", grtm);
}

TEST_FUNCTION(3)
{
  WBTester wb;
  wb.wb->open_document("data/workbench/sakila_full.mwb");
  wb.wb->close_document();
}


END_TESTS
