/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#include "stdafx.h"

#include "eol_format_dialog.h"
#include "grt/common.h"
#include "string_utilities.h"
#include <glib.h>


using namespace mforms;
using namespace base;


EolFormatDialog::EolFormatDialog(const std::string &title, const std::string &message, base::EolHelpers::Eol_format default_eol_format)
:
Form(0)
{
  Box *vbox = manage(new Box(false));
  set_content(vbox);
  vbox->set_padding(12);
  vbox->set_spacing(12);
  
  Label *l = manage(new Label(title));
  l->set_style(BoldStyle);
  vbox->add(l, false, true);
  
  l = manage(new Label(message));
  vbox->add(l, false, true);

  Box *hbox = manage(new Box(true));
  vbox->add(hbox, false, true);

  hbox->add(manage(new Label(_("Line Ending Format:"))), false, true);
  hbox->add(&_eol_format_selector, true, true);
  {
    _eol_format_selector.add_item("LF");
    _eol_format_selector.add_item("CR");
    _eol_format_selector.add_item("CR+LF");
    int default_index= 0;
    switch (default_eol_format)
    {
    case EolHelpers::eol_lf: default_index= 0; break;
    case EolHelpers::eol_cr: default_index= 1; break;
    case EolHelpers::eol_crlf: default_index= 2; break;
    }
    _eol_format_selector.set_selected(default_index);
  }
  
  Box *bbox = manage(new Box(true));
  vbox->add(bbox, false, true);
  bbox->set_spacing(12);

  _ok_btn.set_text(_("OK"));
  _cancel_btn.set_text(_("Cancel"));

  Utilities::add_end_ok_cancel_buttons(bbox, &_ok_btn, &_cancel_btn);
}


bool EolFormatDialog::run()
{
  return run_modal(&_ok_btn, &_cancel_btn);
}


EolHelpers::Eol_format EolFormatDialog::eol_format()
{
  switch (_eol_format_selector.get_selected_index())
  {
  case 0: return EolHelpers::eol_lf;
  case 1: return EolHelpers::eol_cr;
  case 2: return EolHelpers::eol_crlf;
  }
  return EolHelpers::eol_lf;
}
