#ifndef __FINDDIALOGBE_H__
#define __FINDDIALOGBE_H__

#include "wb_config.h"

#include "workbench/wb_find_dialog.h"
#include "GrtTemplates.h"

#ifdef _MSC_VER
#include  <vcclr.h> // .net interop helpers
using namespace MySQL::Grt;
using namespace System;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;
#endif

namespace MySQL {
namespace Workbench {


  public enum class FindResult
  {
    NotFound= ::wb::NotFound,
    FoundMatch= ::wb::FoundMatch,
    NoMoreMatches= ::wb::NoMoreMatches
  };




  public ref class FindDialogBE
  {
  public:
    FindDialogBE(::wb::FindDialogBE *be)
      : inner(be)
    {
    }

    void set_text(String ^text)
    {
      inner->set_text(NativeToCppString(text));
    }


    void set_match_case(bool flag)
    {
      inner->set_match_case(flag);
    }


    void set_search_in_comments(bool flag)
    {
      inner->set_search_in_comments(flag);
    }

    void set_search_in_sql(bool flag)
    {
      inner->set_search_in_sql(flag);
    }

    FindResult find_next()
    {
      return (FindResult)inner->find_next();
    }

    FindResult find_previous()
    {
      return (FindResult)inner->find_previous();
    }


  protected:
    ::wb::FindDialogBE *inner;
  };

} // namespace Workbench
} // namespace MySQL



#endif // __FINDDIALOGBE_H__
