#ifndef __WB_SQL_EDITOR_SNIPPETS_WR_H__
#define __WB_SQL_EDITOR_SNIPPETS_WR_H__


#include "sqlide/wb_sql_editor_snippets.h"
#include "Overview.h"

namespace MySQL {
namespace GUI {
namespace Workbench {


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
using namespace MySQL::Grt;
using namespace MySQL::Grt::Db;
using namespace MySQL::Grt::Db::Sql;


public ref class DbSqlEditorSnippets : public ::MySQL::Grt::ListModel
{
public:
  DbSqlEditorSnippets() 
    : ::MySQL::Grt::ListModel(::DbSqlEditorSnippets::get_instance())
  {}
  
  List<MySQL::Grt::ToolbarItem^> ^get_toolbar_items()
  {
    bec::ToolbarItemList items = get_unmanaged_object()->get_toolbar_items();
    return CppVectorToObjectList<::bec::ToolbarItem, MySQL::Grt::ToolbarItem> (items);
  }

  bool activate_toolbar_item(NodeId^ selected, String^ name)
  {
    return get_unmanaged_object()->activate_toolbar_item(*selected->get_unmanaged_object(), NativeToCppString(name));
  }

  ::DbSqlEditorSnippets *get_unmanaged_object()
  {
    return ::DbSqlEditorSnippets::get_instance();
  }

  List<String^> ^get_category_list()
  {
    List<String^> ^list = gcnew List<String^>();
    std::vector<std::string> categories = get_unmanaged_object()->get_category_list();
    for (std::vector<std::string>::const_iterator cat = categories.begin();
      cat != categories.end(); ++cat)
    {
      list->Add(CppStringToNative(*cat));
    }
    return list;
  }

  void select_category(String ^category)
  {
    get_unmanaged_object()->select_category(NativeToCppString(category));
  }

  String^ selected_category()
  {
    return CppStringToNative(get_unmanaged_object()->selected_category());
  }

  static DbSqlEditorSnippets ^get_instance()
  {
    if (instance == nullptr)
      instance = gcnew DbSqlEditorSnippets();
    return instance;
  }

private:
  static DbSqlEditorSnippets ^instance = nullptr;
};


};  // namespace Workbench
};  // namespace GUI
};  // namespace MySQL


#endif // __WB_SQL_EDITOR_SNIPPETS_WR_H__
