/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _NEWCONNECTIONWIZARD_H_
#define _NEWCONNECTIONWIZARD_H_


#include "workbench/wb_backend_public_interface.h"
#include <mforms/mforms.h>

#include "grtui/db_conn_be.h"
#include "grtui/grtdb_connect_panel.h"
#include "grt/grt_manager.h"

class MYSQLWBBACKEND_PUBLIC_FUNC NewConnectionWizard : public mforms::Form
{
public:
  NewConnectionWizard(const db_mgmt_ManagementRef &mgmt);
  ~NewConnectionWizard();
  
  db_mgmt_ConnectionRef run();
  
protected:
  db_mgmt_ManagementRef _mgmt;
  grtui::DbConnectPanel _panel;
  db_mgmt_ConnectionRef _connection;
  mforms::Box _top_vbox;
  
  mforms::TextEntry *_conn_name;
  
  mforms::Box _bottom_hbox;
  mforms::Button _ok_button;
  mforms::Button _cancel_button;
  mforms::Button _test_button;
};

#endif /* _NEWCONNECTIONWIZARD_H_ */
