

#include "form_view_base.h"
#include "plugin_editor_base.h"
#include <gtkmm/box.h>
#include <gtkmm/label.h>
#include <gtkmm/eventbox.h>
#include <gtkmm/window.h>

bool FormViewBase::close_plugin_tab(PluginEditorBase *editor)
{
  if (editor->can_close())
  {
    _close_editor(editor);

    editor->hide();
    
    remove_plugin_tab(editor);
  }
  else
    return false;

  bool visible= false;
  for (int c= _editor_note->get_n_pages(), i= 0; i < c; i++)
  {
    if (_editor_note->get_nth_page(i)->is_visible())
    {
      visible= true;
      break;
    }
  }
  if (!visible)
    _editor_note->hide();

  return false;
}


void FormViewBase::set_close_editor_callback(const sigc::slot<void, PluginEditorBase*> &handler)
{
  _close_editor = handler;
}
  

void FormViewBase::add_plugin_tab(PluginEditorBase *plugin)
{
  if (_editor_note)
  {
    Gtk::HBox *hbox= Gtk::manage(new Gtk::HBox(false, 1));
    Gtk::Label *label= Gtk::manage(new Gtk::Label("\342\234\225"));
    Gtk::EventBox *evbox= Gtk::manage(new Gtk::EventBox());
    Gtk::Label *text_label= Gtk::manage(new Gtk::Label(plugin->get_title()));

    evbox->add(*label);
    evbox->signal_button_release_event().
      connect(sigc::bind(sigc::hide<0>(sigc::mem_fun(this, &FormViewBase::close_plugin_tab)), plugin));
    
    hbox->pack_start(*text_label);
    hbox->pack_start(*evbox);
    hbox->show_all();

    _editor_note->append_page(*plugin, *hbox);

    plugin->signal_title_changed().connect(sigc::mem_fun(text_label, &Gtk::Label::set_text));
  
    /*
     if (auto_switch)
     {
     // switch the current page when we're in idle
     Glib::signal_idle().connect(sigc::bind_return(sigc::bind(sigc::mem_fun(note, &Gtk::Notebook::set_current_page),
     note->get_n_pages()-1), false));
     }*/
    if (!_editor_note->is_visible())
    {
      _editor_note->show();
      reset_layout();
    }
  }
  else
    g_warning("active form doesn't support editor tabs");
}



void FormViewBase::remove_plugin_tab(PluginEditorBase *plugin)
{
  if (_editor_note)
  {
    _editor_note->remove_page(*plugin);
  
    if (_editor_note->get_n_pages() == 0)
      _editor_note->hide();
  }
}


bool FormViewBase::close_editors_for_object(const std::string &id)
{
  for (int i= _editor_note->get_n_pages()-1; i >= 0; --i)
  {
    Gtk::Widget *panel= _editor_note->get_nth_page(i);
    PluginEditorBase* editor;
    if ((editor= dynamic_cast<PluginEditorBase*>(panel))
        && (id.empty() || editor->should_close_on_delete_of(id)))
    {
      remove_plugin_tab(editor);
      return true;
    }
  }

  return false;
}


PluginEditorBase *FormViewBase::get_focused_plugin_tab()
{
  if (_editor_note)
  {
    Gtk::Widget *focused= dynamic_cast<Gtk::Window*>(_editor_note->get_toplevel())->get_focus();

    // go up the hierarchy to see if the focused widget is inside _editor_note
    while (focused && focused != _editor_note)
      focused= focused->get_parent();
    
    if (focused)
    {
      int page= _editor_note->get_current_page();
      if (page >= 0)
      {
        Gtk::Widget *tab= _editor_note->get_nth_page(page);
        return dynamic_cast<PluginEditorBase*>(tab);
      }
    }
  }

  return 0;
}


bool FormViewBase::close_focused_tab()
{
  PluginEditorBase *active = get_focused_plugin_tab();

  if (active)
  {
    close_plugin_tab(active);
    return true;
  }

  return false;
}

