//!
//! \addtogroup linuxui Linux UI
//! @{
//!

#ifndef _LAYER_TREE_H_
#define _LAYER_TREE_H_

#include <gtkmm/scrolledwindow.h>
#include <gtkmm/treeview.h>

#include "treemodel_wrapper.h"
#include "workbench/wb_context_ui.h"
#include "model/wb_layer_tree.h"

class LayerTree : public Gtk::ScrolledWindow
{
  wb::WBContextUI *_wbui;
  wb::LayerTreeBE *_layer_tree;
  wb::ModelDiagramForm *_diagram_form;
  Gtk::TreeView _tree;
  Glib::RefPtr<TreeModelWrapper> _model;
  Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > *_column;

  Glib::RefPtr<Gdk::Pixbuf> _selected_icon;
  Glib::RefPtr<Gdk::Pixbuf> _unselected_icon;
  Glib::RefPtr<Gdk::Pixbuf> _mixed_icon;

  bool reexpand_node(const Gtk::TreePath &path);
  void reexpand_nodes();

  void get_tree_value(const Gtk::TreeModel::iterator &iter, int column, GType type, Glib::ValueBase& value);

  void activate_row(const Gtk::TreePath &path, Gtk::TreeViewColumn *column);

  void tree_changed(const bec::NodeId &row, int old_count);
  
public:
  LayerTree(wb::WBContextUI *wbui);
  ~LayerTree();
  
  void set_model(wb::ModelDiagramForm *model);

  void refresh();
};


#endif /* _LAYER_TREE_H_ */

//!
//! @}
//!
