#ifndef _QUERY_SIDEBAR_H_
#define _QUERY_SIDEBAR_H_


#include "linux_utilities/MGGladeXML.h"
#include "sqlide/wb_sql_editor_form.h"
#include "sqlide/wb_live_schema_tree.h"
#include "linux_utilities/treemodel_wrapper.h"
#include "sql_snippets_view.h"

namespace Gtk
{
class TextView;
}

class QuerySidebar : public sigc::trackable
{
private:
  MGGladeXML *_ui;

  Db_sql_editor::Ref _editor;
  Gtk::TreeView *_schema_tree_view;
  Glib::RefPtr<TreeModelWrapper> _schema_tree_model;
  SqlSnippetsView *_sql_snippets_view;
  Gtk::TextView *_info_text;
  
public:
  void refresh_active_schema_selector(bool reload_list);
private:
  void schema_changed();
  bool _refreshing_active_schema_selector;

private:
  void activate_row(const Gtk::TreeModel::Path &path, Gtk::TreeViewColumn* column);
  
  void handle_context_menu_item(const std::string &name, const std::vector<bec::NodeId> &nodes);
  void on_schema_tree_view_selection_changed();

  void pre_refresh_live_tree();
  void refresh_node_ui(const bec::NodeId &node);

public:
  QuerySidebar(Db_sql_editor::Ref editor, MGGladeXML *xml);
  virtual ~QuerySidebar();
  
  void refresh(bool is_active_schema_set_needed);
  void refresh_schema_tree();
  
  SqlSnippetsView * sql_snippets_view() { return _sql_snippets_view; }
};


#endif /* _QUERY_SIDEBAR_H_ */
