//
//  MCanvasViewer.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 13/Oct/08.
//  Copyright 2008 Sun Microsystems Inc. All rights reserved.
//

#import "sigobjc++.h"
#import <Cocoa/Cocoa.h>
#include "mdc_canvas_view_macosx.h"

@interface MCanvasViewer : NSView 
{
  mdc::QuartzCanvasView *_view;
  id _delegate;
  NSCursor *_cursor;
  int _buttonState;
  NSTrackingArea *_trackingArea;
  
  BOOL _firstResponder;
  BOOL _needsContextReset;
}

//- (void)setupOpenGL;
- (void)setupQuartz;

- (mdc::CanvasView*)canvas;

- (void)setCursor:(NSCursor*)cursor;

- (id)delegate;
- (void)setDelegate:(id)delegate;

- (void)scrollToPoint:(NSPoint)offset;
- (NSRect)documentRect;
- (NSRect)documentVisibleRect;

@end


@interface NSObject (MCanvasViewerDelegate)
- (BOOL)canvasMouseDown:(mdc::MouseButton)button
               location:(NSPoint)pos
                  state:(mdc::EventState)state;
- (BOOL)canvasMouseDoubleClick:(mdc::MouseButton)button
                      location:(NSPoint)pos
                         state:(mdc::EventState)state;
- (BOOL)canvasMouseUp:(mdc::MouseButton)button
             location:(NSPoint)pos
                state:(mdc::EventState)state;
- (BOOL)canvasMouseMoved:(NSPoint)pos
                   state:(mdc::EventState)state;

- (BOOL)canvasKeyDown:(mdc::KeyInfo)key state:(mdc::EventState)state;
- (BOOL)canvasKeyUp:(mdc::KeyInfo)key state:(mdc::EventState)state;

- (NSDragOperation)canvasDraggingEntered:(id < NSDraggingInfo >)sender;
- (BOOL)canvasPerformDragOperation:(id < NSDraggingInfo >)sender;
@end

