
/*!
 Copyright 2009 Sun Microsystems, Inc.
 
 @author
 jak
 
 @class
 WBToolbarTabView
 
 @abstract
 Implements custom tabs. Tabs at the top of the window, pointing downwards, looking like they are part of the window frame.
 
 @ingroup
 Custom Tab Views
 */



#import "WBToolbarTabView.h"
#import "WBToolbarTabItem.h"



@implementation WBToolbarTabView



- (CALayer*) lineLayer;
{
  return nil;
}



- (WBTabItem*) tabItemWithIdentifier: (id) identifier
                               label: (NSString*) label;
{
	WBTabItem* item = [WBToolbarTabItem tabItemWithIdentifier: identifier
                                                      label: label];
	
	return item;
}



- (void) doCustomize;
{
	mTabPlacement = WBTabPlacementTop;
	mTabDirection = WBTabDirectionDown;
	mTabSize = WBTabSizeLarge;

	[super doCustomize];
}



@end


