//
//  WBMenuManager.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 3/Oct/08.
//  Copyright 2008 Sun Microsystems Inc. All rights reserved.
//

#import "sigobjc++.h"
#import <Cocoa/Cocoa.h>
#include "workbench/wb_context_ui.h"


@interface WBMenuItem : NSMenuItem
{
  NSString *_command;
}

- (id)initWithItem:(const bec::MenuItem&)item action:(SEL)action;
- (NSString*)command;
- (void)update:(const bec::MenuItem&)item;
@end


@interface WBMenuManager : NSObject 
{
  wb::WBContextUI *_wbui;
  NSWindow *_mainWindow;
  
  NSMenuItem *_defaultEditMenu;
  
  NSMenu *_menuBar;
}

+ (void)fillMenu:(NSMenu*)menu withItems:(const bec::MenuItemList&)items 
        selector:(SEL)selector target:(id)target;

- (id)initWithMenuBar:(NSMenu*)menu
           mainWindow:(NSWindow*)window
            WBContext:(wb::WBContextUI*)wbui;

- (void)updateEditMenu;
- (void)rebuildMainMenu;
- (void)rebuildMainMenuForAuxiliaryWindow;

- (void)refreshMenu:(NSMenu*)menu withItems:(const bec::MenuItemList&)items;

- (void)differentialMenuRebuild:(NSMenu*)menu
                          items:(const bec::MenuItemList&)items;
@end
