//
//  WBOverviewListController.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 12/Oct/08.
//  Copyright 2008 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "sigobjc++.h"
#include "workbench/wb_overview.h"

@class MCollectionViewItemView;

// Acts both as a model/controller to a NSCollectionView and as a datasource to a NSOutlineView
// for providing contents for item lists

@interface WBOverviewListController : NSObject
{
  NSMutableArray* mItems;
  NSMutableIndexSet *mSelectedIndexes;
  
  IBOutlet NSCollectionView* collectionView;
  IBOutlet NSCollectionViewItem* largeIcon;
  IBOutlet NSCollectionViewItem* smallIcon;
  
  wb::OverviewBE* mOverview;
}

- (void) setOverviewBE:(wb::OverviewBE*) overview;

- (void)setCollectionView: (NSCollectionView*) view;

- (void) setItems: (NSMutableArray*) items;
- (NSMutableArray*) items;

- (void) setSelectedIndexes: (NSIndexSet*) indexSet;
- (NSIndexSet*) selectedIndexes;

- (void) fillFromChildrenOf: (const bec::NodeId&) node
                  overview:(wb::OverviewBE*) overview
                  iconSize:(bec::IconSize) iconSize;

- (void) setShowLargeIcons: (BOOL) flag;

@end
