/*
* Arguments class: application arguments interpreter
*
* Authors:		R. LOPES
* Contributors:	R. LOPES
* Created:		25 October 2002
* Modified:		28 October 2002
*
* Version:		1.0
*/

using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text.RegularExpressions;

namespace MySQL.Utilities
{
	/// <summary>
	/// Arguments class
	/// </summary>
	public class Arguments
	{
		// Variables
		private StringDictionary Parameters;
    private List<String> LeftoverParameters;
    private Dictionary<string,bool> Options;

    public Arguments()
    {
      Parameters= new StringDictionary();
      Options= new Dictionary<string,bool>();
      LeftoverParameters= new List<string>();
    }


    public void AddOptionName(String name, bool istoggle)
    {
      Options[name]= istoggle;
    }


    public void Parse(string[] Args)
    {
      Regex Remover = new Regex(@"^['""]?(.*?)['""]?$", RegexOptions.IgnoreCase | RegexOptions.Compiled);

      for (int i= 0; i < Args.Length; i++)
      {
        string option= Args[i];
        string value= null;

        if (Args[i].Contains("="))
        {
          string[] parts= Args[i].Split(new char[]{'='}, 2);

          option= parts[0];
          value= parts[1];
        }

        if (option[0] == '-' && Options.ContainsKey(option))
        {
          String optname = option.Substring(1);

          if (Options[option])
            Parameters[optname]= "true";
          else
          {
            if (value != null)
              Parameters[optname]= Remover.Replace(value, "$1");
            else
            {
              if (i+1 < Args.Length)
                Parameters[optname]= Remover.Replace(Args[++i], "$1");
              else
                Parameters[optname]= ""; // missing argument!
            }
          }
        }
        else
          LeftoverParameters.Add(Args[i]);
      }
    }

#if notdef
		// Constructor
		public Arguments(string[] Args)
		{
			Parameters = new StringDictionary();
			Regex Spliter = new Regex(@"^-{1,2}|^/|=", RegexOptions.IgnoreCase | RegexOptions.Compiled);
			Regex Remover = new Regex(@"^['""]?(.*?)['""]?$", RegexOptions.IgnoreCase | RegexOptions.Compiled);
			string Parameter = null;
			string[] Parts;

			// Valid parameters forms:
			// {-,/,--}param{ ,=,:}((",')value(",'))
			// Examples: -param1 value1 --param2 /param3:"Test-:-work" /param4=happy -param5 '--=nice=--'
			foreach (string Txt in Args)
			{
				// Look for new parameters (-,/ or --) and a possible enclosed value (=,:)
				Parts = Spliter.Split(Txt, 3);
				switch (Parts.Length)
				{
					// Found a value (for the last parameter found (space separator))
					case 1:
						if (Parameter != null)
						{
							if (!Parameters.ContainsKey(Parameter))
							{
								Parts[0] = Remover.Replace(Parts[0], "$1");
								Parameters.Add(Parameter, Parts[0]);
							}
							Parameter = null;
						}
						// else Error: no parameter waiting for a value (skipped)
						break;
					// Found just a parameter
					case 2:
						// The last parameter is still waiting. With no value, set it to true.
						if (Parameter != null)
						{
							if (!Parameters.ContainsKey(Parameter)) Parameters.Add(Parameter, "true");
						}
						Parameter = Parts[1];
						break;
					// Parameter with enclosed value
					case 3:
						// The last parameter is still waiting. With no value, set it to true.
						if (Parameter != null)
						{
							if (!Parameters.ContainsKey(Parameter)) Parameters.Add(Parameter, "true");
						}
						Parameter = Parts[1];
						// Remove possible enclosing characters (",')
						if (!Parameters.ContainsKey(Parameter))
						{
							Parts[2] = Remover.Replace(Parts[2], "$1");
							Parameters.Add(Parameter, Parts[2]);
						}
						Parameter = null;
						break;
				}
			}
			// In case a parameter is still waiting
			if (Parameter != null)
			{
				if (!Parameters.ContainsKey(Parameter)) Parameters.Add(Parameter, "true");
			}
		}
#endif

		// Retrieve a parameter value if it exists
		public string this[string Param]
		{
			get
			{
				return (Parameters[Param]);
			}
		}

    public List<string> Leftovers
    {
      get
      {
        return LeftoverParameters;
      }
    }
	}
}
