using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using MySQL.Grt;
using MySQL.Utilities.Properties;

namespace MySQL.Utilities
{
  public class MenuManager
  {
    public System.Windows.Forms.ContextMenuStrip ShowContextMenu(System.Windows.Forms.Control parent, List<MySQL.Grt.MenuItem> items,
      int x, int y, EventHandler handler)
    {
      System.Windows.Forms.ContextMenuStrip menu = new System.Windows.Forms.ContextMenuStrip();
      System.Windows.Forms.ToolStripItem[] itemList;

      itemList = buildMenu(items, handler);
      menu.Items.AddRange(itemList);

      menu.Show(parent, new System.Drawing.Point(x, y), ToolStripDropDownDirection.BelowRight);
      return menu;
    }

    public virtual void buildSubmenu(ToolStripMenuItem parentItem, String name, List<MySQL.Grt.MenuItem> subitems,
      EventHandler handler)
    {
      ToolStripItem[] itemlist = buildMenu(subitems, handler);

      parentItem.DropDownItems.Clear();
      parentItem.DropDownItems.AddRange(itemlist);
    }

    public virtual System.Windows.Forms.ToolStripItem[] buildMenu(List<MySQL.Grt.MenuItem> menuItems, System.EventHandler handler)
    {
      System.Windows.Forms.ToolStripItem[] itemlist = new System.Windows.Forms.ToolStripItem[menuItems.Count];
      int i = 0;

      // rebuild the menu
      foreach (MySQL.Grt.MenuItem subitem in menuItems)
      {
        Keys shortcut = Keys.None;

        String skeys = subitem.get_shortcut();
        if (skeys != "")
        {
          foreach (String k in skeys.Split(new char[]{'+'}))
          {
            int x;

            // Convert the platform neutral keywords to such used on Windows.
            String shortcutString = k;
            if (k.Equals("Modifier"))
              shortcutString = "Control";
            if (k.Equals("Alternate"))
              shortcutString = "Alt";
            if (k.Equals("Plus"))
              shortcutString = "Oemplus";
            if (k.Equals("Minus"))
              shortcutString = "OemMinus";
            if (k.Equals("Slash"))
              shortcutString = "Divide";
            if (k.Length == 1 && int.TryParse(k, out x))
              shortcut |= (Keys)Enum.Parse(typeof(Keys), "D" + shortcutString);
            else
              shortcut |= (Keys)Enum.Parse(typeof(Keys), shortcutString, true);
          }
        }

        switch (subitem.get_type())
        {
          case MenuItemType.MenuAction:
          case MenuItemType.MenuUnavailable:
            {
              System.Windows.Forms.ToolStripMenuItem smitem;

              smitem = new System.Windows.Forms.ToolStripMenuItem();
              smitem.Name = subitem.get_name();
              smitem.Text = subitem.get_caption();
              smitem.ShortcutKeys = shortcut;
              smitem.Enabled = subitem.get_enabled();
              if (subitem.get_type() == MenuItemType.MenuUnavailable)
              {
                smitem.Image = Resources.menu_se;
                smitem.Enabled = false;
              }
              smitem.Click += handler;
              itemlist[i++] = smitem;
              break;
            }
            
          case MenuItemType.MenuCheck:
          case MenuItemType.MenuRadio:
            {
              System.Windows.Forms.ToolStripMenuItem smitem;

              smitem = new System.Windows.Forms.ToolStripMenuItem();
              smitem.Name = subitem.get_name();
              smitem.Text = subitem.get_caption();
              smitem.ShortcutKeys = shortcut;
              smitem.Enabled = subitem.get_enabled();
              smitem.Checked = subitem.get_checked();
              smitem.Click += handler;
              itemlist[i++] = smitem;
              break;
            }

          case MenuItemType.MenuSeparator:
            itemlist[i++] = new System.Windows.Forms.ToolStripSeparator();
            break;

          case MenuItemType.MenuCascade:
            {
              System.Windows.Forms.ToolStripMenuItem smitem;

              smitem = new System.Windows.Forms.ToolStripMenuItem();
              smitem.Name = subitem.get_name();
              smitem.Text = subitem.get_caption();
              smitem.ShortcutKeys = shortcut;
              smitem.Enabled = subitem.get_enabled();
              buildSubmenu(smitem, subitem.get_name(), subitem.get_subitems(), handler);
              itemlist[i++] = smitem;
              break;
            }

          default:
            throw new Exception("bad item type");
        }
      }
      return itemlist;
    }

  }
}
