﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using MySQL.Grt;
using MySQL.Utilities;


namespace MySQL.GUI
{
  public class ToolbarManager
  {
    #region Member Variables
    // Search support.
    public String lastSearchString = "";
    public ToolStripTextBox searchBox = null;
    #endregion


    public delegate bool ToolbarCallback(String command);

    public void UpdateToolbar(ToolStrip toolstrip, List<ToolbarItem> toolbarItems,
          ToolbarCallback callback)
    {
      toolstrip.Tag = callback;
      toolstrip.Items.Clear();
      toolstrip.Items.AddRange(buildToolbar(toolbarItems));
    }

    protected ToolStripItem[] buildToolbar(List<ToolbarItem> toolbarItems)
    {
      return buildToolbar(toolbarItems, false);
    }

    protected ToolStripItem[] buildToolbar(List<ToolbarItem> toolbarItems, bool addSpacer)
    {
      ToolStripItem[] itemlist;
      int i = 0;
      GrtIconManager iconManager = GrtIconManager.get_instance();

      if (!addSpacer)
        itemlist = new ToolStripItem[toolbarItems.Count];
      else
        itemlist = new ToolStripItem[toolbarItems.Count + 1];

      // rebuild the menu
      foreach (ToolbarItem subitem in toolbarItems)
      {
        switch (subitem.get_type())
        {
          case ToolbarItemType.ToolbarAction:
            {
              ToolStripButton smitem;

              smitem = new ToolStripButton();
              smitem.Name = subitem.get_name();
              smitem.Tag = subitem.get_command();
              smitem.Image = iconManager.get_icon(subitem.get_icon());
              smitem.ToolTipText = subitem.get_tooltip();
              smitem.ImageScaling = ToolStripItemImageScaling.None;

              smitem.Enabled = subitem.get_enabled();
              smitem.Click += new System.EventHandler(toolbarItem_Click);

              if (smitem.Name.EndsWith("__right"))
                smitem.Alignment = ToolStripItemAlignment.Right;

              itemlist[i++] = smitem;
              break;
            }

          case ToolbarItemType.ToolbarLabel:
            {
              ToolStripLabel smitem;

              smitem = new ToolStripLabel();
              smitem.Name = subitem.get_name();
              smitem.Tag = subitem.get_command();
              smitem.Text = subitem.get_caption();
              smitem.Font = new System.Drawing.Font(smitem.Font.FontFamily, 7);
              smitem.Enabled = subitem.get_enabled();

              if (smitem.Name.EndsWith("__right"))
                smitem.Alignment = ToolStripItemAlignment.Right;

              itemlist[i++] = smitem;
              break;
            }

          case ToolbarItemType.ToolbarSeparator:
            {
              itemlist[i++] = new ToolStripSeparator();
              if (subitem.get_name().EndsWith("__right"))
                itemlist[i - 1].Alignment = ToolStripItemAlignment.Right;
              break;
            }
          case ToolbarItemType.ToolbarRadio:
          case ToolbarItemType.ToolbarToggle:
            {
              ToolStripButton smitem;

              smitem = new ToolStripButton();
              smitem.Name = subitem.get_name();
              smitem.Tag = subitem.get_command();
              if (subitem.get_checked() && subitem.get_alt_icon() != 0)
                  smitem.Image = iconManager.get_icon(subitem.get_alt_icon());
              else
                  smitem.Image = iconManager.get_icon(subitem.get_icon());
              smitem.ImageScaling = ToolStripItemImageScaling.None;
              smitem.DisplayStyle = ToolStripItemDisplayStyle.Image;
              smitem.ToolTipText = subitem.get_tooltip();
              smitem.Enabled = subitem.get_enabled();
              smitem.Checked = subitem.get_checked();
              smitem.Click += new System.EventHandler(toolbarItem_Click);

              if (smitem.Name.EndsWith("__right"))
                smitem.Alignment = ToolStripItemAlignment.Right;

              itemlist[i++] = smitem;
              break;
            }

          case ToolbarItemType.ToolbarCheck:
            {
              CheckBox cb = new CheckBox();
              cb.Name = subitem.get_name();
              cb.Text = subitem.get_caption();
              cb.Tag = subitem.get_command();
              cb.Enabled = subitem.get_enabled();
              cb.Checked = subitem.get_checked();
              cb.Font = new System.Drawing.Font(cb.Font.FontFamily, 7);
              cb.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
              cb.Click += new System.EventHandler(checkbox_Click);
              cb.AutoSize = true;
              ToolStripControlHost chost = new ToolStripControlHost(cb);
              chost.ToolTipText = subitem.get_tooltip();
              itemlist[i++] = chost;

              if (chost.Name.EndsWith("__right"))
                chost.Alignment = ToolStripItemAlignment.Right;
              break;
            }

          case ToolbarItemType.ToolbarDropDown:
            {
              String selected_item;
              List<String> items = get_dropdown_items(subitem, out selected_item);

              if (items.Count > 0 && items[0][0] == '#')
              {
                ToolStripDropDownButton smitem;
                ToolStripDropDown dropdown= new ToolStripDropDown();
                System.Drawing.Bitmap selected= null;
                System.Drawing.SolidBrush brush= new System.Drawing.SolidBrush(System.Drawing.Color.White);
								System.Drawing.Pen pen = new System.Drawing.Pen(System.Drawing.Color.LightGray);
                List<ToolStripButton> buttons = new List<ToolStripButton>();

                smitem = new ToolStripDropDownButton();
                smitem.Name = subitem.get_name();
                smitem.Tag = subitem.get_command();
                smitem.Enabled = subitem.get_enabled();
                smitem.ToolTipText = subitem.get_tooltip();
                smitem.DropDown= dropdown;
                smitem.ShowDropDownArrow= true;
                smitem.ImageScaling= ToolStripItemImageScaling.None;
                smitem.DropDownDirection= ToolStripDropDownDirection.BelowRight;
                smitem.AutoSize = true;

                foreach (String item in items)
                {
                  try
                  {
                    ToolStripButton button = new ToolStripButton();
                    System.Drawing.Color color = System.Drawing.ColorTranslator.FromHtml(item);
                    System.Drawing.Bitmap bmp = new System.Drawing.Bitmap(20, 15);
                    System.Drawing.Graphics gfx = System.Drawing.Graphics.FromImage(bmp);
                    brush.Color = color;
                    gfx.FillRectangle(brush, new System.Drawing.Rectangle(1, 0, 18, 14));
                    gfx.DrawRectangle(pen, new System.Drawing.Rectangle(1, 0, 18, 14));

                    button.Name = item;
                    button.Image = bmp;
                    button.ImageScaling = ToolStripItemImageScaling.None;
                    button.Tag = smitem;
                    button.Click += new EventHandler(colorDropDownItem_Click);

                    if (item == selected_item || selected == null)
                      selected = bmp;

                    buttons.Add(button);
                  }
                  catch
                  {
                  }
                }
                dropdown.Items.AddRange(buttons.ToArray());

                smitem.Image = selected;

                itemlist[i++] = smitem;
              }
              else
              {
                ToolStripComboBox smitem;
                String[] strings= new String[items.Count];
                String selected= null;
                int j = 0;

                smitem = new ToolStripComboBox();
                smitem.Name = subitem.get_name();
                smitem.Tag = subitem.get_command();
                smitem.Enabled = subitem.get_enabled();
                smitem.ToolTipText = subitem.get_tooltip();
                smitem.DropDownHeight = 250;
                smitem.SelectedIndexChanged += new EventHandler(textDropDownItem_Changed);

                foreach (String item in items)
                {
                  strings[j++]= item;

                  if (item == selected_item || selected == null)
                    selected = item;
                }
                smitem.Items.AddRange(strings);

                smitem.Text = selected;

                itemlist[i++] = smitem;
              }
              break;
            }
          case ToolbarItemType.ToolbarSearch:
            {
              ToolStripTextBox tb= new ToolStripTextBox();
              tb.Name = subitem.get_name();
              tb.Tag = subitem.get_command();
              tb.Enabled = true;// subitem.get_enabled();
              tb.AutoSize = false;
              tb.Width = 180;
              tb.ToolTipText = subitem.get_tooltip();
              tb.KeyPress += new KeyPressEventHandler(tb_KeyPress);

              if (tb.Name.EndsWith("__right"))
                tb.Alignment = ToolStripItemAlignment.Right;

              itemlist[i++] = tb;
              searchBox = tb; // Keep to allow focussing it via hotkey.

              break;
            }
        }        
      }

      if (addSpacer)
      {
        ToolStripLabel smitem;

        smitem = new ToolStripLabel();
        smitem.Name = "spacerLabel";
        smitem.Tag = null;
        smitem.Text = "        ";
        smitem.Font = new System.Drawing.Font("Tahoma", 8);
        smitem.Enabled = false;

        itemlist[i++] = smitem;
      }

      return itemlist;
    }

    virtual protected List<String> get_dropdown_items(ToolbarItem subitem, out String selected)
    {
      selected = null;
      return new List<String>();
    }

    virtual protected void activate_item(ToolStripItem item)
    {
      if (item.Owner.Tag != null)
      {
        ToolbarCallback activate = item.Owner.Tag as ToolbarCallback;
        activate((String)item.Tag);
      }
    }

    void tb_KeyPress(object sender, KeyPressEventArgs e)
    {
      ToolStripTextBox item = sender as ToolStripTextBox;

      if (e.KeyChar == '\r')
      {
        e.Handled = true;
        lastSearchString = item.Text;

        activate_item(item);
      }
    }


    void toolbarItem_Click(object sender, EventArgs e)
    {
      ToolStripItem item = sender as ToolStripItem;

      if (item != null)
      {
        activate_item(item);
      }
    }

    virtual protected void toggle_checkbox_item(CheckBox item)
    {
    }

    virtual protected void select_dropdown_item(String name, String option, String value)
    {
    }

    void checkbox_Click(object sender, EventArgs e)
    {
      CheckBox item = sender as CheckBox;

      if (item != null)
      {
        toggle_checkbox_item(item);
      }
    }

    void colorDropDownItem_Click(object sender, EventArgs e)
    {
      ToolStripButton button = sender as ToolStripButton;
      ToolStripDropDownButton smitem= button.Tag as ToolStripDropDownButton;

      smitem.Image = button.Image;

      select_dropdown_item(smitem.Name, (String)smitem.Tag, button.Name);
    }

    void textDropDownItem_Changed(object sender, EventArgs e)
    {
      ToolStripComboBox combo = sender as ToolStripComboBox;

      select_dropdown_item(combo.Name, (String)combo.Tag, (String)combo.SelectedItem);
    }
  }
}
