using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MySQL.Workbench;
using MySQL.GUI.Workbench.Properties;
using MySQL.GUI.Mdc;
using MySQL.Grt;
using Aga.Controls.Tree;
using Aga.Controls.Tree.NodeControls;


namespace MySQL.GUI.Workbench
{
  public partial class SqlIdeSideBar : Form
  {
    WbContext wbContext;
    DbSqlEditor dbSqlEditor;
    TreeNodeAdv doubleClickNode = null;
    bool refreshingSchemataComboBox = false;

    public SqlIdeSideBar(WbContext WbContext)
    {
      wbContext = WbContext;

      InitializeComponent();
    }

    public void Refresh(DbSqlEditor dbSqlEditor)
    {
      RefreshEx(dbSqlEditor, false);
    }

    public void RefreshEx(DbSqlEditor dbSqlEditor, bool force)
    {
      if (dbSqlEditor != this.dbSqlEditor)
        force = true;
      this.dbSqlEditor = dbSqlEditor;
      
      // reset popup menu
      {
        SqlIdeMenuManager.MenuContext popupMenuContext;
        if (null == schemataTreeView.ContextMenuStrip)
          schemataTreeView.ContextMenuStrip = new ContextMenuStrip();
        popupMenuContext = schemataTreeView.ContextMenuStrip.Tag as SqlIdeMenuManager.MenuContext;
        if (null == popupMenuContext)
          popupMenuContext = new SqlIdeMenuManager.MenuContext();
        popupMenuContext.GetSelectedNodes = GetSelectedNodes;
        if (null != dbSqlEditor)
        {
          popupMenuContext.GetNodesMenuItems = dbSqlEditor.Backend.schema_tree().get_popup_items_for_nodes;
          popupMenuContext.TriggerNodesAction = dbSqlEditor.Backend.schema_tree().activate_popup_item_for_nodes;
        }
        SqlIdeMenuManager.InitMenu(schemataTreeView.ContextMenuStrip, popupMenuContext);
      }

      if (null == dbSqlEditor)
        return;
      if (!force)
        return;

      RefreshActiveSchemaSelector(true);

      // reload tree model
      {
        schemataTreeView.SuspendLayout();

        schemataTreeView.AsyncExpanding = false;

        SimpleGrtTreeModel schemaTreeModel = schemataTreeView.Model as SimpleGrtTreeModel;

        if (schemaTreeModel != null)
          schemaTreeModel.DetachEvents();

        schemataTreeView.Model = null;

        schemaTreeModel = new SimpleGrtTreeModel(schemataTreeView, dbSqlEditor.Backend.schema_tree(), schemaObjStateIconNode, false);
        schemaTreeModel.AddColumn(schemaObjNameNode, 0, false);

        schemataTreeView.Model = schemaTreeModel;

        schemataTreeView.AsyncExpanding = true;

        int activeSchemaIndex = dbSqlEditor.Backend.active_schema_index();
        if ((activeSchemaIndex != -1) && (schemataTreeView.Root.Children.Count > activeSchemaIndex))
        {
          schemataTreeView.SelectedNode = schemataTreeView.Root.Children[activeSchemaIndex];
          if (null != schemataTreeView.SelectedNode)
            ExpandNode(schemataTreeView.SelectedNode, 1);
        }
        schemataTreeView.ResumeLayout();
      }
    }

    public void RefreshActiveSchemaSelector(bool reloadList)
    {
      if (reloadList)
      {
        // fill combo box
        schemataComboBox.SuspendLayout();
        schemataComboBox.Items.Clear();
        foreach (String schema in dbSqlEditor.Backend.schemata())
          schemataComboBox.Items.Add(schema);
        //!schemataTreeView.Columns[0].Width = schemataTreeView.ClientSize.Width;
        schemataComboBox.ResumeLayout();
      }
      if (null == dbSqlEditor)
        return;
      refreshingSchemataComboBox = true;
      schemataComboBox.SelectedItem = dbSqlEditor.Backend.active_schema();
      refreshingSchemataComboBox = false;
    }

    private void ExpandNode(TreeNodeAdv node, int depth)
    {
      if (0 == depth)
      {
        node.Expand(true);
      }
      else
      {
        node.Expand(true);
        foreach (TreeNodeAdv childNode in node.Children)
          ExpandNode(childNode, depth - 1);
      }
    }

    private void schemataComboBox_SelectedIndexChanged(object sender, EventArgs e)
    {
      if (refreshingSchemataComboBox)
        return;
      dbSqlEditor.Backend.active_schema(schemataComboBox.SelectedItem as String);
    }

    private void schemataTreeView_DoubleClick(object sender, EventArgs e)
    {
      MouseEventArgs arguments = e as MouseEventArgs;
      NodeControlInfo info = schemataTreeView.GetNodeControlInfoAt(arguments.Location);
      SimpleGrtTreeModel schemaTreeModel = schemataTreeView.Model as SimpleGrtTreeModel;

      if (info.Control is InteractiveControl) // Label
      {
        GrtTreeNode node = info.Node.Tag as GrtTreeNode;
        if (node != null)
        {
          // Remember which node was double-clicked, if it is at least on table/view level.
          if (info.Node.Level > 2)
            doubleClickNode = info.Node;

          schemaTreeModel.GrtTree.activate_node(node.NodeId);
        }
      }
    }

    List<NodeId> GetSelectedNodes()
    {
      List<NodeId> nodes = new List<NodeId>();
      foreach (TreeNodeAdv node in schemataTreeView.SelectedNodes)
      {
        GrtTreeNode treeNode = node.Tag as GrtTreeNode;
        nodes.Add(treeNode.NodeId);
      }
      return nodes;
    }

    private void schemataTreeView_Collapsed(object sender, TreeViewAdvEventArgs e)
    {
      TreeNodeAdv node = e.Node;

      // if this node was just double-clicked and was at least table/view level, prevent collapse
      if (null != node && doubleClickNode == node)
      {
        doubleClickNode = null;
        node.Expand(true);
      }
    }

    private void schemataTreeView_Expanded(object sender, TreeViewAdvEventArgs e)
    {
      TreeNodeAdv node = e.Node;

      // if this node was just double-clicked and was at least table/view level, prevent expand
      if (null != node && doubleClickNode == node)
      {
        doubleClickNode = null;
        node.Collapse(true);
      }
    }
  }
}
