using System;
using System.ComponentModel;
using System.Windows.Forms;

using Aga.Controls.Tree;

using MySQL.Grt;
using MySQL.Workbench;
using MySQL.Controls;

namespace MySQL.GUI.Workbench
{
  public partial class UserDatatypesForm : TabDocument
  {
    private WbContext wbContext;
    private MySQL.Grt.ListModel userTypesList;
    private SimpleGrtListModel userTypesTreeModel;

    private UserDatatypesForm()
    {
      InitializeComponent();
    }

    public UserDatatypesForm(WbContext WbContext)
      : this()
    {
      wbContext = WbContext;

      TabText = "User Types";
      Text = "User Types";

      userTypesList= wbContext.get_usertypes_tree();
      userTypesTreeModel = new SimpleGrtListModel(userTypesTreeView, userTypesList, nodeStateIcon, false);
      userTypesTreeModel.AddColumn(nameTextBox, 0, true);
      userTypesTreeModel.AddColumn(definitionTextBox, 1, true);
      userTypesTreeModel.AddColumn(flagsTextBox, 2, true);
      userTypesTreeView.Model = userTypesTreeModel;

      nameTextBox.EditorInitialize += new MySQL.Utilities.EditorInitializeEventHandler(textBox_EditorInitialize);
      definitionTextBox.EditorInitialize += new MySQL.Utilities.EditorInitializeEventHandler(textBox_EditorInitialize);
    }

    ~UserDatatypesForm()
    {
      nameTextBox.EditorInitialize -= textBox_EditorInitialize;
      definitionTextBox.EditorInitialize -= textBox_EditorInitialize;
    }

    void textBox_EditorInitialize(object sender, MySQL.Utilities.EditorInitializeEventArgs e)
    {
      TextBox textbox= e.Editor as TextBox;

      if (textbox != null)
      {
        textbox.KeyDown += new KeyEventHandler(textbox_KeyDown);
      }
    }

    void textbox_KeyDown(object sender, KeyEventArgs e)
    {
      if (e.KeyCode == Keys.Tab)
      {
        Control ctl = sender as Control;

        if (ctl.Tag == nameTextBox)
        {
          nameTextBox.EndEdit(true);

          definitionTextBox.BeginEdit();
          e.Handled = true;
        }
        else if (ctl.Tag == definitionTextBox)
        {
          definitionTextBox.EndEdit(true);

          if (definitionTextBox.GetLabel(userTypesTreeView.SelectedNode) == "")
            definitionTextBox.BeginEdit();
          else
            flagsTextBox.BeginEdit();
          e.Handled = true;
        }
      }
    }

    public void UpdateTree()
    {
      userTypesTreeModel.RefreshModel();
    }

    private void userTypesTreeView_ItemDrag(object sender, ItemDragEventArgs e)
    {
      TreeNodeAdv[] nodes= (TreeNodeAdv[])e.Item;

      GrtListNode node= nodes[0].Tag as GrtListNode;

      if (node != null && node.Text != "")
      {
        DoDragDrop(userTypesList.get_grt_value(node.NodeId, 0),
          DragDropEffects.Copy);
      }
    }

    private void deleteToolStripMenuItem_Click(object sender, EventArgs e)
    {
      if (userTypesTreeView.SelectedNode != null)
      {
        GrtListNode node = userTypesTreeView.SelectedNode.Tag as GrtListNode;

        if (node != null && node.Text != "")
        {
          userTypesList.delete_node(node.NodeId);
          userTypesTreeModel.RefreshModel();
        }
      }
    }

    private void contextMenuStrip1_Opening(object sender, CancelEventArgs e)
    {
      if (null == userTypesTreeView.SelectedNode)
      {
        // assume this is Delete menu item
        contextMenuStrip1.Items[0].Enabled = false;
      }
      else
      {
        int idx = userTypesTreeView.SelectedNode.Index;
        // assume this is Delete menu item
        contextMenuStrip1.Items[0].Enabled = userTypesList.is_editable(userTypesList.get_node(idx));
      }
    }

    private void userTypesTreeView_SelectionChanged(object sender, EventArgs e)
    {
      bool edit_enabled = false;

      /* 
       * For now we don't allow editing in-place (not code exists to handle changed values anyway)..
      if (userTypesTreeView.SelectedNode != null)
      {
        int idx = userTypesTreeView.SelectedNode.Index;
        edit_enabled = userTypesList.is_editable(userTypesList.get_node(idx));
      }
      */
      nameTextBox.EditEnabled = edit_enabled;
      definitionTextBox.EditEnabled = edit_enabled;
    }

    private void button_Click(object sender, EventArgs e)
    {
      wbContext.execute_plugin("wb.form.showUserTypeEditor");
    }
  }
}

