
#ifndef _MDC_FIGURE_H_
#define _MDC_FIGURE_H_

#include "mdc_canvas_item.h"

namespace mdc {

class MYSQLCANVAS_PUBLIC_FUNC Figure : public CanvasItem {
public:
  Figure(Layer *layer);

  virtual void render(CairoCtx *cr);
  virtual void render_gl(mdc::CairoCtx *cr);
  virtual Point get_intersection_with_line_to(const Point &p);

  void set_pen_color(const Color &color);
  void set_fill_color(const Color &color);
  void set_line_width(float width);

  virtual void draw_contents(CairoCtx *cr)= 0;
  virtual void draw_contents_gl();

  virtual void stroke_outline(CairoCtx *cr, float offset);
  virtual void stroke_outline_gl(float offset);

protected:
  Color _pen_color;
  Color _fill_color;
  float _line_width;
};


};

#endif /* _MDC_FIGURE_H_ */
