#ifndef _MDC_ICON_TEXT_H_
#define _MDC_ICON_TEXT_H_

#include "mdc_text.h"

namespace mdc {
  
class MYSQLCANVAS_PUBLIC_FUNC IconTextFigure : public TextFigure {
public:
    enum Alignment {
      Left,
      Center,
      Right
    };
    
    IconTextFigure(Layer *layer);
    virtual ~IconTextFigure();
    
    virtual Size calc_min_size();
    
    virtual void draw_contents(CairoCtx *cr);
    
    void set_icon(cairo_surface_t *icon);
    cairo_surface_t *get_icon() { return _icon; }

    void set_spacing(double space);
    double get_spacing() { return _spacing; }
    
    virtual void auto_size();

protected:
    cairo_surface_t *_icon;
    double _spacing;
  };
  
  
};


#endif /* _MDC_ICON_TEXT_H_ */
